/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.twincolgrid.Book;
import com.flowingcode.vaadin.addons.twincolgrid.TwinColGrid;
import com.flowingcode.vaadin.addons.twincolgrid.TwincolDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@PageTitle(value="Drag and Drop")
@DemoSource
@Route(value="twincolgrid/drag-and-drop", layout=TwincolDemoView.class)
public class DragAndDropDemo
extends VerticalLayout {
    private final Set<Book> selectedBooks = new HashSet<Book>();
    private final List<Book> availableBooks = new ArrayList<Book>();
    private TwinColGrid<Book> twinColGrid;

    public DragAndDropDemo() {
        this.initializeData();
        this.twinColGrid = new TwinColGrid(this.availableBooks).withAvailableGridCaption("Available books").withSelectionGridCaption("Added books").withoutAddAllButton().withSizeFull().withDragAndDropSupport().withSelectionGridReordering().selectRowOnClick();
        this.twinColGrid.addColumn(Book::getIsbn).setComparator(Book::getIsbn).setHeader("ISBN");
        this.twinColGrid.addColumn(Book::getTitle).setComparator(Book::getTitle).setHeader("Title");
        this.twinColGrid.setCaption("TwinColGrid demo with drag and drop support");
        this.twinColGrid.setValue(this.selectedBooks);
        Span countLabel = new Span("Selected items in left grid: 0");
        this.twinColGrid.getAvailableGrid().addSelectionListener((SelectionListener & Serializable)e -> countLabel.setText("Selected items in left grid: " + e.getAllSelectedItems().size()));
        this.twinColGrid.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> countLabel.setText("Selected items in left grid: 0"));
        this.add(new Component[]{this.twinColGrid, countLabel});
        this.addReorderingToggle();
        this.setSizeFull();
    }

    private void initializeData() {
        this.selectedBooks.add(new Book("1478375108", "Vaadin Recipes"));
        this.selectedBooks.add(new Book("9789526800677", "Book of Vaadin: Volume 2 "));
        this.availableBooks.add(new Book("1478375108", "Vaadin Recipes"));
        this.availableBooks.add(new Book("9781849515221", "Learning Vaadin"));
        this.availableBooks.add(new Book("9781782162261", "Vaadin 7 UI Design By Example: Beginner\u2019s Guide"));
        this.availableBooks.add(new Book("9781849518802", "Vaadin 7 Cookbook"));
        this.availableBooks.add(new Book("9526800605", "Book of Vaadin: 7th Edition, 1st Revision"));
        this.availableBooks.add(new Book("9789526800677", "Book of Vaadin: Volume 2 "));
        this.availableBooks.add(new Book("9529267533", "Book of Vaadin"));
        this.availableBooks.add(new Book("1782169776", "Learning Vaadin 7, Second Edition"));
    }

    private void addReorderingToggle() {
        Checkbox checkbox = new Checkbox("Selection Grid reordering allowed", true);
        Span description = new Span("(Reordering is disabled while the grid is sorted)");
        description.setVisible(false);
        SerializableRunnable & Serializable refresh = (SerializableRunnable & Serializable)() -> {
            boolean sorted = !this.twinColGrid.getSelectionGrid().getSortOrder().isEmpty();
            boolean allowed = this.twinColGrid.isSelectionGridReorderingAllowed();
            description.setVisible(sorted && allowed);
        };
        checkbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> {
            this.twinColGrid.setSelectionGridReorderingAllowed(((Boolean)ev.getValue()).booleanValue());
            refresh.run();
        });
        this.twinColGrid.getSelectionGrid().addSortListener((ComponentEventListener & Serializable)ev -> refresh.run());
        this.add(new Component[]{new Div(new Component[]{checkbox, description})});
    }
}

