/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.flowingcode.vaadin.addons.twincolgrid.TwinColGrid;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TwinColGridTest {
    @Test
    public void testGetValueReturnsModifiableSet() {
        TwinColGrid twinColGrid = new TwinColGrid();
        LinkedHashSet<String> initialSelection = new LinkedHashSet<String>(Arrays.asList("Dasher", "Dancer"));
        twinColGrid.setValue(initialSelection);
        Set selectedItems = twinColGrid.getValue();
        Assert.assertNotNull((String)"The set returned by getValue() should not be null.", (Object)selectedItems);
        Assert.assertEquals((String)"The set should contain 2 items.", (long)2L, (long)selectedItems.size());
        Assert.assertTrue((String)"The set should contain 'Dasher'.", (boolean)selectedItems.contains("Dasher"));
        Assert.assertTrue((String)"The set should contain 'Dancer'.", (boolean)selectedItems.contains("Dancer"));
        boolean added = false;
        try {
            added = selectedItems.add("Prancer");
        }
        catch (UnsupportedOperationException e) {
            Assert.fail((String)"The set should be modifiable, but add operation threw UnsupportedOperationException.");
        }
        Assert.assertTrue((String)"The add operation should return true, indicating the set was modified.", (boolean)added);
        Assert.assertEquals((String)"The set should now contain 3 items.", (long)3L, (long)selectedItems.size());
        Assert.assertTrue((String)"The set should contain 'Prancer'.", (boolean)selectedItems.contains("Prancer"));
        Set internalSelectionAfterModification = twinColGrid.getValue();
        Assert.assertNotNull((String)"The internal set fetched after modification should not be null.", (Object)internalSelectionAfterModification);
        Assert.assertEquals((String)"The internal set should still contain 2 original items.", (long)2L, (long)internalSelectionAfterModification.size());
        Assert.assertTrue((String)"The internal set should still contain 'Dasher'.", (boolean)internalSelectionAfterModification.contains("Dasher"));
        Assert.assertTrue((String)"The internal set should still contain 'Dancer'.", (boolean)internalSelectionAfterModification.contains("Dancer"));
        Assert.assertFalse((String)"The internal set should NOT contain 'Prancer'.", (boolean)internalSelectionAfterModification.contains("Prancer"));
    }
}

