/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.flowingcode.vaadin.addons.twincolgrid.FilterableTwinColumn;
import com.flowingcode.vaadin.addons.twincolgrid.LegacyTwinColGrid;
import com.flowingcode.vaadin.addons.twincolgrid.TwinColGridListAdapter;
import com.flowingcode.vaadin.addons.twincolgrid.TwinColumn;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridNoneSelectionModel;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.grid.dnd.GridDropLocation;
import com.vaadin.flow.component.grid.dnd.GridDropMode;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

@JsModule(value="./src/fc-twin-col-grid-auto-resize.js")
@CssImport.Container(value={@CssImport(value="./styles/twin-col-grid-button.css"), @CssImport(value="./styles/twincol-grid.css")})
public class TwinColGrid<T>
extends VerticalLayout
implements HasValueAndElement<HasValue.ValueChangeEvent<Set<T>>, Set<T>>,
HasComponents,
HasSize,
HasValidation {
    private final TwinColModel<T> available;
    private final TwinColModel<T> selection;
    private Label captionLabel;
    private final Button addAllButton = this.createActionButton();
    private final Button addButton = this.createActionButton();
    private final Button removeButton = this.createActionButton();
    private final Button removeAllButton = this.createActionButton();
    private Component buttonContainer;
    private Grid<T> draggedGrid;
    private Span fakeButtonContainerLabel = new Span();
    private Span errorMessageSpan = new Span();
    private Orientation orientation = Orientation.HORIZONTAL;
    private boolean autoResize = false;
    private boolean isFromClient = false;
    private boolean explicitHeaderRow = true;
    private String layoutId;
    private static final String COMPONENT_DATA_FILTER = "TwinColGrid#filterTF";

    private static <T> ListDataProvider<T> emptyDataProvider() {
        return DataProvider.ofCollection(new LinkedHashSet());
    }

    public TwinColGrid() {
        this(Grid::new);
    }

    public TwinColGrid(Supplier<Grid<T>> gridSupplier) {
        this(gridSupplier.get(), gridSupplier.get());
    }

    public TwinColGrid(@NonNull Grid<T> availableGrid, @NonNull Grid<T> selectionGrid) {
        if (availableGrid == null) {
            throw new NullPointerException("availableGrid is marked non-null but is null");
        }
        if (selectionGrid == null) {
            throw new NullPointerException("selectionGrid is marked non-null but is null");
        }
        if (availableGrid == selectionGrid) {
            throw new IllegalArgumentException("Grids must be different");
        }
        this.available = new TwinColModel<T>(availableGrid, "twincol-grid-available");
        this.selection = new TwinColModel<T>(selectionGrid, "twincol-grid-selection");
        this.errorMessageSpan.setClassName("twincol-grid-error-message");
        this.selection.layout.addComponentAtIndex(1, (Component)this.errorMessageSpan);
        this.setClassName("twincol-grid");
        this.setMargin(false);
        this.setPadding(false);
        this.setDataProvider(TwinColGrid.emptyDataProvider());
        ListDataProvider rightGridDataProvider = DataProvider.ofCollection(new LinkedHashSet());
        this.getSelectionGrid().setDataProvider((DataProvider)rightGridDataProvider);
        this.getAvailableGrid().setWidth("100%");
        this.getSelectionGrid().setWidth("100%");
        this.addAllButton.addClickListener((ComponentEventListener & Serializable)e -> {
            List filteredItems = this.available.getDataProvider().withConfigurableFilter().fetch(new Query()).collect(Collectors.toList());
            this.updateSelection(new LinkedHashSet(filteredItems), new HashSet(), true);
        });
        this.addButton.addClickListener((ComponentEventListener & Serializable)e -> this.updateSelection(new LinkedHashSet(this.getAvailableGrid().getSelectedItems()), new HashSet(), true));
        this.removeButton.addClickListener((ComponentEventListener & Serializable)e -> this.updateSelection(new HashSet(), this.getSelectionGrid().getSelectedItems(), true));
        this.removeAllButton.addClickListener((ComponentEventListener & Serializable)e -> {
            List filteredItems = this.selection.getDataProvider().withConfigurableFilter().fetch(new Query()).collect(Collectors.toList());
            this.updateSelection(new HashSet(), new HashSet(filteredItems), true);
        });
        this.getElement().getStyle().set("display", "flex");
        this.forEachSide(side -> {
            side.grid.setSelectionMode(Grid.SelectionMode.MULTI);
            side.columnLabel.setVisible(false);
            side.layout.setSizeFull();
            side.layout.setMargin(false);
            side.layout.setPadding(false);
            side.layout.setSpacing(false);
        });
        this.initMoveItemsByDoubleClick();
        this.add(new Component[]{this.createContainerLayout()});
        this.setSizeUndefined();
    }

    private void initMoveItemsByDoubleClick() {
        this.setMoveItemsByDoubleClick(!(this instanceof LegacyTwinColGrid));
    }

    public void setCaption(String captionText) {
        if (captionText != null) {
            if (this.captionLabel == null) {
                this.captionLabel = new Label();
                this.captionLabel.setFor(this.layoutId);
                this.addComponentAsFirst((Component)this.captionLabel);
            }
            this.captionLabel.setText(captionText);
        } else if (this.captionLabel != null) {
            this.remove(new Component[]{this.captionLabel});
            this.captionLabel = null;
        }
    }

    public String getCaption() {
        return Optional.ofNullable(this.captionLabel).map(HasText::getText).orElse(null);
    }

    public TwinColGrid<T> withOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.updateContainerLayout();
            this.available.grid.getDataProvider().refreshAll();
            this.selection.grid.getDataProvider().refreshAll();
        }
        return this;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    private void updateContainerLayout() {
        Component oldContainerComponent = (Component)this.available.layout.getParent().get();
        Component newContainerComponent = this.createContainerLayout();
        this.replace(oldContainerComponent, newContainerComponent);
    }

    private Component createContainerLayout() {
        switch (this.orientation) {
            case HORIZONTAL: {
                this.addButton.setIcon((Component)VaadinIcon.ANGLE_RIGHT.create());
                this.addAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create());
                this.removeButton.setIcon((Component)VaadinIcon.ANGLE_LEFT.create());
                this.removeAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create());
                return this.createHorizontalContainer(false);
            }
            case HORIZONTAL_REVERSE: {
                this.addButton.setIcon((Component)VaadinIcon.ANGLE_LEFT.create());
                this.addAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create());
                this.removeButton.setIcon((Component)VaadinIcon.ANGLE_RIGHT.create());
                this.removeAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create());
                return this.createHorizontalContainer(true);
            }
            case VERTICAL: {
                this.addButton.setIcon((Component)VaadinIcon.ANGLE_DOWN.create());
                this.addAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_DOWN.create());
                this.removeButton.setIcon((Component)VaadinIcon.ANGLE_UP.create());
                this.removeAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_UP.create());
                return this.createVerticalContainer(false);
            }
            case VERTICAL_REVERSE: {
                this.addButton.setIcon((Component)VaadinIcon.ANGLE_UP.create());
                this.addAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_UP.create());
                this.removeButton.setIcon((Component)VaadinIcon.ANGLE_DOWN.create());
                this.removeAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_DOWN.create());
                return this.createVerticalContainer(true);
            }
        }
        throw new IllegalStateException();
    }

    private String getLayoutId() {
        return Optional.ofNullable(this.layoutId).orElseGet(() -> {
            this.layoutId = "twincol-" + UUID.randomUUID();
            return this.layoutId;
        });
    }

    private HorizontalLayout createHorizontalContainer(boolean reverse) {
        this.buttonContainer = this.getVerticalButtonContainer();
        HorizontalLayout hl = reverse ? new HorizontalLayout(new Component[]{this.selection.layout, this.buttonContainer, this.available.layout}) : new HorizontalLayout(new Component[]{this.available.layout, this.buttonContainer, this.selection.layout});
        hl.setId(this.getLayoutId());
        hl.getElement().getStyle().set("min-height", "0px");
        hl.getElement().getStyle().set("flex", "1 1 0px");
        hl.setMargin(false);
        hl.setWidthFull();
        return hl;
    }

    private VerticalLayout createVerticalContainer(boolean reverse) {
        this.buttonContainer = this.getHorizontalButtonContainer();
        VerticalLayout vl = reverse ? new VerticalLayout(new Component[]{this.selection.layout, this.buttonContainer, this.available.layout}) : new VerticalLayout(new Component[]{this.available.layout, this.buttonContainer, this.selection.layout});
        vl.setId(this.getLayoutId());
        vl.getElement().getStyle().set("min-width", "0px");
        vl.getElement().getStyle().set("flex", "1 1 0px");
        vl.setMargin(false);
        vl.setPadding(false);
        vl.setHeightFull();
        return vl;
    }

    private VerticalLayout getVerticalButtonContainer() {
        this.fakeButtonContainerLabel.getElement().setProperty("innerHTML", "&nbsp;");
        this.fakeButtonContainerLabel.setClassName("fake-button-container-label");
        this.updateFakeButtonContainerVisiblity();
        VerticalLayout vButtonContainer = new VerticalLayout(new Component[]{this.fakeButtonContainerLabel, this.addAllButton, this.addButton, this.removeButton, this.removeAllButton});
        vButtonContainer.setPadding(false);
        vButtonContainer.setSpacing(false);
        vButtonContainer.setSizeUndefined();
        return vButtonContainer;
    }

    private void updateFakeButtonContainerVisiblity() {
        this.fakeButtonContainerLabel.setVisible(this.available.columnLabel.isVisible() || this.selection.columnLabel.isVisible());
    }

    private HorizontalLayout getHorizontalButtonContainer() {
        HorizontalLayout hButtonContainer = new HorizontalLayout(new Component[]{this.addAllButton, this.addButton, this.removeButton, this.removeAllButton});
        hButtonContainer.setPadding(false);
        hButtonContainer.setSizeUndefined();
        return hButtonContainer;
    }

    public Grid<T> getAvailableGrid() {
        return this.available.grid;
    }

    public Grid<T> getSelectionGrid() {
        return this.selection.grid;
    }

    private void forEachSide(Consumer<TwinColModel<T>> consumer) {
        consumer.accept(this.available);
        consumer.accept(this.selection);
    }

    public final void forEachGrid(Consumer<Grid<T>> consumer) {
        consumer.accept(this.available.grid);
        consumer.accept(this.selection.grid);
    }

    public void setItems(Collection<T> items) {
        this.setDataProvider(DataProvider.ofCollection(items));
    }

    public void setItems(Stream<T> items) {
        this.setDataProvider(DataProvider.fromStream(items));
    }

    public void clearAll() {
        this.updateSelection(new HashSet(), new HashSet<T>(this.selection.getItems()), false);
    }

    protected void setDataProvider(ListDataProvider<T> dataProvider) {
        this.getAvailableGrid().setDataProvider(dataProvider);
        if (this.selection.getDataProvider() != null) {
            this.selection.getItems().clear();
            this.selection.getDataProvider().refreshAll();
        }
    }

    public TwinColGrid(Collection<T> options) {
        this();
        this.setDataProvider(DataProvider.ofCollection(new LinkedHashSet<T>(options)));
    }

    public TwinColGrid<T> withAvailableGridCaption(String caption) {
        this.available.columnLabel.setText(caption);
        this.available.columnLabel.setVisible(true);
        this.updateFakeButtonContainerVisiblity();
        return this;
    }

    public TwinColGrid<T> withSelectionGridCaption(String caption) {
        this.selection.columnLabel.setText(caption);
        this.selection.columnLabel.setVisible(true);
        this.updateFakeButtonContainerVisiblity();
        return this;
    }

    public TwinColGrid<T> createFirstHeaderRow(boolean value) {
        this.explicitHeaderRow = value;
        return this;
    }

    private void createFirstHeaderRowIfNeeded() {
        if (this.explicitHeaderRow) {
            this.forEachGrid(grid -> {
                if (grid.getColumns().isEmpty() && grid.getHeaderRows().isEmpty()) {
                    grid.appendHeaderRow();
                }
            });
        }
    }

    public TwinColumn<T> addColumn(ItemLabelGenerator<T> itemLabelGenerator) {
        this.createFirstHeaderRowIfNeeded();
        Grid.Column availableColumn = this.getAvailableGrid().addColumn((Renderer)new TextRenderer(itemLabelGenerator));
        Grid.Column selectionColumn = this.getSelectionGrid().addColumn((Renderer)new TextRenderer(itemLabelGenerator));
        return new TwinColumn(availableColumn, selectionColumn);
    }

    public TwinColGrid<T> withoutAddAllButton() {
        this.addAllButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutRemoveAllButton() {
        this.removeAllButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutAddButton() {
        this.addButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutRemoveButton() {
        this.removeButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    private void checkContainerVisibility() {
        boolean atLeastOneIsVisible = this.removeButton.isVisible() || this.addButton.isVisible() || this.removeAllButton.isVisible() || this.addAllButton.isVisible();
        this.buttonContainer.setVisible(atLeastOneIsVisible);
    }

    public TwinColGrid<T> withSizeFull() {
        this.setWidthFull();
        this.getElement().getStyle().set("flex-grow", "1");
        return this;
    }

    public TwinColGrid<T> withDragAndDropSupport() {
        this.configDragAndDrop(this.available, this.selection);
        this.configDragAndDrop(this.selection, this.available);
        return this;
    }

    public String getAvailableGridCaption() {
        return this.available.columnLabel.getText();
    }

    public String getSelectionGridCaption() {
        return this.selection.columnLabel.getText();
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value);
        Set newValues = value.stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet<T> oldValues = new LinkedHashSet<T>(this.selection.getItems());
        oldValues.removeAll(newValues);
        this.updateSelection(newValues, oldValues, false);
    }

    public Set<T> getValue() {
        return this.collectValue(Collectors.toCollection(LinkedHashSet::new));
    }

    <C> C collectValue(Collector<T, ?, C> collector) {
        Stream<T> stream = this.selection.getItems().stream();
        SerializableComparator comparator = TwinColGrid.createSortingComparator(this.selection.grid);
        if (comparator != null) {
            return stream.sorted((Comparator<T>)comparator).collect(collector);
        }
        return stream.collect(collector);
    }

    private static <T> SerializableComparator<T> createSortingComparator(Grid<T> grid) {
        BinaryOperator operator = (comparator1, comparator2) -> comparator1.thenComparing((Comparator)comparator2)::compare;
        return grid.getSortOrder().stream().map(order -> order.getSorted().getComparator(order.getDirection())).reduce(operator).orElse(null);
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<Set<T>>> listener) {
        return this.selection.getDataProvider().addDataProviderListener((DataProviderListener & Serializable)e -> {
            AbstractField.ComponentValueChangeEvent e2 = new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, this.isFromClient);
            listener.valueChanged((HasValue.ValueChangeEvent)e2);
        });
    }

    public boolean isReadOnly() {
        return this.getAvailableGrid().getSelectionModel() instanceof GridNoneSelectionModel;
    }

    public boolean isRequiredIndicatorVisible() {
        return this.getElement().getAttribute("required") != null;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessageSpan.setText(errorMessage);
    }

    public String getErrorMessage() {
        return this.errorMessageSpan.getText();
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setAttribute("invalid", invalid);
    }

    public boolean isInvalid() {
        return this.getElement().getAttribute("invalid") != null;
    }

    public void setReadOnly(boolean readOnly) {
        this.getAvailableGrid().setSelectionMode(readOnly ? Grid.SelectionMode.NONE : Grid.SelectionMode.MULTI);
        this.getSelectionGrid().setSelectionMode(readOnly ? Grid.SelectionMode.NONE : Grid.SelectionMode.MULTI);
        this.addButton.setEnabled(!readOnly);
        this.removeButton.setEnabled(!readOnly);
        this.addAllButton.setEnabled(!readOnly);
        this.removeAllButton.setEnabled(!readOnly);
        this.setClassName("readonly", readOnly);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        this.getElement().setAttribute("required", requiredIndicatorVisible);
    }

    private void updateSelection(Set<T> addedItems, Set<T> removedItems, boolean isFromClient) {
        this.isFromClient = isFromClient;
        this.available.getItems().addAll(removedItems);
        this.available.getItems().removeAll(addedItems);
        this.selection.getItems().addAll(addedItems);
        this.selection.getItems().removeAll(removedItems);
        this.forEachGrid(grid -> {
            grid.getDataProvider().refreshAll();
            grid.getSelectionModel().deselectAll();
        });
    }

    private void configDragAndDrop(TwinColModel<T> sourceModel, TwinColModel<T> targetModel) {
        LinkedHashSet draggedItems = new LinkedHashSet();
        sourceModel.grid.setRowsDraggable(true);
        sourceModel.grid.addDragStartListener((ComponentEventListener & Serializable)event -> {
            this.draggedGrid = sourceModel.grid;
            if (!(sourceModel.grid.getSelectionModel() instanceof GridNoneSelectionModel)) {
                draggedItems.addAll(event.getDraggedItems());
            }
            sourceModel.grid.setDropMode((GridDropMode)(sourceModel.isReorderingEnabled() ? GridDropMode.BETWEEN : null));
            targetModel.grid.setDropMode(targetModel.isReorderingEnabled() ? GridDropMode.BETWEEN : GridDropMode.ON_GRID);
        });
        sourceModel.grid.addDragEndListener((ComponentEventListener & Serializable)event -> {
            if (targetModel.droppedInsideGrid && sourceModel.grid == this.draggedGrid && !draggedItems.isEmpty()) {
                ListDataProvider dragGridSourceDataProvider = sourceModel.getDataProvider();
                dragGridSourceDataProvider.getItems().removeAll(draggedItems);
                dragGridSourceDataProvider.refreshAll();
                targetModel.droppedInsideGrid = false;
                draggedItems.clear();
                sourceModel.grid.deselectAll();
                sourceModel.grid.setDropMode(null);
                targetModel.grid.setDropMode(null);
            }
            draggedItems.clear();
        });
        targetModel.grid.addDropListener((ComponentEventListener & Serializable)event -> {
            if (!draggedItems.isEmpty()) {
                this.isFromClient = true;
                targetModel.droppedInsideGrid = true;
                T dropOverItem = event.getDropTargetItem().orElse(null);
                this.addItems(targetModel, draggedItems, dropOverItem, event.getDropLocation());
            }
        });
        sourceModel.grid.addDropListener((ComponentEventListener & Serializable)event -> event.getDropTargetItem().ifPresent(dropOverItem -> {
            if (sourceModel.isReorderingEnabled() && event.getSource() == this.draggedGrid && !draggedItems.contains(dropOverItem) && !draggedItems.isEmpty()) {
                this.isFromClient = true;
                sourceModel.getItems().removeAll(draggedItems);
                this.addItems(sourceModel, draggedItems, dropOverItem, event.getDropLocation());
                draggedItems.clear();
                this.draggedGrid = null;
            }
        }));
    }

    private void addItems(TwinColModel<T> model, Collection<T> draggedItems, T dropOverItem, GridDropLocation dropLocation) {
        if (dropOverItem != null) {
            Collection<T> collection = model.getItems();
            ArrayList<T> list = new ArrayList<T>(collection);
            int dropIndex = list.indexOf(dropOverItem) + (dropLocation == GridDropLocation.BELOW ? 1 : 0);
            list.addAll(dropIndex, draggedItems);
            model.getItems().clear();
            model.getItems().addAll(list);
            model.getDataProvider().refreshAll();
        } else {
            model.getItems().addAll(draggedItems);
            model.getDataProvider().refreshAll();
        }
    }

    public TwinColGrid<T> withSelectionGridReordering() {
        this.setSelectionGridReorderingAllowed(true);
        return this;
    }

    public void setSelectionGridReorderingAllowed(boolean value) {
        this.selection.allowReordering = value;
    }

    public boolean isSelectionGridReorderingAllowed() {
        return this.selection.allowReordering;
    }

    private Grid.Column<T> createFilterableColumn(TwinColModel<T> side, ItemLabelGenerator<T> itemLabelGenerator, SerializableFunction<T, String> filterableValue) {
        Grid.Column column = side.grid.addColumn((Renderer)new TextRenderer(itemLabelGenerator));
        TextField filterTF = new TextField();
        filterTF.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> side.getDataProvider().addFilter((SerializablePredicate & Serializable)filterableEntity -> StringUtils.containsIgnoreCase((CharSequence)((CharSequence)filterableValue.apply(filterableEntity)), (CharSequence)filterTF.getValue())));
        if (side.headerRow == null) {
            side.headerRow = side.grid.appendHeaderRow();
        }
        ((HeaderRow.HeaderCell)side.headerRow.getCell(column)).setComponent((Component)filterTF);
        filterTF.setValueChangeMode(ValueChangeMode.EAGER);
        filterTF.setSizeFull();
        ComponentUtil.setData((Component)column, (String)COMPONENT_DATA_FILTER, (Object)filterTF);
        return column;
    }

    static TextField getFilterTextField(Grid.Column<?> column) {
        return (TextField)ComponentUtil.getData(column, (String)COMPONENT_DATA_FILTER);
    }

    public FilterableTwinColumn<T> addFilterableColumn(ItemLabelGenerator<T> itemLabelGenerator) {
        return this.addFilterableColumn(itemLabelGenerator, (SerializableFunction<T, String>)itemLabelGenerator);
    }

    public FilterableTwinColumn<T> addFilterableColumn(ItemLabelGenerator<T> itemLabelGenerator, SerializableFunction<T, String> filterableValue) {
        this.createFirstHeaderRowIfNeeded();
        Grid.Column<T> availableColumn = this.createFilterableColumn(this.available, itemLabelGenerator, filterableValue);
        Grid.Column<T> selectionColumn = this.createFilterableColumn(this.selection, itemLabelGenerator, filterableValue);
        return new FilterableTwinColumn<T>(availableColumn, selectionColumn);
    }

    public TwinColGrid<T> selectRowOnClick() {
        this.forEachGrid(grid -> {
            grid.getElement().executeJs("if (this.querySelector('vaadin-grid-flow-selection-column')) { this.querySelector('vaadin-grid-flow-selection-column').hidden = true }", new Serializable[0]);
            grid.addItemClickListener((ComponentEventListener & Serializable)c -> {
                if (grid.getSelectedItems().contains(c.getItem())) {
                    grid.deselect(c.getItem());
                } else {
                    grid.select(c.getItem());
                }
            });
        });
        return this;
    }

    public HasValue<? extends HasValue.ValueChangeEvent<List<T>>, List<T>> asList() {
        return new TwinColGridListAdapter(this);
    }

    public Set<T> getEmptyValue() {
        return Collections.emptySet();
    }

    private Button createActionButton() {
        Button button = new Button();
        button.addThemeName("twin-col-grid-button");
        return button;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        if (autoResize != this.autoResize) {
            if (autoResize) {
                this.getElement().executeJs("fcTwinColGridAutoResize.observe($0)", new Serializable[]{this});
            } else {
                this.getElement().executeJs("fcTwinColGridAutoResize.unobserve($0)", new Serializable[]{this});
            }
            this.autoResize = autoResize;
        }
    }

    public void setMoveItemsByDoubleClick(boolean value) {
        this.forEachSide(side -> {
            if (value && side.moveItemsByDoubleClick == null) {
                side.moveItemsByDoubleClick = side.grid.addItemDoubleClickListener((ComponentEventListener & Serializable)ev -> {
                    if (!this.isReadOnly()) {
                        Set<Object> item = Collections.singleton(ev.getItem());
                        if (side == this.available) {
                            this.updateSelection(item, Collections.emptySet(), true);
                        }
                        if (side == this.selection) {
                            this.updateSelection(Collections.emptySet(), item, true);
                        }
                    }
                });
            }
            if (!value && side.moveItemsByDoubleClick != null) {
                side.moveItemsByDoubleClick.remove();
                side.moveItemsByDoubleClick = null;
            }
        });
    }

    @ClientCallable
    private void updateOrientationOnResize(int width, int height) {
        if (height > width) {
            this.withOrientation(Orientation.VERTICAL);
        } else {
            this.withOrientation(Orientation.HORIZONTAL);
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL,
        HORIZONTAL_REVERSE,
        VERTICAL_REVERSE;

    }

    private static final class TwinColModel<T>
    implements Serializable {
        final Grid<T> grid;
        final Label columnLabel = new Label();
        final VerticalLayout layout;
        HeaderRow headerRow;
        boolean droppedInsideGrid = false;
        boolean allowReordering = false;
        Registration moveItemsByDoubleClick;

        TwinColModel(@NonNull Grid<T> grid, String className) {
            if (grid == null) {
                throw new NullPointerException("grid is marked non-null but is null");
            }
            this.grid = grid;
            this.layout = new VerticalLayout(new Component[]{this.columnLabel, grid});
            grid.setId("grid-" + UUID.randomUUID().toString());
            this.columnLabel.setFor(grid);
            this.layout.setClassName(className);
            grid.setClassName("twincol-grid-items");
            this.columnLabel.setClassName("twincol-grid-label");
        }

        ListDataProvider<T> getDataProvider() {
            return (ListDataProvider)this.grid.getDataProvider();
        }

        Collection<T> getItems() {
            return this.getDataProvider().getItems();
        }

        boolean isReorderingEnabled() {
            return this.allowReordering && this.grid.getSortOrder().isEmpty();
        }
    }
}

