/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.flowingcode.vaadin.addons.twincolgrid.TwinColGrid;
import com.flowingcode.vaadin.addons.twincolgrid.TwinColGridListAdapter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TwinColGridListAdapterTest {
    @Test
    public void testGetValueReturnsModifiableListAndDoesNotAffectInternalState() {
        TwinColGrid twinColGrid = new TwinColGrid();
        TwinColGridListAdapter adapter = new TwinColGridListAdapter(twinColGrid);
        LinkedHashSet<String> initialSelection = new LinkedHashSet<String>(Arrays.asList("Vixen", "Comet"));
        twinColGrid.setValue(initialSelection);
        List listFromAdapter = adapter.getValue();
        Assert.assertNotNull((String)"The list returned by getValue() should not be null.", (Object)listFromAdapter);
        Assert.assertEquals((String)"The list should contain 2 items.", (long)2L, (long)listFromAdapter.size());
        Assert.assertTrue((String)"The list should contain 'Vixen'.", (boolean)listFromAdapter.contains("Vixen"));
        Assert.assertTrue((String)"The list should contain 'Comet'.", (boolean)listFromAdapter.contains("Comet"));
        boolean added = false;
        try {
            added = listFromAdapter.add("Cupid");
        }
        catch (UnsupportedOperationException e) {
            Assert.fail((String)"The list should be modifiable, but add operation threw UnsupportedOperationException.");
        }
        Assert.assertTrue((String)"The add operation should return true, indicating the list was modified.", (boolean)added);
        Assert.assertEquals((String)"The list from adapter should now contain 3 items.", (long)3L, (long)listFromAdapter.size());
        Assert.assertTrue((String)"The list from adapter should now contain 'Cupid'.", (boolean)listFromAdapter.contains("Cupid"));
        List secondListFromAdapter = adapter.getValue();
        Assert.assertNotNull((String)"The second list returned by getValue() should not be null.", (Object)secondListFromAdapter);
        Assert.assertEquals((String)"The second list should still contain 2 items (original state).", (long)2L, (long)secondListFromAdapter.size());
        Assert.assertTrue((String)"The second list should contain 'Vixen'.", (boolean)secondListFromAdapter.contains("Vixen"));
        Assert.assertTrue((String)"The second list should contain 'Comet'.", (boolean)secondListFromAdapter.contains("Comet"));
        Assert.assertFalse((String)"The second list should NOT contain 'Cupid'.", (boolean)secondListFromAdapter.contains("Cupid"));
        Set twinColGridValue = twinColGrid.getValue();
        Assert.assertNotNull((String)"The TwinColGrid's value should not be null.", (Object)twinColGridValue);
        Assert.assertEquals((String)"The TwinColGrid's value should contain 2 items.", (long)2L, (long)twinColGridValue.size());
        Assert.assertTrue((String)"The TwinColGrid's value should contain 'Vixen'.", (boolean)twinColGridValue.contains("Vixen"));
        Assert.assertTrue((String)"The TwinColGrid's value should contain 'Comet'.", (boolean)twinColGridValue.contains("Comet"));
        Assert.assertFalse((String)"The TwinColGrid's value should NOT contain 'Cupid'.", (boolean)twinColGridValue.contains("Cupid"));
    }
}

