/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.twincolgrid.Book;
import com.flowingcode.vaadin.addons.twincolgrid.Library;
import com.flowingcode.vaadin.addons.twincolgrid.TwinColGrid;
import com.flowingcode.vaadin.addons.twincolgrid.TwincolDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@PageTitle(value="Bound")
@DemoSource
@Route(value="twincolgrid/bound", layout=TwincolDemoView.class)
public class BoundDemo
extends VerticalLayout {
    private final List<Book> selectedBooks = new ArrayList<Book>();
    private final List<Book> availableBooks = new ArrayList<Book>();

    public BoundDemo() {
        this.initializeData();
        Library library = new Library("Public Library", this.selectedBooks);
        TwinColGrid twinColGrid = new TwinColGrid(this.availableBooks).withAvailableGridCaption("Available books").withSelectionGridCaption("Added books").withoutRemoveAllButton().withSizeFull().selectRowOnClick();
        twinColGrid.addColumn(Book::getIsbn).setComparator(Book::getIsbn).setHeader("ISBN");
        twinColGrid.addColumn(Book::getTitle).setComparator(Book::getTitle).setHeader("Title");
        twinColGrid.setCaption("TwinColGrid demo with Binder and row select without checkbox");
        Binder binder = new Binder();
        binder.forField(twinColGrid.asList()).asRequired("You must add at least one book.").bind(Library::getBooks, Library::setBooks);
        binder.setBean((Object)library);
        this.add(new Component[]{twinColGrid});
        this.add(new Component[]{new Button("Get values", (ComponentEventListener & Serializable)ev -> ((Library)binder.getBean()).getBooks().forEach(book -> Notification.show((String)book.getTitle(), (int)3000, (Notification.Position)Notification.Position.BOTTOM_START)))});
        this.add(new Component[]{new Button("Clear TwinColGrid", (ComponentEventListener & Serializable)ev -> twinColGrid.clear())});
        this.setSizeFull();
    }

    private void initializeData() {
        this.selectedBooks.add(new Book("1478375108", "Vaadin Recipes"));
        this.selectedBooks.add(new Book("9789526800677", "Book of Vaadin: Volume 2 "));
        this.availableBooks.add(new Book("1478375108", "Vaadin Recipes"));
        this.availableBooks.add(new Book("9781849515221", "Learning Vaadin"));
        this.availableBooks.add(new Book("9781782162261", "Vaadin 7 UI Design By Example: Beginner\u2019s Guide"));
        this.availableBooks.add(new Book("9781849518802", "Vaadin 7 Cookbook"));
        this.availableBooks.add(new Book("9526800605", "Book of Vaadin: 7th Edition, 1st Revision"));
        this.availableBooks.add(new Book("9789526800677", "Book of Vaadin: Volume 2 "));
        this.availableBooks.add(new Book("9529267533", "Book of Vaadin"));
        this.availableBooks.add(new Book("1782169776", "Learning Vaadin 7, Second Edition"));
    }
}

