/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.flowingcode.vaadin.addons.twincolgrid.TwinColGrid;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

class TwinColGridListAdapter<T>
implements HasValue<HasValue.ValueChangeEvent<List<T>>, List<T>> {
    @NonNull
    private final TwinColGrid<T> delegate;

    public void setValue(List<T> value) {
        this.delegate.setValue(new LinkedHashSet<T>(value));
    }

    public List<T> getValue() {
        return Collections.unmodifiableList(this.delegate.collectValue(Collectors.toList()));
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<List<T>>> listener) {
        ArrayList<Registration> registrations = new ArrayList<Registration>();
        registrations.add(this.delegate.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> {
            ArrayList value = new ArrayList((Collection)ev.getValue());
            ValueChangeEventImpl listEvent = new ValueChangeEventImpl(ev.isFromClient(), new ArrayList(value));
            listener.valueChanged((HasValue.ValueChangeEvent)listEvent);
        }));
        registrations.add(this.delegate.getSelectionGrid().addSortListener((ComponentEventListener & Serializable)ev -> {
            Object value = this.getValue();
            ValueChangeEventImpl listEvent = new ValueChangeEventImpl(ev.isFromClient(), value);
            listener.valueChanged((HasValue.ValueChangeEvent)listEvent);
        }));
        return (Registration & Serializable)() -> registrations.forEach(Registration::remove);
    }

    public List<T> getEmptyValue() {
        return Collections.emptyList();
    }

    public TwinColGridListAdapter(@NonNull TwinColGrid<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public void clear() {
        this.delegate.clear();
    }

    public void setReadOnly(boolean readOnly) {
        this.delegate.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        this.delegate.setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    public boolean isRequiredIndicatorVisible() {
        return this.delegate.isRequiredIndicatorVisible();
    }

    private final class ValueChangeEventImpl
    implements HasValue.ValueChangeEvent<List<T>> {
        boolean isFromClient;
        List<T> value;

        public HasValue<?, List<T>> getHasValue() {
            return TwinColGridListAdapter.this;
        }

        public List<T> getOldValue() {
            return null;
        }

        public boolean isFromClient() {
            return this.isFromClient;
        }

        public List<T> getValue() {
            return this.value;
        }

        public ValueChangeEventImpl(boolean isFromClient, List<T> value) {
            this.isFromClient = isFromClient;
            this.value = value;
        }
    }

    private static interface IDelegate {
        public boolean isEmpty();

        public void clear();

        public void setReadOnly(boolean var1);

        public boolean isReadOnly();

        public void setRequiredIndicatorVisible(boolean var1);

        public boolean isRequiredIndicatorVisible();
    }
}

