/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.flowingcode.vaadin.addons.twincolgrid.TwinColGridListAdapter;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridNoneSelectionModel;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.grid.dnd.GridDropMode;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@CssImport.Container(value={@CssImport(value="./styles/multiselect-cb-hide.css", themeFor="vaadin-grid"), @CssImport(value="./styles/twin-col-grid-button.css")})
public class TwinColGrid<T>
extends VerticalLayout
implements HasValue<HasValue.ValueChangeEvent<Set<T>>, Set<T>>,
HasComponents,
HasSize {
    private final TwinColModel<T> left;
    private final TwinColModel<T> right;
    @Deprecated
    protected final Grid<T> leftGrid;
    @Deprecated
    protected final Grid<T> rightGrid;
    @Deprecated
    protected ListDataProvider<T> leftGridDataProvider;
    @Deprecated
    protected ListDataProvider<T> rightGridDataProvider;
    private final Button addAllButton = this.createActionButton();
    private final Button addButton = this.createActionButton();
    private final Button removeButton = this.createActionButton();
    private final Button removeAllButton = this.createActionButton();
    private Component buttonContainer;
    private Grid<T> draggedGrid;
    private Label fakeButtonContainerLabel = new Label();
    private Orientation orientation = Orientation.HORIZONTAL;

    public TwinColGrid() {
        this(DataProvider.ofCollection(new LinkedHashSet()), null);
    }

    public TwinColGrid(ListDataProvider<T> dataProvider, String caption) {
        this.left = new TwinColModel();
        this.right = new TwinColModel();
        this.leftGrid = this.left.grid;
        this.rightGrid = this.right.grid;
        this.setMargin(false);
        this.setPadding(false);
        if (caption != null) {
            this.add(new Component[]{new Label(caption)});
        }
        this.setDataProvider(dataProvider);
        this.rightGridDataProvider = DataProvider.ofCollection(new LinkedHashSet());
        this.getRightGrid().setDataProvider(this.rightGridDataProvider);
        this.getLeftGrid().setWidth("100%");
        this.getRightGrid().setWidth("100%");
        this.addAllButton.addClickListener((ComponentEventListener & Serializable)e -> {
            List filteredItems = this.left.getDataProvider().withConfigurableFilter().fetch(new Query()).collect(Collectors.toList());
            this.updateSelection(new LinkedHashSet(filteredItems), new HashSet());
        });
        this.addButton.addClickListener((ComponentEventListener & Serializable)e -> this.updateSelection(new LinkedHashSet(this.getLeftGrid().getSelectedItems()), new HashSet()));
        this.removeButton.addClickListener((ComponentEventListener & Serializable)e -> this.updateSelection(new HashSet(), this.getRightGrid().getSelectedItems()));
        this.removeAllButton.addClickListener((ComponentEventListener & Serializable)e -> {
            List filteredItems = this.right.getDataProvider().withConfigurableFilter().fetch(new Query()).collect(Collectors.toList());
            this.updateSelection(new HashSet(), new HashSet(filteredItems));
        });
        this.getElement().getStyle().set("display", "flex");
        this.forEachSide(side -> {
            side.grid.setSelectionMode(Grid.SelectionMode.MULTI);
            side.columnLabel.setVisible(false);
            side.layout.setSizeFull();
            side.layout.setMargin(false);
            side.layout.setPadding(false);
            side.layout.setSpacing(false);
        });
        this.add(new Component[]{this.createContainerLayout()});
        this.setSizeUndefined();
    }

    public TwinColGrid<T> withOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.updateContainerLayout();
        }
        return this;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    private void updateContainerLayout() {
        Component oldContainerComponent = (Component)this.left.layout.getParent().get();
        Component newContainerComponent = this.createContainerLayout();
        this.replace(oldContainerComponent, newContainerComponent);
    }

    private Component createContainerLayout() {
        return this.orientation == Orientation.VERTICAL ? this.createVerticalContainer() : this.createHorizontalContainer();
    }

    private HorizontalLayout createHorizontalContainer() {
        this.buttonContainer = this.getVerticalButtonContainer();
        HorizontalLayout hl = new HorizontalLayout(new Component[]{this.left.layout, this.buttonContainer, this.right.layout});
        hl.getElement().getStyle().set("min-height", "0px");
        hl.getElement().getStyle().set("flex", "1 1 0px");
        hl.setMargin(false);
        hl.setWidthFull();
        return hl;
    }

    private VerticalLayout createVerticalContainer() {
        this.buttonContainer = this.getHorizontalButtonContainer();
        VerticalLayout vl = new VerticalLayout(new Component[]{this.left.layout, this.buttonContainer, this.right.layout});
        vl.getElement().getStyle().set("min-width", "0px");
        vl.getElement().getStyle().set("flex", "1 1 0px");
        vl.setMargin(false);
        vl.setPadding(false);
        vl.setHeightFull();
        return vl;
    }

    private VerticalLayout getVerticalButtonContainer() {
        this.addButton.setIcon((Component)VaadinIcon.ANGLE_RIGHT.create());
        this.addAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create());
        this.removeButton.setIcon((Component)VaadinIcon.ANGLE_LEFT.create());
        this.removeAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create());
        this.fakeButtonContainerLabel.getElement().setProperty("innerHTML", "&nbsp;");
        this.fakeButtonContainerLabel.setVisible(false);
        VerticalLayout vButtonContainer = new VerticalLayout(new Component[]{this.fakeButtonContainerLabel, this.addAllButton, this.addButton, this.removeButton, this.removeAllButton});
        vButtonContainer.setPadding(false);
        vButtonContainer.setSpacing(false);
        vButtonContainer.setSizeUndefined();
        return vButtonContainer;
    }

    private HorizontalLayout getHorizontalButtonContainer() {
        this.addButton.setIcon((Component)VaadinIcon.ANGLE_DOWN.create());
        this.addAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_DOWN.create());
        this.removeButton.setIcon((Component)VaadinIcon.ANGLE_UP.create());
        this.removeAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_UP.create());
        HorizontalLayout hButtonContainer = new HorizontalLayout(new Component[]{this.addAllButton, this.addButton, this.removeButton, this.removeAllButton});
        hButtonContainer.setPadding(false);
        hButtonContainer.setSizeUndefined();
        return hButtonContainer;
    }

    public Grid<T> getLeftGrid() {
        return this.leftGrid;
    }

    public Grid<T> getRightGrid() {
        return this.rightGrid;
    }

    private void forEachSide(Consumer<TwinColModel<T>> consumer) {
        consumer.accept(this.left);
        consumer.accept(this.right);
    }

    public void setItems(Collection<T> items) {
        this.setDataProvider(DataProvider.ofCollection(items));
    }

    public void setItems(Stream<T> items) {
        this.setDataProvider(DataProvider.fromStream(items));
    }

    @Deprecated
    public void setLeftGridClassName(String classname) {
        this.getLeftGrid().setClassName(classname);
    }

    @Deprecated
    public void addLeftGridClassName(String classname) {
        this.getLeftGrid().addClassName(classname);
    }

    @Deprecated
    public void removeLeftGridClassName(String classname) {
        this.getLeftGrid().removeClassName(classname);
    }

    @Deprecated
    public void setRightGridClassName(String classname) {
        this.getRightGrid().setClassName(classname);
    }

    @Deprecated
    public void addRightGridClassName(String classname) {
        this.getRightGrid().addClassName(classname);
    }

    @Deprecated
    public void removeRightGridClassName(String classname) {
        this.getRightGrid().removeClassName(classname);
    }

    public void clearAll() {
        this.updateSelection(new HashSet(), new HashSet<T>(this.right.getItems()));
    }

    private void setDataProvider(ListDataProvider<T> dataProvider) {
        this.leftGridDataProvider = dataProvider;
        this.getLeftGrid().setDataProvider(dataProvider);
        if (this.right.getDataProvider() != null) {
            this.right.getItems().clear();
            this.right.getDataProvider().refreshAll();
        }
    }

    public TwinColGrid(Collection<T> options) {
        this(DataProvider.ofCollection(new LinkedHashSet<T>(options)), null);
    }

    public TwinColGrid(Collection<T> options, String caption) {
        this(DataProvider.ofCollection(new LinkedHashSet<T>(options)), caption);
    }

    public TwinColGrid<T> withRightColumnCaption(String rightColumnCaption) {
        this.right.columnLabel.setText(rightColumnCaption);
        this.right.columnLabel.setVisible(true);
        this.fakeButtonContainerLabel.setVisible(true);
        return this;
    }

    public TwinColGrid<T> withLeftColumnCaption(String leftColumnCaption) {
        this.left.columnLabel.setText(leftColumnCaption);
        this.left.columnLabel.setVisible(true);
        this.fakeButtonContainerLabel.setVisible(true);
        return this;
    }

    public TwinColGrid<T> addColumn(ItemLabelGenerator<T> itemLabelGenerator, String header) {
        this.getLeftGrid().addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header);
        this.getRightGrid().addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header);
        return this;
    }

    public TwinColGrid<T> addSortableColumn(ItemLabelGenerator<T> itemLabelGenerator, Comparator<T> comparator, String header) {
        this.forEachSide(side -> side.grid.addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header).setComparator(comparator).setSortable(true));
        return this;
    }

    public TwinColGrid<T> addSortableColumn(ItemLabelGenerator<T> itemLabelGenerator, Comparator<T> comparator, String header, String key) {
        this.forEachSide(side -> side.grid.addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header).setComparator(comparator).setSortable(true).setKey(key));
        return this;
    }

    public TwinColGrid<T> withoutAddAllButton() {
        this.addAllButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutRemoveAllButton() {
        this.removeAllButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutAddButton() {
        this.addButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutRemoveButton() {
        this.removeButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    private void checkContainerVisibility() {
        boolean atLeastOneIsVisible = this.removeButton.isVisible() || this.addButton.isVisible() || this.removeAllButton.isVisible() || this.addAllButton.isVisible();
        this.buttonContainer.setVisible(atLeastOneIsVisible);
    }

    public TwinColGrid<T> withSizeFull() {
        this.setWidthFull();
        this.getElement().getStyle().set("flex-grow", "1");
        return this;
    }

    public TwinColGrid<T> withDragAndDropSupport() {
        this.configDragAndDrop(this.left, this.right);
        this.configDragAndDrop(this.right, this.left);
        return this;
    }

    public String getRightColumnCaption() {
        return this.right.columnLabel.getText();
    }

    public String getLeftColumnCaption() {
        return this.left.columnLabel.getText();
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value);
        Set newValues = value.stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        this.updateSelection(newValues, new LinkedHashSet(this.getLeftGrid().getSelectedItems()));
    }

    public Set<T> getValue() {
        return Collections.unmodifiableSet(this.collectValue(Collectors.toCollection(LinkedHashSet::new)));
    }

    <C> C collectValue(Collector<T, ?, C> collector) {
        Stream<T> stream = this.right.getItems().stream();
        SerializableComparator comparator = this.right.grid.createSortingComparator();
        if (comparator != null) {
            return stream.sorted((Comparator<T>)comparator).collect(collector);
        }
        return stream.collect(collector);
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<Set<T>>> listener) {
        return this.right.getDataProvider().addDataProviderListener((DataProviderListener & Serializable)e -> {
            AbstractField.ComponentValueChangeEvent e2 = new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, true);
            listener.valueChanged((HasValue.ValueChangeEvent)e2);
        });
    }

    public boolean isReadOnly() {
        return this.isReadOnly();
    }

    public boolean isRequiredIndicatorVisible() {
        return this.isRequiredIndicatorVisible();
    }

    public void setReadOnly(boolean readOnly) {
        this.getLeftGrid().setSelectionMode(readOnly ? Grid.SelectionMode.NONE : Grid.SelectionMode.MULTI);
        this.getRightGrid().setSelectionMode(readOnly ? Grid.SelectionMode.NONE : Grid.SelectionMode.MULTI);
        this.addButton.setEnabled(!readOnly);
        this.removeButton.setEnabled(!readOnly);
        this.addAllButton.setEnabled(!readOnly);
        this.removeAllButton.setEnabled(!readOnly);
    }

    public void setRequiredIndicatorVisible(boolean visible) {
        this.setRequiredIndicatorVisible(visible);
    }

    private void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        this.left.getItems().addAll(removedItems);
        this.left.getItems().removeAll(addedItems);
        this.right.getItems().addAll(addedItems);
        this.right.getItems().removeAll(removedItems);
        this.forEachSide(side -> {
            side.getDataProvider().refreshAll();
            side.grid.getSelectionModel().deselectAll();
        });
    }

    private void configDragAndDrop(TwinColModel<T> sourceModel, TwinColModel<T> targetModel) {
        LinkedHashSet draggedItems = new LinkedHashSet();
        sourceModel.grid.setRowsDraggable(true);
        sourceModel.grid.addDragStartListener((ComponentEventListener & Serializable)event -> {
            this.draggedGrid = null;
            if (!(sourceModel.grid.getSelectionModel() instanceof GridNoneSelectionModel)) {
                draggedItems.addAll(event.getDraggedItems());
            }
            targetModel.grid.setDropMode(GridDropMode.ON_GRID);
        });
        sourceModel.grid.addDragEndListener((ComponentEventListener & Serializable)event -> {
            if (targetModel.droppedInsideGrid && sourceModel.grid == this.draggedGrid) {
                if (this.draggedGrid == null) {
                    draggedItems.clear();
                    return;
                }
                ListDataProvider dragGridSourceDataProvider = sourceModel.getDataProvider();
                dragGridSourceDataProvider.getItems().removeAll(draggedItems);
                dragGridSourceDataProvider.refreshAll();
                targetModel.droppedInsideGrid = false;
                this.draggedGrid = null;
                draggedItems.clear();
                sourceModel.grid.deselectAll();
            } else {
                draggedItems.clear();
            }
        });
        targetModel.grid.addDropListener((ComponentEventListener & Serializable)event -> {
            this.draggedGrid = sourceModel.grid;
            targetModel.droppedInsideGrid = true;
            ListDataProvider dragGridTargetDataProvider = targetModel.getDataProvider();
            dragGridTargetDataProvider.getItems().addAll(draggedItems);
            dragGridTargetDataProvider.refreshAll();
        });
    }

    @Deprecated
    public void addLeftGridSelectionListener(SelectionListener<Grid<T>, T> listener) {
        this.getLeftGrid().addSelectionListener(listener);
    }

    @Deprecated
    public void addRightGridSelectionListener(SelectionListener<Grid<T>, T> listener) {
        this.getRightGrid().addSelectionListener(listener);
    }

    public TwinColGrid<T> addFilterableColumn(ItemLabelGenerator<T> itemLabelGenerator, SerializableFunction<T, String> filterableValue, String header, String filterPlaceholder, boolean enableClearButton) {
        this.forEachSide(side -> {
            Grid.Column column = side.grid.addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header);
            TextField filterTF = new TextField();
            filterTF.setClearButtonVisible(enableClearButton);
            filterTF.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> side.getDataProvider().addFilter((SerializablePredicate & Serializable)filterableEntity -> StringUtils.containsIgnoreCase((CharSequence)((CharSequence)filterableValue.apply(filterableEntity)), (CharSequence)filterTF.getValue())));
            if (side.headerRow == null) {
                side.headerRow = side.grid.appendHeaderRow();
            }
            ((HeaderRow.HeaderCell)side.headerRow.getCell(column)).setComponent((Component)filterTF);
            filterTF.setValueChangeMode(ValueChangeMode.EAGER);
            filterTF.setSizeFull();
            filterTF.setPlaceholder(filterPlaceholder);
        });
        return this;
    }

    public TwinColGrid<T> addFilterableColumn(ItemLabelGenerator<T> itemLabelGenerator, String header, String filterPlaceholder, boolean enableClearButton) {
        return this.addFilterableColumn(itemLabelGenerator, (SerializableFunction<T, String>)itemLabelGenerator, header, filterPlaceholder, enableClearButton);
    }

    public TwinColGrid<T> selectRowOnClick() {
        this.forEachSide(side -> {
            side.grid.addClassName("hide-selector-col");
            side.grid.addItemClickListener((ComponentEventListener & Serializable)c -> {
                if (side.grid.getSelectedItems().contains(c.getItem())) {
                    side.grid.deselect(c.getItem());
                } else {
                    side.grid.select(c.getItem());
                }
            });
        });
        return this;
    }

    public HasValue<? extends HasValue.ValueChangeEvent<List<T>>, List<T>> asList() {
        return new TwinColGridListAdapter(this);
    }

    public Set<T> getEmptyValue() {
        return Collections.emptySet();
    }

    private Button createActionButton() {
        Button button = new Button();
        button.addThemeName("twin-col-grid-button");
        return button;
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    private static final class TwinColModel<T>
    implements Serializable {
        final GridEx<T> grid = new GridEx();
        final Label columnLabel = new Label();
        final VerticalLayout layout = new VerticalLayout(new Component[]{this.columnLabel, this.grid});
        HeaderRow headerRow;
        boolean droppedInsideGrid = false;

        private TwinColModel() {
        }

        ListDataProvider<T> getDataProvider() {
            return (ListDataProvider)this.grid.getDataProvider();
        }

        Collection<T> getItems() {
            return this.getDataProvider().getItems();
        }
    }

    private static final class GridEx<T>
    extends Grid<T> {
        private GridEx() {
        }

        protected SerializableComparator<T> createSortingComparator() {
            return super.createSortingComparator();
        }
    }
}

