/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.flowingcode.vaadin.addons.twincolgrid.BoundDemo;
import com.flowingcode.vaadin.addons.twincolgrid.FilterableDemo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.IFrame;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@Route(value="twincolgrid")
@CssImport(value="styles/shared-styles.css")
public class TwincolDemoView
extends VerticalLayout {
    private static final String BOUND_DEMO = "Bound";
    private static final String FILTERABLE_DEMO = "Filterable";
    private static final String DRAGNDROP_DEMO = "Drag and Drop";
    private static final String BOUND_SOURCE = "https://github.com/FlowingCode/TwinColGridAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/twincolgrid/BoundDemo.java";
    private static final String FILTERABLE_SOURCE = "https://github.com/FlowingCode/TwinColGridAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/twincolgrid/FilterableDemo.java";
    private static final String DRAGNDROP_SOURCE = "https://github.com/FlowingCode/TwinColGridAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/twincolgrid/DragAndDropDemo.java";

    public TwincolDemoView() {
        SplitLayout layout = new SplitLayout();
        layout.setOrientation(SplitLayout.Orientation.HORIZONTAL);
        layout.addToPrimary(new Component[]{new BoundDemo()});
        layout.setSizeFull();
        IFrame iframe = new IFrame();
        iframe.getElement().setAttribute("frameborder", "0");
        iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(BOUND_DEMO));
        iframe.setSizeFull();
        layout.addToSecondary(new Component[]{iframe});
        Checkbox codeCB = new Checkbox("Show Source Code");
        codeCB.setValue((Object)true);
        codeCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)cb -> {
            if (((Boolean)cb.getValue()).booleanValue()) {
                layout.setSplitterPosition(50.0);
            } else {
                layout.setSplitterPosition(100.0);
            }
        });
        Tabs tabs = new Tabs();
        Tab demo1 = new Tab(BOUND_DEMO);
        Tab demo2 = new Tab(FILTERABLE_DEMO);
        Tab demo3 = new Tab(DRAGNDROP_DEMO);
        tabs.setWidthFull();
        tabs.add(new Component[]{demo1, demo2, demo3, codeCB});
        this.add(new Component[]{tabs, layout});
        tabs.setSelectedTab(demo1);
        this.setSizeFull();
        tabs.addSelectedChangeListener((ComponentEventListener & Serializable)e -> {
            this.removeAll();
            layout.removeAll();
            switch (e.getSelectedTab().getLabel()) {
                case "Bound": {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(BOUND_DEMO));
                    layout.addToPrimary(new Component[]{new BoundDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout});
                    break;
                }
                case "Filterable": {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(FILTERABLE_DEMO));
                    layout.addToPrimary(new Component[]{new FilterableDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout});
                    break;
                }
                case "Drag and Drop": {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(DRAGNDROP_DEMO));
                    layout.addToPrimary(new Component[]{new FilterableDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout});
                    break;
                }
                default: {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(BOUND_DEMO));
                    layout.addToPrimary(new Component[]{new BoundDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout});
                }
            }
        });
    }

    private String getSrcdoc(String demo) {
        String response;
        switch (demo) {
            case "Bound": {
                response = "<html style=\"overflow-y:hidden; height:100%;\"><body style=\"overflow-y: scroll; height:100%;\"><script src=\"https://gist-it.appspot.com/https://github.com/FlowingCode/TwinColGridAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/twincolgrid/BoundDemo.java\"></script></body></html>";
                break;
            }
            case "Filterable": {
                response = "<html style=\"overflow-y:hidden; height:100%;\"><body style=\"overflow-y: scroll; height:100%;\"><script src=\"https://gist-it.appspot.com/https://github.com/FlowingCode/TwinColGridAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/twincolgrid/FilterableDemo.java\"></script></body></html>";
                break;
            }
            case "Drag and Drop": {
                response = "<html style=\"overflow-y:hidden; height:100%;\"><body style=\"overflow-y: scroll; height:100%;\"><script src=\"https://gist-it.appspot.com/https://github.com/FlowingCode/TwinColGridAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/twincolgrid/DragAndDropDemo.java\"></script></body></html>";
                break;
            }
            default: {
                response = "<html style=\"overflow-y:hidden; height:100%;\"><body style=\"overflow-y: scroll; height:100%;\"><script src=\"https://gist-it.appspot.com/https://github.com/FlowingCode/TwinColGridAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/twincolgrid/BoundDemo.java\"></script></body></html>";
            }
        }
        return response;
    }
}

