/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridNoneSelectionModel;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.grid.dnd.GridDropMode;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@CssImport(value="./styles/multiselect-cb-hide.css", themeFor="vaadin-grid")
public class TwinColGrid<T>
extends VerticalLayout
implements HasValue<HasValue.ValueChangeEvent<Set<T>>, Set<T>>,
HasComponents,
HasSize {
    private final TwinColModel<T> left;
    private final TwinColModel<T> right;
    protected final Grid<T> leftGrid;
    protected final Grid<T> rightGrid;
    @Deprecated
    protected ListDataProvider<T> leftGridDataProvider;
    @Deprecated
    protected ListDataProvider<T> rightGridDataProvider;
    private final Button addAllButton = new Button();
    private final Button addButton = new Button();
    private final Button removeButton = new Button();
    private final Button removeAllButton = new Button();
    private final VerticalLayout buttonContainer;
    private Grid<T> draggedGrid;
    private Label fakeButtonContainerLabel = new Label();
    private boolean droppedInsideGrid = false;

    public TwinColGrid() {
        this(DataProvider.ofCollection(new LinkedHashSet()), null);
    }

    public TwinColGrid(ListDataProvider<T> dataProvider, String caption) {
        this.left = new TwinColModel();
        this.right = new TwinColModel();
        this.leftGrid = this.left.grid;
        this.rightGrid = this.right.grid;
        this.setMargin(false);
        this.setPadding(false);
        if (caption != null) {
            this.add(new Component[]{new Label(caption)});
        }
        this.setDataProvider(dataProvider);
        this.rightGridDataProvider = DataProvider.ofCollection(new LinkedHashSet());
        this.rightGrid.setDataProvider(this.rightGridDataProvider);
        this.addButton.setIcon((Component)VaadinIcon.ANGLE_RIGHT.create());
        this.addButton.setWidth("3em");
        this.addAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create());
        this.addAllButton.setWidth("3em");
        this.removeButton.setIcon((Component)VaadinIcon.ANGLE_LEFT.create());
        this.removeButton.setWidth("3em");
        this.removeAllButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create());
        this.removeAllButton.setWidth("3em");
        this.fakeButtonContainerLabel.getElement().setProperty("innerHTML", "&nbsp;");
        this.fakeButtonContainerLabel.setVisible(false);
        this.buttonContainer = new VerticalLayout(new Component[]{this.fakeButtonContainerLabel, this.addAllButton, this.addButton, this.removeButton, this.removeAllButton});
        this.buttonContainer.setPadding(false);
        this.buttonContainer.setSpacing(false);
        this.buttonContainer.setSizeUndefined();
        this.leftGrid.setWidth("100%");
        this.rightGrid.setWidth("100%");
        this.addAllButton.addClickListener((ComponentEventListener & Serializable)e -> {
            this.left.getItems().stream().forEach(arg_0 -> ((GridSelectionModel)this.leftGrid.getSelectionModel()).select(arg_0));
            this.updateSelection(new LinkedHashSet(this.leftGrid.getSelectedItems()), new HashSet());
        });
        this.addButton.addClickListener((ComponentEventListener & Serializable)e -> this.updateSelection(new LinkedHashSet(this.leftGrid.getSelectedItems()), new HashSet()));
        this.removeButton.addClickListener((ComponentEventListener & Serializable)e -> this.updateSelection(new HashSet(), this.rightGrid.getSelectedItems()));
        this.removeAllButton.addClickListener((ComponentEventListener & Serializable)e -> {
            this.right.getItems().stream().forEach(arg_0 -> ((GridSelectionModel)this.rightGrid.getSelectionModel()).select(arg_0));
            this.updateSelection(new HashSet(), this.rightGrid.getSelectedItems());
        });
        this.getElement().getStyle().set("display", "flex");
        this.forEachSide(side -> {
            side.grid.setSelectionMode(Grid.SelectionMode.MULTI);
            side.columnLabel.setVisible(false);
            side.layout.setSizeFull();
            side.layout.setMargin(false);
            side.layout.setPadding(false);
            side.layout.setSpacing(false);
        });
        HorizontalLayout hl = new HorizontalLayout(new Component[]{this.left.layout, this.buttonContainer, this.right.layout});
        hl.getElement().getStyle().set("min-height", "0px");
        hl.getElement().getStyle().set("flex", "1 1 0px");
        hl.setMargin(false);
        hl.setWidthFull();
        this.add(new Component[]{hl});
        this.setSizeUndefined();
    }

    private void forEachSide(Consumer<TwinColModel<T>> consumer) {
        consumer.accept(this.left);
        consumer.accept(this.right);
    }

    public void setItems(Collection<T> items) {
        this.setDataProvider(DataProvider.ofCollection(items));
    }

    public void setItems(Stream<T> items) {
        this.setDataProvider(DataProvider.fromStream(items));
    }

    public void setLeftGridClassName(String classname) {
        this.leftGrid.setClassName(classname);
    }

    public void addLeftGridClassName(String classname) {
        this.leftGrid.addClassName(classname);
    }

    public void removeLeftGridClassName(String classname) {
        this.leftGrid.removeClassName(classname);
    }

    public void setRightGridClassName(String classname) {
        this.rightGrid.setClassName(classname);
    }

    public void addRightGridClassName(String classname) {
        this.rightGrid.addClassName(classname);
    }

    public void removeRightGridClassName(String classname) {
        this.rightGrid.removeClassName(classname);
    }

    private void setDataProvider(ListDataProvider<T> dataProvider) {
        this.leftGridDataProvider = dataProvider;
        this.leftGrid.setDataProvider(dataProvider);
        if (this.right.getDataProvider() != null) {
            this.right.getItems().clear();
            this.right.getDataProvider().refreshAll();
        }
    }

    public TwinColGrid(Collection<T> options) {
        this(DataProvider.ofCollection(new LinkedHashSet<T>(options)), null);
    }

    public TwinColGrid(Collection<T> options, String caption) {
        this(DataProvider.ofCollection(new LinkedHashSet<T>(options)), caption);
    }

    public TwinColGrid<T> withRightColumnCaption(String rightColumnCaption) {
        this.right.columnLabel.setText(rightColumnCaption);
        this.right.columnLabel.setVisible(true);
        this.fakeButtonContainerLabel.setVisible(true);
        return this;
    }

    public TwinColGrid<T> withLeftColumnCaption(String leftColumnCaption) {
        this.left.columnLabel.setText(leftColumnCaption);
        this.left.columnLabel.setVisible(true);
        this.fakeButtonContainerLabel.setVisible(true);
        return this;
    }

    public TwinColGrid<T> addColumn(ItemLabelGenerator<T> itemLabelGenerator, String header) {
        this.leftGrid.addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header);
        this.rightGrid.addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header);
        return this;
    }

    public TwinColGrid<T> addSortableColumn(ItemLabelGenerator<T> itemLabelGenerator, Comparator<T> comparator, String header) {
        this.leftGrid.addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header).setComparator(comparator).setSortable(true);
        this.rightGrid.addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header).setComparator(comparator).setSortable(true);
        return this;
    }

    public TwinColGrid<T> withoutAddAllButton() {
        this.addAllButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutRemoveAllButton() {
        this.removeAllButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutAddButton() {
        this.addButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    public TwinColGrid<T> withoutRemoveButton() {
        this.removeButton.setVisible(false);
        this.checkContainerVisibility();
        return this;
    }

    private void checkContainerVisibility() {
        boolean atLeastOneIsVisible = this.removeButton.isVisible() || this.addButton.isVisible() || this.removeAllButton.isVisible() || this.addAllButton.isVisible();
        this.buttonContainer.setVisible(atLeastOneIsVisible);
    }

    public TwinColGrid<T> withSizeFull() {
        this.setSizeFull();
        return this;
    }

    public TwinColGrid<T> withDragAndDropSupport() {
        this.configDragAndDrop(this.leftGrid, this.rightGrid);
        this.configDragAndDrop(this.rightGrid, this.leftGrid);
        return this;
    }

    public String getRightColumnCaption() {
        return this.right.columnLabel.getText();
    }

    public String getLeftColumnCaption() {
        return this.left.columnLabel.getText();
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value);
        Set newValues = value.stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        this.updateSelection(newValues, new LinkedHashSet(this.leftGrid.getSelectedItems()));
    }

    public Set<T> getValue() {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(this.right.getItems()));
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<Set<T>>> listener) {
        return this.right.getDataProvider().addDataProviderListener((DataProviderListener & Serializable)e -> {
            AbstractField.ComponentValueChangeEvent e2 = new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, true);
            listener.valueChanged((HasValue.ValueChangeEvent)e2);
        });
    }

    public boolean isReadOnly() {
        return this.isReadOnly();
    }

    public boolean isRequiredIndicatorVisible() {
        return this.isRequiredIndicatorVisible();
    }

    public void setReadOnly(boolean readOnly) {
        this.leftGrid.setSelectionMode(readOnly ? Grid.SelectionMode.NONE : Grid.SelectionMode.MULTI);
        this.rightGrid.setSelectionMode(readOnly ? Grid.SelectionMode.NONE : Grid.SelectionMode.MULTI);
        this.addButton.setEnabled(!readOnly);
        this.removeButton.setEnabled(!readOnly);
        this.addAllButton.setEnabled(!readOnly);
        this.removeAllButton.setEnabled(!readOnly);
    }

    public void setRequiredIndicatorVisible(boolean visible) {
        this.setRequiredIndicatorVisible(visible);
    }

    private void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        this.left.getItems().addAll(removedItems);
        this.left.getItems().removeAll(addedItems);
        this.right.getItems().addAll(addedItems);
        this.right.getItems().removeAll(removedItems);
        this.forEachSide(side -> {
            side.getDataProvider().refreshAll();
            side.grid.getSelectionModel().deselectAll();
        });
    }

    private void configDragAndDrop(Grid<T> sourceGrid, Grid<T> targetGrid) {
        LinkedHashSet draggedItems = new LinkedHashSet();
        sourceGrid.setRowsDraggable(true);
        sourceGrid.addDragStartListener((ComponentEventListener & Serializable)event -> {
            this.draggedGrid = sourceGrid;
            if (!(this.draggedGrid.getSelectionModel() instanceof GridNoneSelectionModel)) {
                draggedItems.addAll(event.getDraggedItems());
            }
            targetGrid.setDropMode(GridDropMode.ON_GRID);
        });
        sourceGrid.addDragEndListener((ComponentEventListener & Serializable)event -> {
            if (this.droppedInsideGrid) {
                this.droppedInsideGrid = false;
                if (this.draggedGrid == null) {
                    draggedItems.clear();
                    return;
                }
                ListDataProvider dragGridSourceDataProvider = (ListDataProvider)this.draggedGrid.getDataProvider();
                dragGridSourceDataProvider.getItems().removeAll(draggedItems);
                dragGridSourceDataProvider.refreshAll();
                draggedItems.clear();
                this.draggedGrid.deselectAll();
                this.draggedGrid = null;
            } else {
                draggedItems.clear();
            }
        });
        targetGrid.addDropListener((ComponentEventListener & Serializable)event -> {
            this.droppedInsideGrid = true;
            ListDataProvider dragGridTargetDataProvider = (ListDataProvider)((Grid)event.getSource()).getDataProvider();
            dragGridTargetDataProvider.getItems().addAll(draggedItems);
            dragGridTargetDataProvider.refreshAll();
        });
    }

    public void addLeftGridSelectionListener(SelectionListener<Grid<T>, T> listener) {
        this.leftGrid.addSelectionListener(listener);
    }

    public void addRightGridSelectionListener(SelectionListener<Grid<T>, T> listener) {
        this.rightGrid.addSelectionListener(listener);
    }

    public TwinColGrid<T> addFilterableColumn(ItemLabelGenerator<T> itemLabelGenerator, SerializableFunction<T, String> filterableValue, String header, String filterPlaceholder, boolean enableClearButton) {
        this.forEachSide(side -> {
            Grid.Column column = side.grid.addColumn((Renderer)new TextRenderer(itemLabelGenerator)).setHeader(header);
            TextField filterTF = new TextField();
            filterTF.setClearButtonVisible(enableClearButton);
            filterTF.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> side.getDataProvider().addFilter((SerializablePredicate & Serializable)filterableEntity -> StringUtils.containsIgnoreCase((CharSequence)((CharSequence)filterableValue.apply(filterableEntity)), (CharSequence)filterTF.getValue())));
            if (side.headerRow == null) {
                side.headerRow = side.grid.appendHeaderRow();
            }
            ((HeaderRow.HeaderCell)side.headerRow.getCell(column)).setComponent((Component)filterTF);
            filterTF.setValueChangeMode(ValueChangeMode.EAGER);
            filterTF.setSizeFull();
            filterTF.setPlaceholder(filterPlaceholder);
        });
        return this;
    }

    public TwinColGrid<T> addFilterableColumn(ItemLabelGenerator<T> itemLabelGenerator, String header, String filterPlaceholder, boolean enableClearButton) {
        return this.addFilterableColumn(itemLabelGenerator, (SerializableFunction<T, String>)itemLabelGenerator, header, filterPlaceholder, enableClearButton);
    }

    public TwinColGrid<T> selectRowOnClick() {
        this.forEachSide(side -> {
            side.grid.addClassName("hide-selector-col");
            side.grid.addItemClickListener((ComponentEventListener & Serializable)c -> {
                if (side.grid.getSelectedItems().contains(c.getItem())) {
                    side.grid.deselect(c.getItem());
                } else {
                    side.grid.select(c.getItem());
                }
            });
        });
        return this;
    }

    private static final class TwinColModel<T>
    implements Serializable {
        final Grid<T> grid = new Grid();
        final Label columnLabel = new Label();
        final VerticalLayout layout = new VerticalLayout(new Component[]{this.columnLabel, this.grid});
        HeaderRow headerRow;

        private TwinColModel() {
        }

        ListDataProvider<T> getDataProvider() {
            return (ListDataProvider)this.grid.getDataProvider();
        }

        Collection<T> getItems() {
            return this.getDataProvider().getItems();
        }
    }
}

