/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.twincolgrid;

import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.DataProviderListener;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.dnd.DropEffect;
import com.vaadin.shared.ui.dnd.EffectAllowed;
import com.vaadin.shared.ui.grid.DropMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.components.grid.GridDragEndListener;
import com.vaadin.ui.components.grid.GridDragSource;
import com.vaadin.ui.components.grid.GridDragStartListener;
import com.vaadin.ui.components.grid.GridDropListener;
import com.vaadin.ui.components.grid.GridDropTarget;
import com.vaadin.ui.components.grid.GridSelectionModel;
import com.vaadin.ui.components.grid.NoSelectionModel;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.TextRenderer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TwinColGrid<T>
extends CustomComponent
implements HasValue<Set<T>> {
    private final Grid<T> leftGrid = new Grid();
    private final Grid<T> rightGrid = new Grid();
    private ListDataProvider<T> leftGridDataProvider;
    private final ListDataProvider<T> rightGridDataProvider;
    private final Button addAllButton = new Button();
    private final Button addButton = new Button();
    private final Button removeButton = new Button();
    private final Button removeAllButton = new Button();
    private final VerticalLayout buttonContainer;
    private Grid<T> draggedGrid;

    public TwinColGrid() {
        this(DataProvider.ofCollection(new LinkedHashSet()));
    }

    public TwinColGrid(ListDataProvider<T> dataProvider) {
        this.setDataProvider(dataProvider);
        this.rightGridDataProvider = DataProvider.ofCollection(new LinkedHashSet());
        this.rightGrid.setDataProvider(this.rightGridDataProvider);
        this.leftGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.rightGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.addButton.setIcon((Resource)VaadinIcons.ANGLE_RIGHT, ">");
        this.addButton.setWidth(3.0f, Sizeable.Unit.EM);
        this.addAllButton.setIcon((Resource)VaadinIcons.ANGLE_DOUBLE_RIGHT, ">>");
        this.addAllButton.setWidth(3.0f, Sizeable.Unit.EM);
        this.removeButton.setIcon((Resource)VaadinIcons.ANGLE_LEFT, "<");
        this.removeButton.setWidth(3.0f, Sizeable.Unit.EM);
        this.removeAllButton.setIcon((Resource)VaadinIcons.ANGLE_DOUBLE_LEFT, "<<");
        this.removeAllButton.setWidth(3.0f, Sizeable.Unit.EM);
        this.buttonContainer = new VerticalLayout(new Component[]{this.addButton, this.removeButton});
        this.buttonContainer.setSpacing(false);
        this.buttonContainer.setSizeUndefined();
        HorizontalLayout container = new HorizontalLayout(new Component[]{this.leftGrid, this.buttonContainer, this.rightGrid});
        container.setSizeFull();
        this.leftGrid.setSizeFull();
        this.rightGrid.setSizeFull();
        container.setExpandRatio(this.leftGrid, 1.0f);
        container.setExpandRatio(this.rightGrid, 1.0f);
        this.addAllButton.addClickListener((Button.ClickListener & Serializable)e -> {
            this.leftGridDataProvider.getItems().stream().forEach(arg_0 -> ((GridSelectionModel)this.leftGrid.getSelectionModel()).select(arg_0));
            this.updateSelection(new LinkedHashSet(this.leftGrid.getSelectedItems()), new HashSet());
        });
        this.addButton.addClickListener((Button.ClickListener & Serializable)e -> this.updateSelection(new LinkedHashSet(this.leftGrid.getSelectedItems()), new HashSet()));
        this.removeButton.addClickListener((Button.ClickListener & Serializable)e -> this.updateSelection(new HashSet(), this.rightGrid.getSelectedItems()));
        this.removeAllButton.addClickListener((Button.ClickListener & Serializable)e -> {
            this.rightGridDataProvider.getItems().stream().forEach(arg_0 -> ((GridSelectionModel)this.rightGrid.getSelectionModel()).select(arg_0));
            this.updateSelection(new HashSet(), this.rightGrid.getSelectedItems());
        });
        this.setCompositionRoot((Component)container);
        this.setSizeUndefined();
    }

    public void setItems(Collection<T> items) {
        this.setDataProvider(DataProvider.ofCollection(items));
    }

    public void setItems(Stream<T> items) {
        this.setDataProvider(DataProvider.fromStream(items));
    }

    private void setDataProvider(ListDataProvider<T> dataProvider) {
        this.leftGridDataProvider = dataProvider;
        this.leftGrid.setDataProvider(dataProvider);
        if (this.rightGridDataProvider != null) {
            this.rightGridDataProvider.getItems().clear();
            this.rightGridDataProvider.refreshAll();
        }
    }

    public TwinColGrid(Collection<T> options) {
        this(DataProvider.ofCollection(new LinkedHashSet<T>(options)));
    }

    public TwinColGrid(String caption, ListDataProvider<T> dataProvider) {
        this(dataProvider);
        this.setCaption(caption);
    }

    public TwinColGrid(String caption, Collection<T> options) {
        this(caption, DataProvider.ofCollection(new LinkedHashSet<T>(options)));
    }

    public int getRows() {
        return (int)this.leftGrid.getHeightByRows();
    }

    public TwinColGrid<T> withRows(int rows) {
        if (rows < 0) {
            rows = 0;
        }
        this.leftGrid.setHeightByRows((double)rows);
        this.rightGrid.setHeightByRows((double)rows);
        this.markAsDirty();
        return this;
    }

    public TwinColGrid<T> withRightColumnCaption(String rightColumnCaption) {
        this.rightGrid.setCaption(rightColumnCaption);
        this.markAsDirty();
        return this;
    }

    public <V> TwinColGrid<T> addColumn(ValueProvider<T, V> valueProvider, String caption) {
        this.leftGrid.addColumn(valueProvider, (AbstractRenderer)new TextRenderer()).setCaption(caption);
        this.rightGrid.addColumn(valueProvider, (AbstractRenderer)new TextRenderer()).setCaption(caption);
        return this;
    }

    public TwinColGrid<T> showAddAllButton() {
        this.buttonContainer.addComponent((Component)this.addAllButton, 0);
        return this;
    }

    public TwinColGrid<T> showRemoveAllButton() {
        this.buttonContainer.addComponent((Component)this.removeAllButton, this.buttonContainer.getComponentCount());
        return this;
    }

    public TwinColGrid<T> withSizeFull() {
        super.setSizeFull();
        return this;
    }

    public TwinColGrid<T> withDragAndDropSupport() {
        this.configDragAndDrop(this.leftGrid, this.rightGrid);
        this.configDragAndDrop(this.rightGrid, this.leftGrid);
        return this;
    }

    public String getRightColumnCaption() {
        return this.rightGrid.getCaption();
    }

    public TwinColGrid<T> withLeftColumnCaption(String leftColumnCaption) {
        this.leftGrid.setCaption(leftColumnCaption);
        this.markAsDirty();
        return this;
    }

    public String getLeftColumnCaption() {
        return this.leftGrid.getCaption();
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value);
        Set newValues = value.stream().map(Objects::requireNonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        this.updateSelection(newValues, new LinkedHashSet(this.leftGrid.getSelectedItems()));
    }

    public Set<T> getValue() {
        return Collections.unmodifiableSet(new LinkedHashSet(this.rightGridDataProvider.getItems()));
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<Set<T>> listener) {
        return this.rightGridDataProvider.addDataProviderListener((DataProviderListener & Serializable)e -> listener.valueChange(new HasValue.ValueChangeEvent((Component)this, new LinkedHashSet(this.rightGridDataProvider.getItems()), true)));
    }

    public boolean isReadOnly() {
        return super.isReadOnly();
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    public void setReadOnly(boolean readOnly) {
        this.leftGrid.setSelectionMode(readOnly ? Grid.SelectionMode.NONE : Grid.SelectionMode.MULTI);
        this.rightGrid.setSelectionMode(readOnly ? Grid.SelectionMode.NONE : Grid.SelectionMode.MULTI);
        this.addButton.setEnabled(!readOnly);
        this.removeButton.setEnabled(!readOnly);
        this.addAllButton.setEnabled(!readOnly);
        this.removeAllButton.setEnabled(!readOnly);
    }

    public void setRequiredIndicatorVisible(boolean visible) {
        super.setRequiredIndicatorVisible(visible);
    }

    private void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        this.leftGridDataProvider.getItems().addAll(removedItems);
        this.leftGridDataProvider.getItems().removeAll(addedItems);
        this.leftGridDataProvider.refreshAll();
        this.rightGridDataProvider.getItems().addAll(addedItems);
        this.rightGridDataProvider.getItems().removeAll(removedItems);
        this.rightGridDataProvider.refreshAll();
        this.leftGrid.getSelectionModel().deselectAll();
        this.rightGrid.getSelectionModel().deselectAll();
    }

    private void configDragAndDrop(Grid<T> sourceGrid, Grid<T> targetGrid) {
        GridDragSource dragSource = new GridDragSource(sourceGrid);
        dragSource.setEffectAllowed(EffectAllowed.MOVE);
        dragSource.setDragImage((Resource)VaadinIcons.COPY);
        LinkedHashSet draggedItems = new LinkedHashSet();
        dragSource.addGridDragStartListener((GridDragStartListener & Serializable)event -> {
            this.draggedGrid = sourceGrid;
            if (!(this.draggedGrid.getSelectionModel() instanceof NoSelectionModel)) {
                if (((Grid)event.getComponent()).getSelectedItems().isEmpty()) {
                    draggedItems.addAll(event.getDraggedItems());
                } else {
                    draggedItems.addAll(((Grid)event.getComponent()).getSelectedItems());
                }
            }
        });
        dragSource.addGridDragEndListener((GridDragEndListener & Serializable)event -> {
            if (event.getDropEffect() == DropEffect.MOVE) {
                if (this.draggedGrid == null) {
                    draggedItems.clear();
                    return;
                }
                ListDataProvider dragGridSourceDataProvider = (ListDataProvider)this.draggedGrid.getDataProvider();
                dragGridSourceDataProvider.getItems().removeAll(draggedItems);
                dragGridSourceDataProvider.refreshAll();
                draggedItems.clear();
                this.draggedGrid.deselectAll();
                this.draggedGrid = null;
            }
        });
        GridDropTarget dropTarget = new GridDropTarget(targetGrid, DropMode.ON_TOP);
        dropTarget.setDropEffect(DropEffect.MOVE);
        dropTarget.addGridDropListener((GridDropListener & Serializable)event -> event.getDragSourceExtension().ifPresent(source -> {
            if (source instanceof GridDragSource && this.draggedGrid != event.getComponent()) {
                ListDataProvider dragGridTargetDataProvider = (ListDataProvider)((Grid)event.getComponent()).getDataProvider();
                dragGridTargetDataProvider.getItems().addAll(draggedItems);
                dragGridTargetDataProvider.refreshAll();
            } else {
                this.draggedGrid = null;
            }
        }));
    }

    public Registration addLeftGridSelectionListener(SelectionListener<T> listener) {
        return this.leftGrid.addSelectionListener(listener);
    }

    public Registration addRightGridSelectionListener(SelectionListener<T> listener) {
        return this.rightGrid.addSelectionListener(listener);
    }
}

