/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.syntaxhighlighter;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.syntaxhighlighter.ShLanguage;
import com.flowingcode.vaadin.addons.syntaxhighlighter.ShStyle;
import com.flowingcode.vaadin.addons.syntaxhighlighter.SyntaxHighlighter;
import com.flowingcode.vaadin.addons.syntaxhighlighter.SyntaxHighlighterDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@DemoSource
@PageTitle(value="Syntax Highlighter Add-on Demo")
@Route(value="syntax-highlighter/basic", layout=SyntaxHighlighterDemoView.class)
public class SyntaxHighlighterDemo
extends VerticalLayout {
    public SyntaxHighlighterDemo() {
        String defaultValue = "import { Prism as SyntaxHighlighter } from 'react-syntax-highlighter';\nimport { dark } from 'react-syntax-highlighter/dist/esm/styles/prism';\nconst Component = () => {\n  const codeString = '(num) => num + 1';\n  return (\n    <SyntaxHighlighter language=\"javascript\" style={dark}>\n      {codeString}\n    </SyntaxHighlighter>\n  );\n};\n";
        SyntaxHighlighter sh = new SyntaxHighlighter(ShLanguage.JAVASCRIPT, defaultValue);
        sh.setSizeFull();
        ComboBox style = new ComboBox();
        style.setItems((Object[])ShStyle.values());
        style.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> sh.setShStyle((ShStyle)style.getValue()));
        style.setValue((Object)ShStyle.A11YDARK);
        ComboBox languages = new ComboBox();
        languages.setItems((Object[])ShLanguage.values());
        languages.setItemLabelGenerator((ItemLabelGenerator & Serializable)language -> language.getName());
        languages.setValue((Object)ShLanguage.JAVASCRIPT);
        languages.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> sh.setShLanguage((ShLanguage)ev.getValue()));
        Checkbox showLineNumbers = new Checkbox("Show Line Numbers");
        showLineNumbers.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> sh.setShowLineNumbers(((Boolean)ev.getValue()).booleanValue()));
        Checkbox wrapLongLines = new Checkbox("Wrap long lines");
        wrapLongLines.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> sh.setWrapLongLines(((Boolean)ev.getValue()).booleanValue()));
        TextArea ta = new TextArea();
        ta.setValue(defaultValue);
        ta.setWidthFull();
        Button button = new Button("Update code");
        button.addClickListener((ComponentEventListener & Serializable)ev -> sh.setContent(ta.getValue()));
        this.add(new Component[]{new HorizontalLayout(new Component[]{style, languages}), showLineNumbers, wrapLongLines, sh, ta, button});
    }
}

