/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.regex;

import com.flowingcode.vaadin.addons.regex.RegularExpressionOperator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import lombok.NonNull;

public final class RegularExpression {
    private static final String ANY = ".*";
    private final RegularExpressionOperator operator;
    private final String input;
    private final Pattern pattern;
    private static final String CHARS = ".?+*\\[({$^|\\\\";
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("(?:[^CHARS]|\\\\[CHARS])+".replace("CHARS", ".?+*\\[({$^|\\\\"));
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("[CHARS]".replace("CHARS", ".?+*\\[({$^|\\\\"));
    private static final Pattern UNQUOTE_PATTERN = Pattern.compile("\\\\([CHARS])".replace("CHARS", ".?+*\\[({$^|\\\\"));

    public RegularExpression(@NonNull RegularExpressionOperator operator, @NonNull String input) throws PatternSyntaxException {
        if (operator == null) {
            throw new NullPointerException("operator is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.operator = operator;
        this.input = input;
        String regex = switch (operator) {
            default -> throw new IncompatibleClassChangeError();
            case RegularExpressionOperator.ADVANCED -> input;
            case RegularExpressionOperator.CONTAINS -> ANY + RegularExpression.quote(input) + ANY;
            case RegularExpressionOperator.ENDS_WITH -> ANY + RegularExpression.quote(input);
            case RegularExpressionOperator.STARTS_WITH -> RegularExpression.quote(input) + ANY;
        };
        this.pattern = Pattern.compile(regex);
    }

    private static String quote(String input) {
        String s1 = ESCAPE_PATTERN.matcher(input).replaceAll("\\\\$0");
        String s2 = "\\Q" + input.replace("\\E", "\\E\\\\E\\Q") + "\\E";
        return s1.length() < s2.length() ? s1 : s2;
    }

    public static RegularExpression of(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("Pattern cannot be null");
        }
        String regex = pattern.pattern();
        boolean hasLeadingWildcard = false;
        boolean hasTrailingWildcard = false;
        if (regex.startsWith(ANY)) {
            hasLeadingWildcard = true;
            regex = regex.substring(2);
        }
        if (regex.endsWith(ANY)) {
            hasTrailingWildcard = true;
            regex = regex.substring(0, regex.length() - 2);
        }
        String input = null;
        if (hasLeadingWildcard || hasTrailingWildcard) {
            if (SIMPLE_PATTERN.matcher(regex).matches()) {
                input = UNQUOTE_PATTERN.matcher(regex).replaceAll("$1");
            } else if (regex.startsWith("\\Q") && regex.endsWith("\\E")) {
                input = regex.substring(2, regex.length() - 2).replace("\\E\\\\E\\Q", "\\E");
            }
        }
        if (input != null) {
            if (hasLeadingWildcard && hasTrailingWildcard) {
                return new RegularExpression(RegularExpressionOperator.CONTAINS, input);
            }
            if (hasLeadingWildcard) {
                return new RegularExpression(RegularExpressionOperator.ENDS_WITH, input);
            }
            if (hasTrailingWildcard) {
                return new RegularExpression(RegularExpressionOperator.STARTS_WITH, input);
            }
        }
        return new RegularExpression(RegularExpressionOperator.ADVANCED, pattern.pattern(), pattern);
    }

    public String toString() {
        return this.operator + " " + this.input;
    }

    @Generated
    public RegularExpressionOperator getOperator() {
        return this.operator;
    }

    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegularExpression)) {
            return false;
        }
        RegularExpression other = (RegularExpression)o;
        RegularExpressionOperator this$operator = this.getOperator();
        RegularExpressionOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        return !(this$input == null ? other$input != null : !this$input.equals(other$input));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegularExpressionOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        return result;
    }

    @Generated
    private RegularExpression(RegularExpressionOperator operator, String input, Pattern pattern) {
        this.operator = operator;
        this.input = input;
        this.pattern = pattern;
    }
}

