/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.regex;

import com.flowingcode.vaadin.addons.regex.RegularExpression;
import com.flowingcode.vaadin.addons.regex.RegularExpressionOperator;
import com.flowingcode.vaadin.addons.regex.RegularExpressionTestField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.Collection;
import java.util.regex.PatternSyntaxException;

public class RegularExpressionField
extends CustomField<RegularExpression> {
    private final Select<RegularExpressionOperator> operatorField = new Select();
    private final TextField inputField;
    private final RegularExpressionTestField testField;
    private boolean hasPatternSyntaxError;
    private boolean testFieldEnabled;

    public RegularExpressionField() {
        this.operatorField.setItems((Object[])RegularExpressionOperator.values());
        this.inputField = new TextField();
        this.testField = new RegularExpressionTestField();
        this.testField.setVisible(false);
        this.add(new Component[]{new HorizontalLayout(new Component[]{this.operatorField, this.inputField}), this.testField});
        this.operatorField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> this.setTestFieldEnabled(this.testFieldEnabled));
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> this.testField.setPattern((RegularExpression)this.getValue()));
    }

    protected RegularExpression generateModelValue() {
        if (this.hasPatternSyntaxError) {
            this.onPatternSyntaxException(null, 0);
            this.hasPatternSyntaxError = false;
        }
        if (!this.inputField.isEmpty() && !this.operatorField.isEmpty()) {
            try {
                RegularExpression r = new RegularExpression((RegularExpressionOperator)((Object)this.operatorField.getValue()), this.inputField.getValue());
                return r;
            }
            catch (PatternSyntaxException e) {
                this.onPatternSyntaxException(e.getDescription(), e.getIndex());
                this.hasPatternSyntaxError = true;
                return null;
            }
        }
        return null;
    }

    private void onPatternSyntaxException(String description, int index) {
        Object errorMessage = description;
        if (description != null && index >= 0) {
            errorMessage = (String)errorMessage + " near index " + index;
        }
        this.setErrorMessage((String)errorMessage);
        this.inputField.setInvalid(errorMessage != null);
        this.setInvalid(errorMessage != null);
    }

    protected void setPresentationValue(RegularExpression newPresentationValue) {
        this.inputField.setValue(newPresentationValue.getInput());
        this.operatorField.setValue((Object)newPresentationValue.getOperator());
    }

    public boolean isInvalid() {
        return super.isInvalid() || this.inputField.isInvalid();
    }

    public void setTestFieldEnabled(boolean enabled) {
        this.testFieldEnabled = enabled;
        this.testField.setVisible(this.testFieldEnabled && this.operatorField.getValue() == RegularExpressionOperator.ADVANCED);
    }

    public boolean isTestFieldEnabled() {
        return this.testFieldEnabled;
    }

    public void setOperator(RegularExpressionOperator operator) {
        this.operatorField.setValue((Object)operator);
    }

    public void setTestStrings(String ... strings) {
        this.testField.setItems(strings);
    }

    public void setTestStrings(Collection<String> strings) {
        this.testField.setItems(strings);
    }
}

