/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.recurrentschedulefield.ui;

import com.flowingcode.vaadin.addons.recurrentschedulefield.api.DateTimeRange;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.RecurrentScheduleField;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Set;

public class RecurrentScheduleFieldValidator
implements Validator<DateTimeRange> {
    private final RecurrentScheduleField model;

    public RecurrentScheduleFieldValidator(RecurrentScheduleField model) {
        this.model = model;
        this.setManualValidation();
    }

    private void setManualValidation() {
        this.model.getStartTimePicker().setManualValidation(true);
        this.model.getEndTimePicker().setManualValidation(true);
        this.model.getStartDatePicker().setManualValidation(true);
        this.model.getEndDatePicker().setManualValidation(true);
        this.model.getWeekDaySelector().setManualValidation(true);
    }

    public ValidationResult apply(DateTimeRange data, ValueContext valueContext) {
        ValidationResult result = data != null ? ValidationResult.ok() : ValidationResult.error((String)this.model.getErrorMessage());
        return result;
    }

    public boolean isValid() {
        boolean datesOk = this.dateValidation((LocalDate)this.model.getStartDatePicker().getValue(), (LocalDate)this.model.getEndDatePicker().getValue());
        boolean daysOk = this.daysValidation((Set)this.model.getWeekDaySelector().getValue());
        boolean timesOk = this.timeValidation((LocalTime)this.model.getStartTimePicker().getValue(), (LocalTime)this.model.getEndTimePicker().getValue());
        this.model.refreshUI(datesOk, daysOk, timesOk);
        return datesOk && daysOk && timesOk;
    }

    private boolean dateValidation(LocalDate start, LocalDate end) {
        boolean notNull = start != null && end != null;
        return notNull && start.isBefore(end);
    }

    private boolean timeValidation(LocalTime start, LocalTime end) {
        boolean notNull = start != null && end != null;
        return notNull && start.isBefore(end);
    }

    private boolean daysValidation(Set<DayOfWeek> weekDays) {
        boolean notNull = weekDays != null;
        return notNull && !weekDays.isEmpty();
    }
}

