/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.recurrentschedulefield.ui;

import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.RecurrentScheduleField;
import com.vaadin.flow.function.SerializableRunnable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecurrentScheduleFieldI18n
implements Serializable {
    private RecurrentScheduleField component;
    private final Map<String, SerializableRunnable> actions = new HashMap<String, SerializableRunnable>();

    void attachComponent(RecurrentScheduleField component) {
        this.component = component;
    }

    Collection<SerializableRunnable> getPendingActions() {
        return this.actions.values();
    }

    private void addAction(SerializableRunnable action, String function) {
        this.actions.put(function, action);
        if (this.component != null) {
            action.run();
        }
    }

    public RecurrentScheduleFieldI18n setDatesTitle(String text) {
        this.addAction((SerializableRunnable & Serializable)() -> this.component.getDatesTitle().setText(text), "setDatesTitle");
        return this;
    }

    public String getDatesTitle() {
        return this.component != null ? this.component.getDatesTitle().getText() : null;
    }

    public RecurrentScheduleFieldI18n setDaysTitle(String text) {
        this.addAction((SerializableRunnable & Serializable)() -> this.component.getDaysTitle().setText(text), "setDaysTitle");
        return this;
    }

    public String getDaysTitle() {
        return this.component != null ? this.component.getDaysTitle().getText() : null;
    }

    public RecurrentScheduleFieldI18n setTimesTitle(String text) {
        this.addAction((SerializableRunnable & Serializable)() -> this.component.getTimesTitle().setText(text), "setTimesTitle");
        return this;
    }

    public String getTimesTitle() {
        return this.component != null ? this.component.getTimesTitle().getText() : null;
    }

    public RecurrentScheduleFieldI18n setTimesPlaceholder(String startTime, String endTime) {
        this.addAction((SerializableRunnable & Serializable)() -> {
            this.component.getStartTimePicker().setPlaceholder(startTime);
            this.component.getEndTimePicker().setPlaceholder(endTime);
        }, "setTimesPlaceholder");
        return this;
    }

    public List<String> getTimesPlaceholder() {
        return this.component != null ? List.of(this.component.getStartTimePicker().getPlaceholder(), this.component.getEndTimePicker().getPlaceholder()) : null;
    }

    public RecurrentScheduleFieldI18n setDatesPlaceholder(String startDate, String endDate) {
        this.addAction((SerializableRunnable & Serializable)() -> {
            this.component.getStartDatePicker().setPlaceholder(startDate);
            this.component.getEndDatePicker().setPlaceholder(endDate);
        }, "setDatesPlaceholder");
        return this;
    }

    public List<String> getDatesPlaceholder() {
        return this.component != null ? List.of(this.component.getStartDatePicker().getPlaceholder(), this.component.getEndDatePicker().getPlaceholder()) : null;
    }

    public RecurrentScheduleFieldI18n setDayInitials(List<String> initials) {
        if (initials == null || initials.size() != 7) {
            throw new IllegalArgumentException("Exactly 7 day initials are required");
        }
        this.addAction((SerializableRunnable & Serializable)() -> {
            this.component.setDaysInitials(initials);
            this.component.getWeekDaySelector().setWeekDaysShort(initials);
        }, "setDayInitials");
        return this;
    }

    public List<String> getDayInitials() {
        return this.component != null ? this.component.getDaysInitials() : null;
    }

    public RecurrentScheduleFieldI18n setTimeChipsText(String morning, String afternoon, String all) {
        this.addAction((SerializableRunnable & Serializable)() -> {
            this.component.getMorningChip().setText(morning);
            this.component.getAfterNoonChip().setText(afternoon);
            this.component.getAllTimeChip().setText(all);
        }, "setTimeChipsText");
        return this;
    }

    public List<String> getTimeChipsText() {
        return this.component != null ? List.of(this.component.getMorningChip().getText(), this.component.getAfterNoonChip().getText(), this.component.getAllTimeChip().getText()) : null;
    }

    public RecurrentScheduleFieldI18n setDaysChipsText(String weekend, String weekdays, String all) {
        this.addAction((SerializableRunnable & Serializable)() -> {
            this.component.getWeekdaysChip().setText(weekdays);
            this.component.getWeekendChip().setText(weekend);
            this.component.getAllDaysChip().setText(all);
        }, "setDaysChipsText");
        return this;
    }

    public List<String> getDaysChipsText() {
        return this.component != null ? List.of(this.component.getWeekdaysChip().getText(), this.component.getWeekendChip().getText(), this.component.getAllDaysChip().getText()) : null;
    }
}

