/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.recurrentschedulefield.ui;

import com.flowingcode.vaadin.addons.dayofweekselector.DayOfWeekSelector;
import com.flowingcode.vaadin.addons.recurrentschedulefield.api.DateTimeRange;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.ChipGroup;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.Circle;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.RecurrentScheduleFieldI18n;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.RecurrentScheduleFieldValidator;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.SpanLine;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.timepicker.TimePicker;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class RecurrentScheduleField
extends CustomField<DateTimeRange>
implements HasValidator<DateTimeRange> {
    static final String defaultErrorMessage = "Invalid or incomplete fields remaining";
    private static final String SUCCESS_COLOR = "var(--lumo-primary-color)";
    private static final String ERROR_COLOR = "var(--lumo-error-color)";
    private RecurrentScheduleFieldValidator validator;
    private DatePicker startDatePicker;
    private DatePicker endDatePicker;
    private TimePicker startTimePicker;
    private TimePicker endTimePicker;
    private DayOfWeekSelector weekDaySelector;
    private SpanLine daysDivider;
    private SpanLine timeDivider;
    private Circle dateCircle;
    private Circle timeCircle;
    private Circle daysCircle;
    private H5 datesTitle;
    private H5 daysTitle;
    private H5 timesTitle;
    private Component dateSelector;
    private Component daysSelector;
    private Component timeSelector;
    private Div verticalLine;
    private ChipGroup daysChipGroup;
    private ChipGroup.Chip weekdaysChip;
    private ChipGroup.Chip weekendChip;
    private ChipGroup.Chip allDaysChip;
    private ChipGroup timeChipGroup;
    private ChipGroup.Chip morningChip;
    private ChipGroup.Chip afterNoonChip;
    private ChipGroup.Chip allTimeChip;
    private List<String> daysInitials;
    private Integer maxDaysSpan = null;

    public RecurrentScheduleField() {
        this(defaultErrorMessage);
    }

    public RecurrentScheduleField(String errorMessage) {
        this.setUI();
        this.setDefaultI18n();
        this.setErrorMessage(errorMessage);
    }

    public RecurrentScheduleField(DateTimeRange defaultValue, String errorMessage) {
        super((Object)defaultValue);
        this.setUI();
        this.setDefaultI18n();
        this.setErrorMessage(errorMessage);
        this.setPresentationValue(defaultValue);
    }

    public RecurrentScheduleField(DateTimeRange defaultValue) {
        this(defaultValue, defaultErrorMessage);
    }

    private void setUI() {
        this.addClassNames(new String[]{"w-auto", "inline", "m-0", "p-s"});
        HorizontalLayout rootLayout = new HorizontalLayout();
        rootLayout.addClassNames(new String[]{"p-s", "w-full", "h-full", "items-stretch", "gap-m"});
        VerticalLayout mainLayout = new VerticalLayout();
        this.dateSelector = this.getDateSelectors();
        this.daysSelector = this.getDaysSelector();
        this.timeSelector = this.getTimeSelectors();
        this.verticalLine = new Div();
        this.verticalLine.getStyle().setBackgroundColor("var(--lumo-contrast-10pct)");
        this.verticalLine.setMinWidth("1px");
        this.verticalLine.setMaxWidth("1px");
        this.verticalLine.setMinHeight("100%");
        this.verticalLine.setMaxHeight("100%");
        mainLayout.addClassNames(new String[]{"gap-m", "inline-flex", "items-stretch", "p-0", "flex-grow"});
        this.validator = new RecurrentScheduleFieldValidator(this);
        mainLayout.add(new Component[]{this.dateSelector, this.daysSelector, this.timeSelector});
        rootLayout.add(new Component[]{this.verticalLine, mainLayout});
        this.add(new Component[]{rootLayout});
    }

    void refreshUI(boolean datesOk, boolean daysOk, boolean timesOk) {
        this.daysDivider.setText(RecurrentScheduleField.formatDaysSpan((LocalDate)this.startDatePicker.getValue(), (LocalDate)this.endDatePicker.getValue()));
        this.timeDivider.setText(RecurrentScheduleField.formatTimeSpan((LocalTime)this.startTimePicker.getValue(), (LocalTime)this.endTimePicker.getValue()));
        this.startDatePicker.setInvalid(this.startDatePicker.getValue() != null && this.endDatePicker.getValue() != null && !datesOk);
        this.endDatePicker.setInvalid(this.startDatePicker.getValue() != null && this.endDatePicker.getValue() != null && !datesOk);
        this.dateCircle.setColor(datesOk ? SUCCESS_COLOR : ERROR_COLOR);
        this.daysCircle.setColor(daysOk ? SUCCESS_COLOR : ERROR_COLOR);
        this.startTimePicker.setInvalid(this.startTimePicker.getValue() != null && this.endTimePicker.getValue() != null && !timesOk);
        this.endTimePicker.setInvalid(this.startTimePicker.getValue() != null && this.endTimePicker.getValue() != null && !timesOk);
        this.timeCircle.setColor(timesOk ? SUCCESS_COLOR : ERROR_COLOR);
    }

    private Component getDateSelectors() {
        VerticalLayout layout = new VerticalLayout();
        layout.addClassNames(new String[]{"gap-s", "p-0", "gap-xs"});
        Div headerWrapper = new Div();
        headerWrapper.addClassNames(new String[]{"flex", "items-center", "gap-s", "relative", "pb-s"});
        this.datesTitle = new H5();
        this.dateCircle = new Circle();
        headerWrapper.add(new Component[]{this.dateCircle, this.datesTitle});
        this.startDatePicker = new DatePicker();
        this.startDatePicker.setClearButtonVisible(true);
        this.startDatePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)it -> {
            if (this.maxDaysSpan != null && this.maxDaysSpan > 0) {
                LocalDate current = (LocalDate)it.getValue();
                LocalDate maxDate = current != null ? current.plusDays(this.maxDaysSpan.intValue()) : null;
                this.endDatePicker.setMax(maxDate);
            }
        });
        this.endDatePicker = new DatePicker();
        this.endDatePicker.setClearButtonVisible(true);
        this.endDatePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)it -> {
            if (this.maxDaysSpan != null && this.maxDaysSpan > 0) {
                LocalDate current = (LocalDate)it.getValue();
                LocalDate minDate = current != null ? current.minusDays(this.maxDaysSpan.intValue()) : null;
                this.startDatePicker.setMin(minDate);
            }
        });
        this.daysDivider = new SpanLine();
        HorizontalLayout selectorLayout = new HorizontalLayout();
        selectorLayout.addClassNames(new String[]{"gap-s"});
        selectorLayout.add(new Component[]{this.startDatePicker, this.daysDivider, this.endDatePicker});
        layout.add(new Component[]{headerWrapper, selectorLayout});
        return layout;
    }

    private Component getDaysSelector() {
        VerticalLayout layout = new VerticalLayout();
        layout.addClassNames(new String[]{"items-stretch", "pb-0", "p-0", "gap-xs"});
        this.daysTitle = new H5();
        HorizontalLayout headerLayout = new HorizontalLayout();
        headerLayout.addClassNames(new String[]{"items-center", "relative", "justify-between"});
        this.weekendChip = new ChipGroup.Chip();
        this.weekdaysChip = new ChipGroup.Chip();
        this.allDaysChip = new ChipGroup.Chip();
        this.daysChipGroup = new ChipGroup(this.weekendChip, this.weekdaysChip, this.allDaysChip);
        this.daysCircle = new Circle();
        headerLayout.add(new Component[]{this.daysCircle, this.daysTitle, this.daysChipGroup});
        this.weekDaySelector = new DayOfWeekSelector();
        this.weekDaySelector.getChildren().forEach(e -> e.getStyle().setScale("1.15"));
        this.weekDaySelector.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> this.updateValue());
        this.weekDaySelector.setFirstDayOfWeek(DayOfWeek.SUNDAY);
        this.weekDaySelector.addClassNames(new String[]{"self-center", "p-0", "m-0"});
        this.weekendChip.onPress((SerializableConsumer<Boolean>)(SerializableConsumer & Serializable)checked -> {
            if (checked.booleanValue()) {
                this.weekDaySelector.setValue(DayOfWeek.SUNDAY, new DayOfWeek[]{DayOfWeek.SATURDAY});
                this.updateValue();
            }
            this.weekDaySelector.setReadOnly(checked.booleanValue());
        });
        this.weekdaysChip.onPress((SerializableConsumer<Boolean>)(SerializableConsumer & Serializable)checked -> {
            if (checked.booleanValue()) {
                this.weekDaySelector.setValue(DayOfWeek.MONDAY, new DayOfWeek[]{DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY});
                this.updateValue();
            }
            this.weekDaySelector.setReadOnly(checked.booleanValue());
        });
        this.allDaysChip.onPress((SerializableConsumer<Boolean>)(SerializableConsumer & Serializable)checked -> {
            if (checked.booleanValue()) {
                this.weekDaySelector.setValue(DayOfWeek.MONDAY, new DayOfWeek[]{DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY});
                this.updateValue();
            }
            this.weekDaySelector.setReadOnly(checked.booleanValue());
        });
        layout.add(new Component[]{headerLayout, this.weekDaySelector});
        return layout;
    }

    private Component getTimeSelectors() {
        VerticalLayout layout = new VerticalLayout();
        layout.addClassNames(new String[]{"items-stretch", "p-0", "gap-xs"});
        this.timesTitle = new H5();
        this.morningChip = new ChipGroup.Chip();
        this.afterNoonChip = new ChipGroup.Chip();
        this.allTimeChip = new ChipGroup.Chip();
        this.timeChipGroup = new ChipGroup(this.morningChip, this.afterNoonChip, this.allTimeChip);
        this.startTimePicker = new TimePicker();
        this.startTimePicker.setStep(Duration.ofMinutes(30L));
        this.startTimePicker.setLocale(Locale.FRENCH);
        this.startTimePicker.setClearButtonVisible(true);
        this.endTimePicker = new TimePicker();
        this.endTimePicker.setStep(Duration.ofMinutes(30L));
        this.endTimePicker.setLocale(Locale.FRENCH);
        this.endTimePicker.setClearButtonVisible(true);
        this.morningChip.onPress((SerializableConsumer<Boolean>)(SerializableConsumer & Serializable)checked -> this.applyTime(LocalTime.MIN, LocalTime.NOON, (boolean)checked));
        this.afterNoonChip.onPress((SerializableConsumer<Boolean>)(SerializableConsumer & Serializable)checked -> this.applyTime(LocalTime.NOON, LocalTime.MAX, (boolean)checked));
        this.allTimeChip.onPress((SerializableConsumer<Boolean>)(SerializableConsumer & Serializable)checked -> this.applyTime(LocalTime.MIN, LocalTime.MAX, (boolean)checked));
        this.timeDivider = new SpanLine();
        HorizontalLayout headerLayout = new HorizontalLayout();
        headerLayout.addClassNames(new String[]{"items-center", "relative", "justify-between"});
        this.timeCircle = new Circle();
        headerLayout.add(new Component[]{this.timeCircle, this.timesTitle, this.timeChipGroup});
        HorizontalLayout selectorLayout = new HorizontalLayout();
        selectorLayout.addClassNames(new String[]{"gap-s"});
        selectorLayout.add(new Component[]{this.startTimePicker, this.timeDivider, this.endTimePicker});
        layout.add(new Component[]{headerLayout, selectorLayout});
        return layout;
    }

    public DateTimeRange getValue() {
        return (DateTimeRange)super.getValue();
    }

    protected DateTimeRange generateModelValue() {
        boolean isValid = this.validator.isValid();
        this.setInvalid(!isValid);
        if (isValid) {
            return new DateTimeRange((LocalDate)this.startDatePicker.getValue(), (LocalDate)this.endDatePicker.getValue(), (LocalTime)this.startTimePicker.getValue(), (LocalTime)this.endTimePicker.getValue(), (Set)this.weekDaySelector.getValue());
        }
        return null;
    }

    protected void setPresentationValue(DateTimeRange dateTimeRange) {
        if (dateTimeRange == null) {
            this.startDatePicker.clear();
            this.endDatePicker.clear();
            this.startTimePicker.clear();
            this.endTimePicker.clear();
            this.weekDaySelector.clear();
            this.daysDivider.clearText();
            this.timeDivider.clearText();
        } else {
            this.startDatePicker.setValue(dateTimeRange.getStartDate());
            this.endDatePicker.setValue(dateTimeRange.getEndDate());
            this.startTimePicker.setValue(dateTimeRange.getStartTime());
            this.endTimePicker.setValue(dateTimeRange.getEndTime());
            this.weekDaySelector.setValue(dateTimeRange.getWeekDays());
            this.daysDivider.setText(RecurrentScheduleField.formatDaysSpan(dateTimeRange.getStartDate(), dateTimeRange.getEndDate()));
            this.timeDivider.setText(RecurrentScheduleField.formatTimeSpan(dateTimeRange.getStartTime(), dateTimeRange.getEndTime()));
        }
    }

    public Validator<DateTimeRange> getDefaultValidator() {
        return this.validator;
    }

    public void setVisible(boolean visible) {
        this.getElement().setVisible(visible);
        this.setDatesVisible(visible);
        this.setDaysVisible(visible);
        this.setTimesVisible(visible);
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setProperty("readonly", readOnly);
        this.setDaysReadOnly(readOnly);
        this.setTimesReadOnly(readOnly);
        this.setDatesReadOnly(readOnly);
        this.timeChipGroup.setReadOnly(readOnly);
        this.daysChipGroup.setReadOnly(readOnly);
    }

    public void setMaxDaysSpan(int max) {
        this.maxDaysSpan = max;
    }

    public void setMinDate(LocalDate date) {
        this.startDatePicker.setMin(date);
        this.endDatePicker.setMin(date);
    }

    public void setMaxDate(LocalDate date) {
        this.endDatePicker.setMax(date);
        this.startDatePicker.setMax(date);
    }

    public void setMinTime(LocalTime time) {
        this.startTimePicker.setMin(time);
        this.endTimePicker.setMin(time);
        this.morningChip.setVisible((time == null || time.isBefore(LocalTime.NOON)) && this.afterNoonChip.isVisible());
    }

    public void setMaxTime(LocalTime time) {
        this.startTimePicker.setMax(time);
        this.endTimePicker.setMax(time);
        this.afterNoonChip.setVisible((time == null || time.isAfter(LocalTime.NOON)) && this.morningChip.isVisible());
    }

    public void setWeekDays(DayOfWeek ... weekDaySelector) {
        this.weekDaySelector.setValue(Set.of(weekDaySelector));
    }

    public void setFirstWeekDay(DayOfWeek weekDay) {
        this.weekDaySelector.setFirstDayOfWeek(weekDay);
    }

    public void setDatesReadOnly(boolean readOnly) {
        this.startDatePicker.setReadOnly(readOnly);
        this.endDatePicker.setReadOnly(readOnly);
    }

    public void setDatesVisible(boolean visible) {
        this.dateSelector.setVisible(visible);
    }

    public void setDaysReadOnly(boolean readOnly) {
        this.weekDaySelector.setReadOnly(readOnly);
        this.daysChipGroup.setReadOnly(readOnly);
    }

    public void setDaysVisible(boolean visible) {
        this.daysSelector.setVisible(visible);
    }

    public void setDaysChipsVisible(boolean visible) {
        this.daysChipGroup.setVisible(visible);
    }

    public void setTimesReadOnly(boolean readOnly) {
        this.startTimePicker.setReadOnly(readOnly);
        this.endTimePicker.setReadOnly(readOnly);
        this.timeChipGroup.setReadOnly(readOnly);
    }

    public void setTimesVisible(boolean visible) {
        this.timeSelector.setVisible(visible);
    }

    public void setTimeChipsVisible(boolean visible) {
        this.timeChipGroup.setVisible(visible);
    }

    public void setIndicatorVisible(boolean visible) {
        this.verticalLine.setVisible(visible);
        this.dateCircle.setVisible(visible);
        this.daysCircle.setVisible(visible);
        this.timeCircle.setVisible(visible);
    }

    public void setTimeStep(Duration step) {
        this.startTimePicker.setStep(step);
        this.endTimePicker.setStep(step);
    }

    public void setTimeLocale(Locale locale) {
        this.startTimePicker.setLocale(locale);
        this.endTimePicker.setLocale(locale);
    }

    public void setI18n(RecurrentScheduleFieldI18n i18n) {
        if (i18n != null) {
            i18n.attachComponent(this);
            for (SerializableRunnable action : i18n.getPendingActions()) {
                if (action == null) continue;
                action.run();
            }
        }
    }

    private void setDefaultI18n() {
        RecurrentScheduleFieldI18n defaultI18n = new RecurrentScheduleFieldI18n().setDatesTitle("Select dates range").setDatesPlaceholder("Start date", "End date").setDaysTitle("Select days").setDayInitials(List.of("S", "M", "T", "W", "T", "F", "S")).setDaysChipsText("Weekend", "Weekdays", "All").setTimesTitle("Select times range").setTimeChipsText("Morning", "Afternoon", "All").setTimesPlaceholder("Start time", "End time");
        this.setI18n(defaultI18n);
    }

    private void applyTime(LocalTime start, LocalTime end, boolean checked) {
        if (checked) {
            LocalTime min = this.startTimePicker.getMin();
            LocalTime max = this.endTimePicker.getMax();
            LocalTime minTime = min != null && min.isAfter(start) ? min : start;
            LocalTime maxTime = max != null && max.isBefore(end) ? max : end;
            this.startTimePicker.setValue(minTime);
            this.endTimePicker.setValue(maxTime);
            this.updateValue();
        }
        this.startTimePicker.setReadOnly(checked);
        this.endTimePicker.setReadOnly(checked);
    }

    private static String formatTimeSpan(LocalTime startTime, LocalTime endTime) {
        if (startTime == null || endTime == null) {
            return "";
        }
        Duration duration = Duration.between(startTime, endTime);
        int hours = duration.toHoursPart();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        boolean isNegative = hours < 0 || minutes < 0 || seconds < 0;
        return String.format((isNegative ? "-" : "+") + "%02d:%02d:%02d", isNegative ? Math.abs(hours) : hours, isNegative ? Math.abs(minutes) : minutes, isNegative ? Math.abs(seconds) : seconds);
    }

    private static String formatDaysSpan(LocalDate startDate, LocalDate endDate) {
        if (startDate == null || endDate == null) {
            return "";
        }
        long days = ChronoUnit.DAYS.between(startDate, endDate);
        return days >= 0L ? "+" + days : "" + days;
    }

    DatePicker getStartDatePicker() {
        return this.startDatePicker;
    }

    DatePicker getEndDatePicker() {
        return this.endDatePicker;
    }

    TimePicker getStartTimePicker() {
        return this.startTimePicker;
    }

    TimePicker getEndTimePicker() {
        return this.endTimePicker;
    }

    DayOfWeekSelector getWeekDaySelector() {
        return this.weekDaySelector;
    }

    H5 getDatesTitle() {
        return this.datesTitle;
    }

    H5 getDaysTitle() {
        return this.daysTitle;
    }

    H5 getTimesTitle() {
        return this.timesTitle;
    }

    ChipGroup.Chip getWeekdaysChip() {
        return this.weekdaysChip;
    }

    ChipGroup.Chip getWeekendChip() {
        return this.weekendChip;
    }

    ChipGroup.Chip getAllDaysChip() {
        return this.allDaysChip;
    }

    ChipGroup.Chip getMorningChip() {
        return this.morningChip;
    }

    ChipGroup.Chip getAfterNoonChip() {
        return this.afterNoonChip;
    }

    ChipGroup.Chip getAllTimeChip() {
        return this.allTimeChip;
    }

    List<String> getDaysInitials() {
        return this.daysInitials;
    }

    void setDaysInitials(List<String> daysInitials) {
        this.daysInitials = daysInitials;
    }
}

