/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.recurrentschedulefield.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@CssImport(value="./styles/fc-recurrent-schedule-field.css")
class ChipGroup
extends HorizontalLayout {
    private final Set<Chip> chips = new HashSet<Chip>();
    private Chip checkedChip;
    private boolean readOnly = false;

    public ChipGroup() {
        this.addClassNames(new String[]{"items-center", "justify-end", "gap-s", "flex-wrap", "pl-s", "py-s"});
    }

    public ChipGroup(Chip ... chips) {
        this();
        for (Chip chip : chips) {
            this.addChip(chip);
        }
    }

    public void addChip(Chip chip) {
        this.chips.add(chip);
        chip.setChipGroup(this);
        chip.setReadOnly(this.readOnly);
        this.add(new Component[]{chip});
    }

    private void onChipChange(Chip chip) {
        if (this.checkedChip != null && chip.isChecked() && !((Object)((Object)this.checkedChip)).equals((Object)chip)) {
            this.checkedChip.setChecked(false);
        }
        this.checkedChip = chip.isChecked() ? chip : null;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.chips.forEach(c -> c.setReadOnly(readOnly));
    }

    public void setVisible(boolean visible) {
        this.getStyle().set("visibility", visible ? "visible" : "hidden");
    }

    static class Chip
    extends HorizontalLayout {
        private boolean checked = false;
        private boolean readOnly = false;
        private final Icon checkIcon;
        private final Span textField;
        private ChipGroup chipGroup;
        private SerializableConsumer<Boolean> listener;

        public Chip() {
            this.addClassNames(new String[]{"px-m", "py-xs", "fc-rsf-hoverable", "items-center", "rounded-l", "border", "border-contrast-10", "inline-flex", "gap-s"});
            this.checkIcon = VaadinIcon.CHECK.create();
            this.checkIcon.setSize("14px");
            this.textField = new Span();
            this.textField.addClassNames(new String[]{"text-s", "font-semibold", "m-0", "p-0", "leading-s"});
            this.addClickListener((ComponentEventListener & Serializable)ev -> {
                if (!this.readOnly) {
                    this.toggle(!this.checked);
                    if (this.listener != null) {
                        this.listener.accept((Object)this.checked);
                    }
                    if (this.chipGroup != null) {
                        this.chipGroup.onChipChange(this);
                    }
                }
            });
            this.add(new Component[]{this.textField});
        }

        private void toggle(Boolean isChecked) {
            if (isChecked.booleanValue()) {
                this.removeClassName("fc-rsf-unselected");
                this.addClassName("fc-rsf-selected");
                this.addComponentAsFirst((Component)this.checkIcon);
            } else {
                this.removeClassName("fc-rsf-selected");
                this.addClassName("fc-rsf-unselected");
                this.remove(new Component[]{this.checkIcon});
            }
            this.checked = isChecked;
        }

        private void setChipGroup(ChipGroup chipGroup) {
            this.chipGroup = chipGroup;
        }

        public void onPress(SerializableConsumer<Boolean> onClick) {
            this.listener = onClick;
        }

        public void setChecked(boolean isChecked) {
            this.toggle(isChecked);
        }

        public boolean isChecked() {
            return this.checked;
        }

        public String getText() {
            return this.textField.getText();
        }

        public void setText(String text) {
            this.textField.setText(text);
        }

        public void setReadOnly(boolean readOnly) {
            if (this.readOnly == readOnly) {
                return;
            }
            this.readOnly = readOnly;
            if (readOnly) {
                this.removeClassName("fc-rsf-hoverable");
                this.removeClassName("text-body");
                this.addClassName("text-secondary");
                this.addClassName("fc-rsf-readonly");
            } else {
                this.removeClassName("fc-rsf-readonly");
                this.removeClassName("text-secondary");
                this.addClassName("fc-rsf-hoverable");
                this.addClassName("text-body");
            }
        }
    }
}

