/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.recurrentschedulefield.api;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;

public class TimeInterval
implements Serializable,
Comparable<TimeInterval> {
    private final LocalDateTime startDate;
    private final LocalDateTime endDate;

    public TimeInterval(LocalDateTime start, LocalDateTime end) {
        if (!start.isBefore(end)) {
            throw new IllegalArgumentException("Start time must be before end time");
        }
        this.startDate = start;
        this.endDate = end;
    }

    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public boolean includes(LocalDateTime date) {
        boolean startCheck = this.startDate.isBefore(date) || this.startDate.equals(date);
        boolean endCheck = this.endDate.isAfter(date);
        return startCheck && endCheck;
    }

    public boolean isBefore(LocalDateTime date) {
        return this.endDate.isBefore(date) || this.endDate.equals(date);
    }

    public boolean isAfter(LocalDateTime date) {
        return this.startDate.isAfter(date);
    }

    public Duration getDuration() {
        return Duration.between(this.startDate, this.endDate);
    }

    @Override
    public int compareTo(TimeInterval o) {
        return this.startDate.compareTo(o.getStartDate());
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimeInterval)) {
            return false;
        }
        TimeInterval that = (TimeInterval)o;
        return Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }
}

