/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.recurrentschedulefield.api;

import com.flowingcode.vaadin.addons.recurrentschedulefield.api.TimeInterval;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DateTimeRange
implements Serializable {
    private static final DayOfWeek[] defaultWeekDays = DayOfWeek.values();
    private static final LocalTime defaultStartTime = LocalTime.MIN;
    private static final LocalTime defaultEndTime = LocalTime.MAX;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final TreeSet<DayOfWeek> weekDays = new TreeSet();
    private LocalTime startTime = defaultStartTime;
    private LocalTime endTime = defaultEndTime;

    public DateTimeRange(LocalDate startDate, LocalDate endDate, Set<DayOfWeek> weekDays) {
        if (!startDate.isBefore(endDate)) {
            throw new IllegalArgumentException("startDate must be before endDate");
        }
        this.startDate = startDate;
        this.endDate = endDate;
        this.setWeekDays(weekDays);
    }

    public DateTimeRange(LocalDate startDate, LocalDate endDate) {
        this(startDate, endDate, Set.of(defaultWeekDays));
    }

    public DateTimeRange(LocalDate startDate, LocalDate endDate, LocalTime startTime, LocalTime endTime, Set<DayOfWeek> weekDays) {
        this(startDate, endDate, weekDays);
        this.setDayDuration(startTime, endTime);
    }

    public DateTimeRange(LocalDate startDate, LocalDate endDate, LocalTime startTime, LocalTime endTime) {
        this(startDate, endDate, startTime, endTime, Set.of(defaultWeekDays));
    }

    public void setDayDuration(LocalTime startTime, LocalTime endTime) {
        if (!startTime.isBefore(endTime)) {
            throw new IllegalArgumentException("startTime must be before endTime");
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public void setWeekDays(Set<DayOfWeek> weekDays) {
        if (weekDays == null || weekDays.isEmpty()) {
            throw new IllegalArgumentException("weekDays can't be null or empty");
        }
        this.weekDays.clear();
        this.weekDays.addAll(weekDays);
    }

    public void setAllWeekDays() {
        this.setWeekDays(Set.of(DayOfWeek.values()));
    }

    public Set<DayOfWeek> getWeekDays() {
        return Set.copyOf(this.weekDays);
    }

    public List<TimeInterval> getIntervals() {
        return this.generateIntervals(this.startDate.atTime(this.startTime), this.endDate);
    }

    public boolean includes(LocalDate date) {
        return this.weekDays.contains(date.getDayOfWeek()) && this.insideRange(date);
    }

    public boolean includes(LocalDateTime dateTime) {
        boolean contains = false;
        LocalDate date = dateTime.toLocalDate();
        if (this.includes(date)) {
            TimeInterval interval = new TimeInterval(date.atTime(this.startTime), date.atTime(this.endTime));
            contains = interval.includes(dateTime);
        }
        return contains;
    }

    public TimeInterval getNextInterval(LocalDate from) {
        LocalDateTime dateTime = LocalDateTime.of(from, this.startTime);
        return this.getNextInterval(dateTime);
    }

    public TimeInterval getNextInterval() {
        return this.getNextInterval(LocalDateTime.now());
    }

    public TimeInterval getNextInterval(LocalDateTime from) {
        LocalDate date = from.toLocalDate();
        TimeInterval interval = null;
        long offset = this.getStartOffset(from);
        if (this.insideRange(date = date.plusDays(offset))) {
            interval = new TimeInterval(LocalDateTime.of(date, this.startTime), LocalDateTime.of(date, this.endTime));
        }
        return interval;
    }

    public List<TimeInterval> getIntervalsLeft() {
        return this.getIntervalsLeft(LocalDateTime.now());
    }

    public List<TimeInterval> getIntervalsLeft(LocalDateTime from) {
        return this.generateIntervals(from, this.endDate);
    }

    public List<TimeInterval> getIntervalsLeft(LocalDate from) {
        return this.getIntervalsLeft(from.atTime(LocalTime.MIN));
    }

    public List<TimeInterval> getPastIntervals() {
        return this.getPastIntervals(LocalDateTime.now());
    }

    public List<TimeInterval> getPastIntervals(LocalDate from) {
        return this.getPastIntervals(from.atTime(LocalTime.MIN));
    }

    public List<TimeInterval> getPastIntervals(LocalDateTime from) {
        LocalTime endTime = from.toLocalTime();
        LocalDate endDate = from.toLocalDate();
        return this.generateIntervals(this.startDate.atTime(this.startTime), !endTime.isBefore(this.endTime) ? endDate.plusDays(1L) : endDate);
    }

    public Duration getDayDuration() {
        return Duration.between(this.startTime, this.endTime);
    }

    public Period getDatesPeriod() {
        return Period.between(this.startDate, this.endDate);
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    private DayOfWeek getNextDay(DayOfWeek previous) {
        DayOfWeek current = previous.plus(1L);
        while (!this.weekDays.contains(current)) {
            current = current.plus(1L);
        }
        return current;
    }

    private int daysBetween(DayOfWeek from, DayOfWeek to) {
        int offset = to.getValue() - from.getValue();
        if (offset <= 0) {
            offset = 7 + offset;
        }
        return offset;
    }

    private boolean insideRange(LocalDate date) {
        return !this.startDate.isAfter(date) && this.endDate.isAfter(date);
    }

    private List<TimeInterval> generateIntervals(LocalDateTime from, LocalDate to) {
        DayOfWeek nextDay;
        DayOfWeek lastDay;
        ArrayList<TimeInterval> entities = new ArrayList<TimeInterval>();
        LocalDate startDate = from.toLocalDate();
        long totalDays = this.getTotalDays(startDate, to);
        for (long startOffset = this.getStartOffset(from); startOffset < totalDays; startOffset += (long)this.daysBetween(lastDay, nextDay)) {
            LocalDate current = startDate.plusDays(startOffset);
            LocalDateTime start = LocalDateTime.of(current, this.startTime);
            LocalDateTime end = LocalDateTime.of(current, this.endTime);
            TimeInterval timeInterval = new TimeInterval(start, end);
            entities.add(timeInterval);
            lastDay = current.getDayOfWeek();
            nextDay = this.getNextDay(lastDay);
        }
        return entities;
    }

    private long getTotalDays(LocalDate startDate, LocalDate endDate) {
        LocalDate start = startDate.isBefore(this.startDate) ? this.startDate : startDate;
        LocalDate end = endDate.isAfter(this.endDate) ? this.endDate : endDate;
        return ChronoUnit.DAYS.between(start, end);
    }

    private long getStartOffset(LocalDateTime startDate) {
        DayOfWeek firstDay = startDate.getDayOfWeek();
        if (!this.weekDays.contains(firstDay) || !this.endTime.isAfter(startDate.toLocalTime())) {
            DayOfWeek nextDay = this.getNextDay(startDate.getDayOfWeek());
            return this.daysBetween(firstDay, nextDay);
        }
        return 0L;
    }
}

