/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.recurrentschedulefield;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.recurrentschedulefield.RecurrentScheduleFieldDemoView;
import com.flowingcode.vaadin.addons.recurrentschedulefield.api.DateTimeRange;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.RecurrentScheduleField;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.RecurrentScheduleFieldI18n;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

@PageTitle(value="States")
@Route(value="recurrent-schedule-field/states", layout=RecurrentScheduleFieldDemoView.class)
@DemoSource
public class StatesDemo
extends VerticalLayout {
    private boolean indicator = true;
    private final Map<PickerSection, Boolean> readOnly = new HashMap<PickerSection, Boolean>();
    private final Map<PickerSection, Boolean> visible = new HashMap<PickerSection, Boolean>();

    public StatesDemo() {
        this.setSizeFull();
        this.addClassNames(new String[]{"items-center"});
        DateTimeRange dtr = new DateTimeRange(LocalDate.now(), LocalDate.now().plusDays(10L), LocalTime.MIN, LocalTime.NOON);
        RecurrentScheduleField field = new RecurrentScheduleField(dtr);
        field.setFirstWeekDay(DayOfWeek.THURSDAY);
        field.setI18n(new RecurrentScheduleFieldI18n().setDatesTitle("Custom date title").setTimeChipsText("AM", "PM", "AM + PM").setTimesPlaceholder("Begin", "End"));
        VerticalLayout buttonLayout = new VerticalLayout();
        HorizontalLayout readOnlyLayout = new HorizontalLayout();
        HorizontalLayout visibleLayout = new HorizontalLayout();
        Button indicatorButton = new Button("Toggle indicator", (ComponentEventListener & Serializable)ev -> {
            this.indicator = !this.indicator;
            field.setIndicatorVisible(this.indicator);
        });
        for (PickerSection section : PickerSection.values()) {
            readOnlyLayout.add(new Component[]{new Button("Toggle " + section.name().toLowerCase() + " read only", (ComponentEventListener & Serializable)ev -> {
                boolean value = this.readOnly.getOrDefault((Object)section, false) == false;
                this.readOnly.put(section, value);
                switch (section) {
                    case DATES: {
                        field.setDatesReadOnly(value);
                        break;
                    }
                    case DAYS: {
                        field.setDaysReadOnly(value);
                        break;
                    }
                    case TIMES: {
                        field.setTimesReadOnly(value);
                    }
                }
            })});
            visibleLayout.add(new Component[]{new Button("Toggle " + section.name().toLowerCase() + " visible", (ComponentEventListener & Serializable)ev -> {
                boolean value = this.visible.getOrDefault((Object)section, true) == false;
                this.visible.put(section, value);
                switch (section) {
                    case DATES: {
                        field.setDatesVisible(value);
                        break;
                    }
                    case DAYS: {
                        field.setDaysVisible(value);
                        break;
                    }
                    case TIMES: {
                        field.setTimesVisible(value);
                    }
                }
            })});
        }
        buttonLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        readOnlyLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        visibleLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        buttonLayout.add(new Component[]{indicatorButton, readOnlyLayout, visibleLayout});
        this.add(new Component[]{field, buttonLayout});
    }

    private static enum PickerSection {
        DATES,
        DAYS,
        TIMES;

    }
}

