/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.recurrentschedulefield;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.recurrentschedulefield.RecurrentScheduleFieldDemoView;
import com.flowingcode.vaadin.addons.recurrentschedulefield.api.DateTimeRange;
import com.flowingcode.vaadin.addons.recurrentschedulefield.api.TimeInterval;
import com.flowingcode.vaadin.addons.recurrentschedulefield.ui.RecurrentScheduleField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.StatusChangeListener;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

@PageTitle(value="Binding")
@Route(value="recurrent-schedule-field/binder", layout=RecurrentScheduleFieldDemoView.class)
@DemoSource
public class BinderDemo
extends VerticalLayout {
    private final Button dateButton = new Button("Show dates range");
    private final Button daysButton = new Button("Show days");
    private final Button timeButton = new Button("Show times range");
    private final Button intervalButton = new Button("Update intervals");
    private final List<TimeInterval> intervals = new ArrayList<TimeInterval>();
    private Grid<TimeInterval> grid = null;
    private GridListDataView<TimeInterval> dataView = null;

    public BinderDemo() {
        this.setSizeFull();
        this.addClassNames(new String[]{"items-center"});
        RecurrentScheduleField field = new RecurrentScheduleField();
        field.setMaxDaysSpan(30);
        Pojo pojo = new Pojo();
        Binder binder = new Binder(Pojo.class);
        binder.forField((HasValue)field).bind(Pojo::getDateTimeRange, Pojo::setDateTimeRange);
        binder.setBean((Object)pojo);
        binder.addStatusChangeListener((StatusChangeListener & Serializable)ev -> {
            boolean isValid = binder.isValid();
            this.dateButton.setEnabled(isValid);
            this.daysButton.setEnabled(isValid);
            this.timeButton.setEnabled(isValid);
            this.intervalButton.setEnabled(isValid);
        });
        this.grid = new Grid(TimeInterval.class, false);
        this.dataView = (GridListDataView)this.grid.setItems(this.intervals);
        this.intervalButton.addClickListener((ComponentEventListener & Serializable)ev -> {
            this.intervals.clear();
            this.intervals.addAll(pojo.getDateTimeRange().getIntervals());
            this.dataView.refreshAll();
        });
        this.intervalButton.setEnabled(false);
        this.dateButton.addClickListener((ComponentEventListener & Serializable)ev -> {
            DateTimeRange result = pojo.getDateTimeRange();
            LocalDate start = result.getStartDate();
            LocalDate end = result.getEndDate();
            Notification.show((String)String.format("From %s %s to: %s %s (exclusive)", start.getDayOfWeek(), start, end.getDayOfWeek(), end), (int)5000, (Notification.Position)Notification.Position.BOTTOM_CENTER);
        });
        this.dateButton.setEnabled(false);
        this.daysButton.addClickListener((ComponentEventListener & Serializable)ev -> {
            DateTimeRange result = pojo.getDateTimeRange();
            Notification.show((String)result.getWeekDays().toString(), (int)5000, (Notification.Position)Notification.Position.BOTTOM_CENTER);
        });
        this.daysButton.setEnabled(false);
        this.timeButton.addClickListener((ComponentEventListener & Serializable)ev -> {
            DateTimeRange result = pojo.getDateTimeRange();
            LocalTime start = result.getStartTime();
            LocalTime end = result.getEndTime();
            Notification.show((String)String.format("From %s to: %s (exclusive)", start, end), (int)5000, (Notification.Position)Notification.Position.BOTTOM_CENTER);
        });
        this.timeButton.setEnabled(false);
        Grid.Column firstCol = this.grid.addColumn((ValueProvider & Serializable)i -> i.getStartDate().getDayOfWeek()).setHeader("Week day").setSortable(true);
        this.grid.addColumn(TimeInterval::getStartDate).setHeader("Start").setSortable(true);
        this.grid.addColumn(TimeInterval::getEndDate).setHeader("End").setSortable(true);
        this.grid.addColumn((ValueProvider & Serializable)i -> BinderDemo.formatDuration(i.getDuration())).setHeader("Duration");
        this.dataView.addItemCountChangeListener((ComponentEventListener & Serializable)c -> firstCol.setFooter("Total: " + c.getItemCount()));
        this.grid.setWidth("75%");
        this.grid.addClassName("mx-auto");
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        buttonLayout.add(new Component[]{this.dateButton, this.daysButton, this.timeButton});
        this.add(new Component[]{field, buttonLayout, this.intervalButton, this.grid});
    }

    private static String formatDuration(Duration duration) {
        return String.format("%02d:%02d:%02d", duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart());
    }

    private static class Pojo {
        private DateTimeRange dateTimeRange;

        private Pojo() {
        }

        public DateTimeRange getDateTimeRange() {
            return this.dateTimeRange;
        }

        public void setDateTimeRange(DateTimeRange dateTimeRange) {
            this.dateTimeRange = dateTimeRange;
        }
    }
}

