/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.orgchart.extra;

public class TemplateLiteralRewriter {
    public static String rewriteFunction(String s) {
        return "return " + TemplateLiteralRewriter.rewrite(s) + ";";
    }

    public static String rewrite(String s) {
        StringBuilder sb = new StringBuilder();
        sb.ensureCapacity(s.length() + 1);
        TemplateLiteralRewriter.rewriteTemplate(s, 0, sb, true);
        return sb.toString();
    }

    private static int rewriteTemplate(String s, int i, StringBuilder sb, boolean implicit) {
        int begin = i;
        sb.append('\"');
        block10: while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append('\\').append('\"');
                    break;
                }
                case '\r': {
                    if (i < s.length() - 1 && s.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    break;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    break;
                }
                case '\\': {
                    if (++i == s.length()) {
                        throw new IllegalArgumentException("Unterminated escape sequence at index " + i);
                    }
                    c = s.charAt(i);
                    if (c == '\r' || c == '\n' || c == '\u2028' || c == '\u2029') {
                        if (i >= s.length() - 1 || s.charAt(i + 1) != '\n') break;
                        ++i;
                        break;
                    }
                    sb.append('\\').append(c);
                    break;
                }
                case '$': {
                    if (i == s.length() - 1 || s.charAt(i + 1) != '{') {
                        sb.append(c);
                        break;
                    }
                    sb.append("\"+(");
                    i = TemplateLiteralRewriter.rewriteExpression(s, i + 2, sb);
                    sb.append(")+\"");
                    break;
                }
                case '`': {
                    if (!implicit) break block10;
                    throw new IllegalArgumentException("Unexpected backtick at index " + i);
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        if (!implicit && i >= s.length()) {
            throw new IllegalArgumentException("Unterminated template at index " + begin);
        }
        sb.append('\"');
        return i;
    }

    private static int rewriteExpression(String s, int i, StringBuilder sb) {
        int begin = i;
        if (begin == s.length()) {
            throw new IllegalArgumentException("Expected expression at index " + begin);
        }
        if (s.charAt(begin) == '}') {
            throw new IllegalArgumentException("Unexpected token } at index " + begin);
        }
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '}': {
                    return i;
                }
                case '`': {
                    sb.append("(");
                    i = TemplateLiteralRewriter.rewriteTemplate(s, i + 1, sb, false);
                    sb.append(")");
                    break;
                }
                case '\"': 
                case '\'': {
                    int end = s.indexOf(c, i + 1);
                    if (end < 0) {
                        throw new IllegalArgumentException("Unterminated string literal at index " + i);
                    }
                    sb.append(s.substring(i, end)).append(c);
                    i = end;
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        throw new IllegalArgumentException("Expected TemplateSubstitutionTail at index " + begin);
    }
}

