/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.orgchart;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flowingcode.vaadin.addons.orgchart.OrgChartItem;
import com.flowingcode.vaadin.addons.orgchart.client.OrgChartState;
import com.flowingcode.vaadin.addons.orgchart.event.ChildrenAddedEvent;
import com.flowingcode.vaadin.addons.orgchart.event.NodeUpdatedEvent;
import com.flowingcode.vaadin.addons.orgchart.event.NodesRemovedEvent;
import com.flowingcode.vaadin.addons.orgchart.event.ParentAddedEvent;
import com.flowingcode.vaadin.addons.orgchart.event.SiblingsAddedEvent;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@NpmPackage.Container(value={@NpmPackage(value="orgchart", version="3.7.0"), @NpmPackage(value="html2canvas", version="1.4.1"), @NpmPackage(value="jquery", version="3.6.2"), @NpmPackage(value="json-digger", version="2.0.2")})
@JsModule.Container(value={@JsModule(value="jquery/dist/jquery.js"), @JsModule(value="orgchart/dist/js/jquery.orgchart.js"), @JsModule(value="./fc-orgchart.js")})
@CssImport.Container(value={@CssImport(value="orgchart/dist/css/jquery.orgchart.min.css"), @CssImport(value="./fc-orgchart-styles.css")})
@Tag(value="fc-orgchart")
public class OrgChart
extends Div {
    private OrgChartItem orgChartItem;
    private OrgChartState state = new OrgChartState();

    public OrgChart(OrgChartItem orgChartItem) {
        this.orgChartItem = orgChartItem;
        this.setValue(orgChartItem);
        String identifier = "orgchart" + ((Object)((Object)this)).hashCode();
        this.setId(identifier);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().executeJs("this.initializeOrgChart($0,$1,$2)", new Serializable[]{this.convertToJsonObj(this.state), this.state.value, (Serializable)this.getId().get()});
    }

    @Deprecated
    public void initializeChart() {
    }

    public void setValue(OrgChartItem orgChartItem) {
        String value;
        this.getState().value = value = this.convertToJsonObj(orgChartItem);
    }

    protected OrgChartState getState() {
        return this.state;
    }

    private String convertToJsonObj(Object orgChartItem) {
        String result = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            result = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(orgChartItem);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setChartNodeTitle(String chartNodeTitle) {
        this.getState().chartNodeTitle = chartNodeTitle;
    }

    public void setChartNodeContent(String chartNodeContent) {
        this.getState().chartNodeContent = chartNodeContent;
    }

    public void setChartDirection(String chartDirection) {
        this.getState().chartDirection = chartDirection;
    }

    public void setChartTitle(String chartTitle) {
        this.getState().chartTitle = chartTitle;
    }

    public void setChartZoom(Boolean chartZoom) {
        this.getState().chartZoom = chartZoom;
    }

    public void setChartExportButton(Boolean chartExportButton) {
        this.getState().chartExportButton = chartExportButton;
    }

    public void setChartExportFileName(String chartExportFileName) {
        this.getState().chartExportFileName = chartExportFileName;
    }

    public void setChartExportFileExtension(String chartExportFileExtension) {
        this.getState().chartExportFileExtension = chartExportFileExtension;
    }

    public void setChartPan(Boolean chartPan) {
        this.getState().chartPan = chartPan;
    }

    public void setChartZoominLimit(Double chartZoominLimit) {
        this.getState().chartZoominLimit = chartZoominLimit;
    }

    public void setChartZoomoutLimit(Double chartZoomoutLimit) {
        this.getState().chartZoomoutLimit = chartZoomoutLimit;
    }

    public void setChartDepth(Integer chartDepth) {
        this.getState().chartDepth = chartDepth;
    }

    public void setChartVerticalDepth(Integer chartVerticalDepth) {
        this.getState().chartVerticalDepth = chartVerticalDepth;
    }

    public void setChartToggleSiblingsResp(Boolean chartToggleSiblingsResp) {
        this.getState().chartToggleSiblingsResp = chartToggleSiblingsResp;
    }

    public void setChartExpandCollapse(Boolean chartExpandCollapse) {
        this.getState().chartExpandCollapse = chartExpandCollapse;
    }

    public void setChartDraggable(Boolean chartDraggable) {
        this.getState().chartDraggable = chartDraggable;
    }

    public OrgChartItem getOrgChartItem() {
        return this.orgChartItem;
    }

    @ClientCallable
    public void onClick(String nodeId) {
        Integer clickedNodeId = Integer.valueOf(nodeId);
        OrgChartItem clickedItem = this.getById(clickedNodeId, this.orgChartItem);
        this.fireNodeClickEvent(clickedItem, true);
    }

    @ClientCallable
    public void updateDraggedNode(String draggedNode, String dragZone, String dropZone) {
        Integer draggedNodeId = Integer.valueOf(draggedNode);
        OrgChartItem draggedItem = this.getById(draggedNodeId, this.orgChartItem);
        OrgChartItem oldParentItem = this.getById(Integer.valueOf(dragZone), this.orgChartItem);
        OrgChartItem newParentItem = this.getById(Integer.valueOf(dropZone), this.orgChartItem);
        List<OrgChartItem> oldParentUpdated = oldParentItem.getChildren().stream().filter(i -> !draggedNodeId.equals(i.getId())).collect(Collectors.toList());
        oldParentItem.setChildren(oldParentUpdated);
        newParentItem.addChildren(draggedItem);
        this.fireDragAndDropEvent(draggedItem, true);
    }

    private OrgChartItem getById(Integer id, OrgChartItem item) {
        if (id.equals(item.getId())) {
            return item;
        }
        return this.getChildItemById(id, item.getChildren());
    }

    private OrgChartItem getChildItemById(Integer id, List<OrgChartItem> children) {
        OrgChartItem result = null;
        for (int i = 0; i < children.size() && result == null; ++i) {
            result = this.getById(id, children.get(i));
        }
        return result;
    }

    public void setNodeTemplate(String parameterName, String functionBody) {
        this.getState().nodeTemplateParam = parameterName;
        this.getState().nodeTemplate = functionBody;
    }

    public void addDragAndDropListener(ComponentEventListener<DragAndDropEvent> listener) {
        this.addListener(DragAndDropEvent.class, listener);
    }

    protected void fireDragAndDropEvent(OrgChartItem draggedItem, boolean fromClient) {
        this.fireEvent(new DragAndDropEvent(this, draggedItem, fromClient));
    }

    public Registration addOnNodeClickListener(ComponentEventListener<NodeClickEvent> listener) {
        return this.addListener(NodeClickEvent.class, listener);
    }

    protected void fireNodeClickEvent(OrgChartItem clickedItem, boolean fromClient) {
        this.fireEvent(new NodeClickEvent(this, clickedItem, fromClient));
    }

    public void setCollapsedNodes() {
        this.setChartDepth(1);
    }

    private OrgChartItem findParent(Integer childId, OrgChartItem root) {
        if (root.getChildren() != null) {
            for (OrgChartItem child : root.getChildren()) {
                if (childId.equals(child.getId())) {
                    return root;
                }
                OrgChartItem parent = this.findParent(childId, child);
                if (parent == null) continue;
                return parent;
            }
        }
        return null;
    }

    private List<Integer> convertJsonArrayToIntegerList(JsonArray jsonIds) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (int i = 0; i < jsonIds.length(); ++i) {
            idList.add((int)jsonIds.getNumber(i));
        }
        return idList;
    }

    private void appendItemsToParent(OrgChartItem parentNode, List<OrgChartItem> itemsToAdd) {
        if (parentNode != null) {
            List<OrgChartItem> currentChildren = parentNode.getChildren();
            if (currentChildren == null) {
                currentChildren = new ArrayList<OrgChartItem>();
            }
            currentChildren.addAll(itemsToAdd);
            parentNode.setChildren(currentChildren);
        }
    }

    public void addSiblings(Integer nodeId, List<OrgChartItem> siblings) {
        if (nodeId.equals(this.orgChartItem.getId())) {
            throw new IllegalArgumentException("Cannot add siblings to the root node.");
        }
        OrgChartItem targetNode = this.getById(nodeId, this.orgChartItem);
        if (targetNode != null) {
            OrgChartItem parentNode = this.findParent(nodeId, this.orgChartItem);
            if (parentNode != null) {
                this.appendItemsToParent(parentNode, siblings);
            }
        } else {
            throw new IllegalArgumentException("Node not found: " + nodeId);
        }
        String siblingsJson = this.convertToJsonObj(siblings);
        this.getElement().executeJs("this.addSiblings($0, $1)", new Serializable[]{nodeId, siblingsJson});
    }

    @ClientCallable
    private void onSiblingsAdded(String nodeId, JsonArray siblingIds) {
        OrgChartItem targetItem = this.getById(Integer.valueOf(nodeId), this.orgChartItem);
        if (targetItem != null) {
            List<Integer> newSiblingIdList = this.convertJsonArrayToIntegerList(siblingIds);
            List<OrgChartItem> newSiblingItems = newSiblingIdList.stream().map(id -> this.getById((Integer)id, this.orgChartItem)).filter(Objects::nonNull).collect(Collectors.toList());
            this.fireSiblingsAddedEvent(targetItem, newSiblingItems, true);
        }
    }

    public Registration addSiblingsAddedListener(ComponentEventListener<SiblingsAddedEvent> listener) {
        return this.addListener(SiblingsAddedEvent.class, listener);
    }

    protected void fireSiblingsAddedEvent(OrgChartItem item, List<OrgChartItem> newSiblings, boolean fromClient) {
        this.fireEvent(new SiblingsAddedEvent(this, item, newSiblings, fromClient));
    }

    public void addChildren(Integer nodeId, List<OrgChartItem> children) {
        OrgChartItem targetNode = this.getById(nodeId, this.orgChartItem);
        if (targetNode == null) {
            throw new IllegalArgumentException("Node not found: " + nodeId);
        }
        boolean currentChildrenEmpty = targetNode.getChildren() == null || targetNode.getChildren().isEmpty();
        this.appendItemsToParent(targetNode, children);
        String itemsJson = this.convertToJsonObj(children);
        if (currentChildrenEmpty) {
            this.getElement().executeJs("this.addChildren($0, $1)", new Serializable[]{nodeId, itemsJson});
        } else {
            this.getElement().executeJs("this.addSiblings($0, $1)", new Serializable[]{targetNode.getChildren().get(0).getId(), itemsJson});
        }
    }

    @ClientCallable
    private void onChildrenAdded(String nodeId, JsonArray childIds) {
        OrgChartItem parentItem = this.getById(Integer.valueOf(nodeId), this.orgChartItem);
        if (parentItem != null) {
            List<Integer> newChildIdList = this.convertJsonArrayToIntegerList(childIds);
            List<OrgChartItem> newChildItems = newChildIdList.stream().map(id -> this.getById((Integer)id, this.orgChartItem)).filter(Objects::nonNull).collect(Collectors.toList());
            this.fireChildrenAddedEvent(parentItem, newChildItems, true);
        }
    }

    public Registration addChildrenAddedListener(ComponentEventListener<ChildrenAddedEvent> listener) {
        return this.addListener(ChildrenAddedEvent.class, listener);
    }

    protected void fireChildrenAddedEvent(OrgChartItem item, List<OrgChartItem> newChildren, boolean fromClient) {
        this.fireEvent(new ChildrenAddedEvent(this, item, newChildren, fromClient));
    }

    public void removeNodes(Integer nodeId) {
        OrgChartItem nodeToRemove = this.getById(nodeId, this.orgChartItem);
        if (nodeToRemove != null) {
            nodeToRemove.setChildren(Collections.emptyList());
            OrgChartItem parentNode = this.findParent(nodeId, this.orgChartItem);
            if (parentNode != null) {
                List<OrgChartItem> currentChildren = parentNode.getChildren();
                currentChildren.removeIf(child -> nodeId.equals(child.getId()));
                parentNode.setChildren(currentChildren);
            }
            if (this.orgChartItem != null && nodeId.equals(this.orgChartItem.getId())) {
                this.orgChartItem = null;
            }
        } else {
            throw new IllegalArgumentException("Node not found: " + nodeId);
        }
        this.getElement().executeJs("this.removeNodes($0)", new Serializable[]{nodeId});
    }

    @ClientCallable
    private void onNodesRemoved(String nodeId) {
        this.fireNodesRemovedEvent(Integer.valueOf(nodeId), true);
    }

    public Registration addNodesRemovedListener(ComponentEventListener<NodesRemovedEvent> listener) {
        return this.addListener(NodesRemovedEvent.class, listener);
    }

    protected void fireNodesRemovedEvent(Integer nodeId, boolean fromClient) {
        this.fireEvent(new NodesRemovedEvent(this, nodeId, fromClient));
    }

    public void addParent(OrgChartItem newParentItem) {
        if (this.orgChartItem != null) {
            newParentItem.setChildren(Collections.singletonList(this.orgChartItem));
        }
        this.orgChartItem = newParentItem;
        String parentJson = this.convertToJsonObj(newParentItem);
        this.getElement().executeJs("this.addParent($0)", new Serializable[]{parentJson});
    }

    @ClientCallable
    private void onParentAdded(String newParentId) {
        OrgChartItem newParentItem = this.getById(Integer.valueOf(newParentId), this.orgChartItem);
        if (newParentItem != null) {
            this.fireParentAddedEvent(newParentItem, true);
        }
    }

    public Registration addParentAddedListener(ComponentEventListener<ParentAddedEvent> listener) {
        return this.addListener(ParentAddedEvent.class, listener);
    }

    protected void fireParentAddedEvent(OrgChartItem newParent, boolean fromClient) {
        this.fireEvent(new ParentAddedEvent(this, newParent, fromClient));
    }

    public void updateNode(Integer nodeId, OrgChartItem newDataItem) {
        OrgChartItem nodeToUpdate = this.getById(nodeId, this.orgChartItem);
        if (nodeToUpdate != null) {
            if (newDataItem.getName() != null) {
                nodeToUpdate.setName(newDataItem.getName());
            }
            if (newDataItem.getTitle() != null) {
                nodeToUpdate.setTitle(newDataItem.getTitle());
            }
            if (newDataItem.getClassName() != null) {
                nodeToUpdate.setClassName(newDataItem.getClassName());
            }
            if (nodeToUpdate.isHybrid() != newDataItem.isHybrid()) {
                nodeToUpdate.setHybrid(newDataItem.isHybrid());
            }
            if (newDataItem.getData() != null) {
                newDataItem.getData().forEach(nodeToUpdate::setData);
            }
        } else {
            throw new IllegalArgumentException("Node not found: " + nodeId);
        }
        String newDataJson = this.convertToJsonObj(newDataItem);
        this.getElement().executeJs("this.updateNode($0, $1)", new Serializable[]{nodeId, newDataJson});
    }

    @ClientCallable
    private void onNodeUpdated(String nodeId) {
        OrgChartItem updatedItem = this.getById(Integer.valueOf(nodeId), this.orgChartItem);
        if (updatedItem != null) {
            this.fireNodeUpdatedEvent(updatedItem, true);
        }
    }

    public Registration addNodeUpdatedListener(ComponentEventListener<NodeUpdatedEvent> listener) {
        return this.addListener(NodeUpdatedEvent.class, listener);
    }

    protected void fireNodeUpdatedEvent(OrgChartItem item, boolean fromClient) {
        this.fireEvent(new NodeUpdatedEvent(this, item, fromClient));
    }

    public static class DragAndDropEvent
    extends ComponentEvent<OrgChart> {
        private final OrgChartItem draggedItem;

        public DragAndDropEvent(OrgChart source, OrgChartItem draggedItem, boolean fromClient) {
            super((Component)source, fromClient);
            this.draggedItem = draggedItem;
        }

        public OrgChartItem getDraggedItem() {
            return this.draggedItem;
        }

        public OrgChart getOrgChart() {
            return (OrgChart)((Object)this.source);
        }
    }

    public static class NodeClickEvent
    extends ComponentEvent<OrgChart> {
        private final OrgChartItem clickedItem;

        public NodeClickEvent(OrgChart source, OrgChartItem clickedItem, boolean fromClient) {
            super((Component)source, fromClient);
            this.clickedItem = clickedItem;
        }

        public OrgChartItem getClickedItem() {
            return this.clickedItem;
        }

        public OrgChart getOrgChart() {
            return (OrgChart)((Object)this.source);
        }
    }
}

