/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.orgchart;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.orgchart.OrgChart;
import com.flowingcode.vaadin.addons.orgchart.OrgChartItem;
import com.flowingcode.vaadin.addons.orgchart.OrgchartDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@PageTitle(value="Edit Chart")
@DemoSource
@Route(value="orgchart/edit-chart", layout=OrgchartDemoView.class)
@CssImport(value="./styles/orgchart/edit-chart-demo-styles.css")
public class EditChartDemo
extends VerticalLayout {
    private static final AtomicInteger idCounter = new AtomicInteger(100);
    private OrgChart orgChart;
    private OrgChartItem selectedNode;
    private TextField selectedNodeNameField;
    private VerticalLayout newNodeFieldsLayout;
    private HorizontalLayout newNodeButtonsLayout;
    private RadioButtonGroup<String> typeSelector;
    private Button addButton;
    private Button deleteButton;
    private Button updateButton;
    private Button resetButton;
    private HorizontalLayout newNodeActionsColumn;
    private RadioButtonGroup<String> actionSelector;

    public EditChartDemo() {
        this.setSizeFull();
        this.initChart();
        this.add(new Component[]{this.orgChart, this.getEditionLayout()});
    }

    private void initChart() {
        this.orgChart = this.getChart();
        this.orgChart.addClassNames(new String[]{"chart-container", "editable-chart"});
        this.orgChart.setChartTitle("EDIT CHART - Add Children, Add Siblings, Add Parent, Remove Nodes, Edit Selected Node");
        this.orgChart.setChartNodeContent("title");
        this.orgChart.addOnNodeClickListener((ComponentEventListener & Serializable)e -> {
            this.selectedNode = e.getClickedItem();
            this.selectedNodeNameField.setValue(this.selectedNode.getName());
            this.updateComponentStates();
        });
        this.orgChart.addSiblingsAddedListener((ComponentEventListener & Serializable)e -> {
            OrgChartItem targetNode = e.getItem();
            List newSiblings = e.getNewSiblings();
            if (!newSiblings.isEmpty()) {
                String siblingNames = newSiblings.stream().map(OrgChartItem::getName).collect(Collectors.joining(", "));
                String message = String.format("New siblings \"%s\" added to %s", siblingNames, targetNode.getName());
                Notification.show((String)message);
                System.out.println("------ OrgChart updated: ------\n" + ((OrgChart)e.getSource()).getOrgChartItem().toString());
            }
        });
        this.orgChart.addChildrenAddedListener((ComponentEventListener & Serializable)e -> {
            OrgChartItem targetNode = e.getItem();
            List newChildren = e.getNewChildren();
            String childrenNames = newChildren.stream().map(OrgChartItem::getName).collect(Collectors.joining(", "));
            String message = String.format("New children \"%s\" added to %s", childrenNames, targetNode.getName());
            Notification.show((String)message);
            System.out.println("------ OrgChart updated: ------\n" + ((OrgChart)e.getSource()).getOrgChartItem().toString());
        });
        this.orgChart.addNodesRemovedListener((ComponentEventListener & Serializable)e -> {
            String message = String.format("Item with id %s (and its descedant nodes) removed from chart", e.getNodeId());
            Notification.show((String)message);
            System.out.println("------ OrgChart updated: ------\n" + ((OrgChart)e.getSource()).getOrgChartItem().toString());
        });
        this.orgChart.addParentAddedListener((ComponentEventListener & Serializable)e -> {
            String message = String.format("New parent \"%s\" added to chart", e.getNewParent().getName());
            Notification.show((String)message);
            System.out.println("------ OrgChart updated: ------\n" + ((OrgChart)e.getSource()).getOrgChartItem().toString());
        });
        this.orgChart.addNodeUpdatedListener((ComponentEventListener & Serializable)e -> {
            String message = String.format("Node \"%s\" was updated.", e.getUpdatedItem().getName());
            Notification.show((String)message);
            System.out.println("------ OrgChart updated: ------\n" + ((OrgChart)e.getSource()).getOrgChartItem().toString());
        });
    }

    private OrgChart getChart() {
        OrgChartItem item1 = new OrgChartItem(Integer.valueOf(1), "John Williams", "Director");
        OrgChartItem item2 = new OrgChartItem(Integer.valueOf(2), "Anna Thompson", "Administration");
        OrgChartItem item3 = new OrgChartItem(Integer.valueOf(3), "Timothy Jones", "Sub-Director");
        item1.setChildren(Arrays.asList(item2, item3));
        OrgChartItem item4 = new OrgChartItem(Integer.valueOf(4), "Louise Night", "Department 1");
        OrgChartItem item5 = new OrgChartItem(Integer.valueOf(5), "John Porter", "Department 2");
        item2.setChildren(Arrays.asList(item4, item5));
        OrgChartItem item6 = new OrgChartItem(Integer.valueOf(6), "Charles Thomas", "Department 3");
        item5.setChildren(Arrays.asList(item6));
        return new OrgChart(item1);
    }

    private VerticalLayout getEditionLayout() {
        VerticalLayout editionPanel = new VerticalLayout();
        editionPanel.addClassName("edition-panel");
        editionPanel.setSpacing(false);
        this.actionSelector = new RadioButtonGroup();
        this.actionSelector.setLabel("Select Action");
        this.actionSelector.setItems((Object[])new String[]{"Add", "Edit", "Delete"});
        this.actionSelector.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateComponentStates());
        Div separator = new Div();
        separator.addClassName("edition-panel-separator");
        separator.setWidthFull();
        HorizontalLayout mainControlsLayout = new HorizontalLayout();
        mainControlsLayout.setWidthFull();
        mainControlsLayout.addClassName("main-controls-layout");
        mainControlsLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        VerticalLayout selectedNodeColumn = this.createVerticalLayout();
        selectedNodeColumn.addClassName("selected-node-layout");
        selectedNodeColumn.setAlignItems(FlexComponent.Alignment.START);
        this.selectedNodeNameField = new TextField("Selected Node:");
        this.selectedNodeNameField.setPlaceholder("Node Name");
        this.selectedNodeNameField.setWidth("180px");
        this.selectedNodeNameField.setReadOnly(true);
        this.typeSelector = new RadioButtonGroup();
        this.typeSelector.setLabel("Select Relation Type:");
        this.typeSelector.setItems((Object[])new String[]{"Parent(root)", "Child", "Sibling"});
        this.typeSelector.setValue((Object)"Child");
        this.typeSelector.addThemeVariants(new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
        this.newNodeFieldsLayout = this.createVerticalLayout();
        this.newNodeFieldsLayout.addClassName("new-nodes-layout");
        this.addButton = new Button("Add Child to Selected Node");
        this.deleteButton = new Button("Delete Selected Node");
        this.updateButton = new Button("Edit Selected Node");
        this.resetButton = new Button("Reset Chart");
        this.typeSelector.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            switch ((String)event.getValue()) {
                case "Parent(root)": {
                    this.addButton.setText("Add Parent Node");
                    break;
                }
                case "Sibling": {
                    this.addButton.setText("Add Sibling to Selected Node");
                    break;
                }
                default: {
                    this.addButton.setText("Add Child to Selected Node");
                }
            }
            this.updateComponentStates();
        });
        selectedNodeColumn.add(new Component[]{this.selectedNodeNameField, this.typeSelector});
        TextField initialNodeField = this.createNewNodeTextField();
        initialNodeField.setLabel("Add New Node Name:");
        this.newNodeFieldsLayout.add(new Component[]{initialNodeField});
        Button addButtonSmall = this.createIconButton(VaadinIcon.PLUS);
        Button removeButtonSmall = this.createIconButton(VaadinIcon.MINUS);
        this.newNodeButtonsLayout = new HorizontalLayout(new Component[]{addButtonSmall, removeButtonSmall});
        this.newNodeButtonsLayout.addClassName("new-nodes-buttons-layout");
        this.newNodeButtonsLayout.setPadding(false);
        this.newNodeButtonsLayout.setSpacing(false);
        addButtonSmall.addClickListener((ComponentEventListener & Serializable)e -> this.newNodeFieldsLayout.add(new Component[]{this.createNewNodeTextField()}));
        removeButtonSmall.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.newNodeFieldsLayout.getComponentCount() > 1) {
                Component lastField = this.newNodeFieldsLayout.getComponentAt(this.newNodeFieldsLayout.getComponentCount() - 1);
                this.newNodeFieldsLayout.remove(new Component[]{lastField});
            }
        });
        this.newNodeActionsColumn = new HorizontalLayout(new Component[]{this.newNodeFieldsLayout, this.newNodeButtonsLayout});
        this.newNodeActionsColumn.setAlignItems(FlexComponent.Alignment.BASELINE);
        this.addButton.addClickListener((ComponentEventListener & Serializable)e -> this.onAddButtonClick());
        this.deleteButton.addClickListener((ComponentEventListener & Serializable)e -> this.onDeleteButtonClick());
        this.updateButton.addClickListener((ComponentEventListener & Serializable)e -> this.onUpdateButtonClick());
        this.resetButton.addClickListener((ComponentEventListener & Serializable)e -> this.onResetButtonClick());
        VerticalLayout actionButtonsColumn = this.createVerticalLayout();
        actionButtonsColumn.add(new Component[]{this.addButton, this.deleteButton, this.updateButton, this.resetButton});
        actionButtonsColumn.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        actionButtonsColumn.setAlignItems(FlexComponent.Alignment.END);
        mainControlsLayout.add(new Component[]{selectedNodeColumn, this.newNodeActionsColumn, actionButtonsColumn});
        editionPanel.add(new Component[]{this.actionSelector, separator, mainControlsLayout});
        this.updateComponentStates();
        return editionPanel;
    }

    private void updateComponentStates() {
        String action = (String)this.actionSelector.getValue();
        boolean isAdd = "Add".equals(action);
        boolean isEdit = "Edit".equals(action);
        boolean isDelete = "Delete".equals(action);
        boolean nodeIsSelected = this.selectedNode != null;
        String relation = (String)this.typeSelector.getValue();
        boolean isParentMode = "Parent(root)".equals(relation);
        if (isParentMode) {
            this.resetNewNodeFields();
        }
        this.typeSelector.setVisible(isAdd);
        this.newNodeActionsColumn.setVisible(isAdd);
        this.newNodeButtonsLayout.setVisible(isAdd && !isParentMode);
        this.selectedNodeNameField.setVisible(isEdit || isDelete || isAdd && !isParentMode);
        this.addButton.setEnabled(isAdd);
        this.updateButton.setEnabled(isEdit && nodeIsSelected);
        this.deleteButton.setEnabled(isDelete && nodeIsSelected);
    }

    private void onAddButtonClick() {
        String relationType;
        if (this.selectedNode == null && this.selectedNodeNameField.isVisible()) {
            Notification.show((String)"Please select a node first.");
            return;
        }
        List newNodeNames = this.newNodeFieldsLayout.getChildren().filter(component -> component instanceof TextField).map(component -> ((TextField)component).getValue()).filter(name -> name != null && !name.trim().isEmpty()).collect(Collectors.toList());
        if (newNodeNames.isEmpty()) {
            Notification.show((String)"Please enter a name for the new node(s).");
            return;
        }
        ArrayList<OrgChartItem> newItems = new ArrayList<OrgChartItem>();
        for (String name2 : newNodeNames) {
            int newId = idCounter.getAndIncrement();
            OrgChartItem newItem = new OrgChartItem(Integer.valueOf(newId), name2, "Undefined");
            newItems.add(newItem);
        }
        switch (relationType = (String)this.typeSelector.getValue()) {
            case "Child": {
                this.orgChart.addChildren(this.selectedNode.getId(), newItems);
                break;
            }
            case "Sibling": {
                try {
                    this.orgChart.addSiblings(this.selectedNode.getId(), newItems);
                }
                catch (IllegalArgumentException ex) {
                    Notification.show((String)ex.getMessage());
                }
                break;
            }
            case "Parent(root)": {
                this.orgChart.addParent((OrgChartItem)newItems.get(0));
            }
        }
        this.resetNewNodeFields();
        ((TextField)this.newNodeFieldsLayout.getComponentAt(0)).clear();
    }

    private void onDeleteButtonClick() {
        if (this.selectedNode == null) {
            Notification.show((String)"Please select a node to delete.");
            return;
        }
        Integer selectedNodeId = this.selectedNode.getId();
        boolean isRootNode = selectedNodeId.equals(this.orgChart.getOrgChartItem().getId());
        if (isRootNode) {
            ConfirmDialog dialog = new ConfirmDialog();
            dialog.setHeader("Delete Entire Chart?");
            dialog.setText("Are you sure you want to delete the root node? This action will remove the entire chart.");
            dialog.setConfirmText("Delete Chart");
            dialog.setConfirmButtonTheme("error primary");
            dialog.setCancelable(true);
            dialog.addConfirmListener((ComponentEventListener & Serializable)event -> {
                this.orgChart.removeNodes(selectedNodeId);
                this.clearSelectedNode();
                Notification.show((String)"Chart deleted.");
            });
            dialog.open();
        } else {
            this.orgChart.removeNodes(selectedNodeId);
            this.clearSelectedNode();
            Notification.show((String)"Node deleted.");
        }
    }

    private void onUpdateButtonClick() {
        if (this.selectedNode == null) {
            Notification.show((String)"Please select a node to update.");
            return;
        }
        ConfirmDialog dialog = new ConfirmDialog();
        dialog.setHeader("Edit Node Details");
        TextField nameField = new TextField("Name");
        nameField.setValue(this.selectedNode.getName());
        nameField.setWidthFull();
        TextField titleField = new TextField("Title");
        titleField.setValue(this.selectedNode.getTitle());
        titleField.setWidthFull();
        dialog.add(new Component[]{new VerticalLayout(new Component[]{nameField, titleField})});
        dialog.setConfirmText("Save");
        dialog.setConfirmButtonTheme("primary");
        dialog.setCancelable(true);
        dialog.addConfirmListener((ComponentEventListener & Serializable)event -> {
            OrgChartItem updatedData = new OrgChartItem(Integer.valueOf(0), nameField.getValue(), titleField.getValue());
            this.orgChart.updateNode(this.selectedNode.getId(), updatedData);
        });
        dialog.open();
    }

    private void onResetButtonClick() {
        OrgChart oldChart = this.orgChart;
        this.initChart();
        this.replace((Component)oldChart, (Component)this.orgChart);
        this.clearSelectedNode();
        this.actionSelector.setValue(null);
    }

    private void clearSelectedNode() {
        this.selectedNode = null;
        this.selectedNodeNameField.clear();
        this.updateComponentStates();
    }

    private Button createIconButton(VaadinIcon icon) {
        Button iconButton = new Button((Component)icon.create());
        iconButton.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_ICON, ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_TERTIARY_INLINE});
        return iconButton;
    }

    private TextField createNewNodeTextField() {
        TextField newNodeTextField = new TextField();
        newNodeTextField.setPlaceholder("Name");
        newNodeTextField.setWidth("150px");
        return newNodeTextField;
    }

    private VerticalLayout createVerticalLayout() {
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setWidth("auto");
        verticalLayout.setSpacing(false);
        verticalLayout.setPadding(false);
        return verticalLayout;
    }

    private void resetNewNodeFields() {
        while (this.newNodeFieldsLayout.getComponentCount() > 1) {
            this.newNodeFieldsLayout.remove(new Component[]{this.newNodeFieldsLayout.getComponentAt(1)});
        }
    }
}

