/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.orgchart;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flowingcode.vaadin.addons.orgchart.OrgChartItem;
import com.flowingcode.vaadin.addons.orgchart.client.OrgChartState;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@NpmPackage.Container(value={@NpmPackage(value="html2canvas", version="^0.5.0-beta4"), @NpmPackage(value="jquery", version="3.4.1")})
@JsModule.Container(value={@JsModule(value="jquery/dist/jquery.js"), @JsModule(value="./orgchart/dist/js/jquery.orgchart.js"), @JsModule(value="./fc-orgchart.js")})
@StyleSheet(value="context://frontend/jquery.orgchart.min.css")
@Tag(value="fc-orgchart")
public class OrgChart
extends Div {
    private OrgChartItem orgChartItem;
    private OrgChartState state = new OrgChartState();

    public OrgChart(OrgChartItem orgChartItem) {
        this.orgChartItem = orgChartItem;
        this.setValue(orgChartItem);
        String identifier = "orgchart" + ((Object)((Object)this)).hashCode();
        this.setId(identifier);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().executeJs("this.initializeOrgChart($0,$1,$2)", new Serializable[]{this.convertToJsonObj(this.state), this.state.value, (Serializable)this.getId().get()});
    }

    @Deprecated
    public void initializeChart() {
    }

    public void setValue(OrgChartItem orgChartItem) {
        String value;
        this.getState().value = value = this.convertToJsonObj(orgChartItem);
    }

    protected OrgChartState getState() {
        return this.state;
    }

    private String convertToJsonObj(Object orgChartItem) {
        String result = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            result = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(orgChartItem);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setChartNodeTitle(String chartNodeTitle) {
        this.getState().chartNodeTitle = chartNodeTitle;
    }

    public void setChartNodeContent(String chartNodeContent) {
        this.getState().chartNodeContent = chartNodeContent;
    }

    public void setChartDirection(String chartDirection) {
        this.getState().chartDirection = chartDirection;
    }

    public void setChartTitle(String chartTitle) {
        this.getState().chartTitle = chartTitle;
    }

    public void setChartZoom(Boolean chartZoom) {
        this.getState().chartZoom = chartZoom;
    }

    public void setChartExportButton(Boolean chartExportButton) {
        this.getState().chartExportButton = chartExportButton;
    }

    public void setChartExportFileName(String chartExportFileName) {
        this.getState().chartExportFileName = chartExportFileName;
    }

    public void setChartExportFileExtension(String chartExportFileExtension) {
        this.getState().chartExportFileExtension = chartExportFileExtension;
    }

    public void setChartPan(Boolean chartPan) {
        this.getState().chartPan = chartPan;
    }

    public void setChartZoominLimit(Double chartZoominLimit) {
        this.getState().chartZoominLimit = chartZoominLimit;
    }

    public void setChartZoomoutLimit(Double chartZoomoutLimit) {
        this.getState().chartZoomoutLimit = chartZoomoutLimit;
    }

    public void setChartDepth(Integer chartDepth) {
        this.getState().chartDepth = chartDepth;
    }

    public void setChartVerticalDepth(Integer chartVerticalDepth) {
        this.getState().chartVerticalDepth = chartVerticalDepth;
    }

    public void setChartToggleSiblingsResp(Boolean chartToggleSiblingsResp) {
        this.getState().chartToggleSiblingsResp = chartToggleSiblingsResp;
    }

    public void setChartExpandCollapse(Boolean chartExpandCollapse) {
        this.getState().chartExpandCollapse = chartExpandCollapse;
    }

    public void setChartDraggable(Boolean chartDraggable) {
        this.getState().chartDraggable = chartDraggable;
    }

    public OrgChartItem getOrgChartItem() {
        return this.orgChartItem;
    }

    @ClientCallable
    public void onClick(String nodeId) {
        Integer clickedNodeId = Integer.valueOf(nodeId);
        OrgChartItem clickedItem = this.getById(clickedNodeId, this.orgChartItem);
        this.fireNodeClickEvent(clickedItem, true);
    }

    @ClientCallable
    public void updateDraggedNode(String draggedNode, String dragZone, String dropZone) {
        Integer draggedNodeId = Integer.valueOf(draggedNode);
        OrgChartItem draggedItem = this.getById(draggedNodeId, this.orgChartItem);
        OrgChartItem oldParentItem = this.getById(Integer.valueOf(dragZone), this.orgChartItem);
        OrgChartItem newParentItem = this.getById(Integer.valueOf(dropZone), this.orgChartItem);
        List<OrgChartItem> oldParentUpdated = oldParentItem.getChildren().stream().filter(i -> !draggedNodeId.equals(i.getId())).collect(Collectors.toList());
        oldParentItem.setChildren(oldParentUpdated);
        newParentItem.addChildren(draggedItem);
        this.fireDragAndDropEvent(draggedItem, true);
    }

    private OrgChartItem getById(Integer id, OrgChartItem item) {
        if (id.equals(item.getId())) {
            return item;
        }
        return this.getChildItemById(id, item.getChildren());
    }

    private OrgChartItem getChildItemById(Integer id, List<OrgChartItem> children) {
        OrgChartItem result = null;
        for (int i = 0; i < children.size() && result == null; ++i) {
            result = this.getById(id, children.get(i));
        }
        return result;
    }

    public void setNodeTemplate(String parameterName, String functionBody) {
        this.getState().nodeTemplateParam = parameterName;
        this.getState().nodeTemplate = functionBody;
    }

    public void addDragAndDropListener(ComponentEventListener<DragAndDropEvent> listener) {
        this.addListener(DragAndDropEvent.class, listener);
    }

    protected void fireDragAndDropEvent(OrgChartItem draggedItem, boolean fromClient) {
        this.fireEvent(new DragAndDropEvent(this, draggedItem, fromClient));
    }

    public Registration addOnNodeClickListener(ComponentEventListener<NodeClickEvent> listener) {
        return this.addListener(NodeClickEvent.class, listener);
    }

    protected void fireNodeClickEvent(OrgChartItem clickedItem, boolean fromClient) {
        this.fireEvent(new NodeClickEvent(this, clickedItem, fromClient));
    }

    public void setCollapsedNodes() {
        this.setChartDepth(1);
    }

    public static class NodeClickEvent
    extends ComponentEvent<OrgChart> {
        private final OrgChartItem clickedItem;

        public NodeClickEvent(OrgChart source, OrgChartItem clickedItem, boolean fromClient) {
            super((Component)source, fromClient);
            this.clickedItem = clickedItem;
        }

        public OrgChartItem getClickedItem() {
            return this.clickedItem;
        }

        public OrgChart getOrgChart() {
            return (OrgChart)((Object)this.source);
        }
    }

    public static class DragAndDropEvent
    extends ComponentEvent<OrgChart> {
        private final OrgChartItem draggedItem;

        public DragAndDropEvent(OrgChart source, OrgChartItem draggedItem, boolean fromClient) {
            super((Component)source, fromClient);
            this.draggedItem = draggedItem;
        }

        public OrgChartItem getDraggedItem() {
            return this.draggedItem;
        }

        public OrgChart getOrgChart() {
            return (OrgChart)((Object)this.source);
        }
    }
}

