/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.orgchart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OrgChartItem
implements Serializable {
    private String name;
    private String title;
    private String className;
    private Integer id;
    private List<OrgChartItem> children = new ArrayList<OrgChartItem>();
    private Map<String, String> data;

    public OrgChartItem(Integer id, String name, String title) {
        this.id = id;
        this.name = name;
        this.title = title;
    }

    public OrgChartItem(OrgChartItem original) {
        OrgChartItem orgChartCopy = new OrgChartItem(original.getId(), original.getName(), original.getTitle());
        for (OrgChartItem child : original.getChildren()) {
            orgChartCopy.addChildren(new OrgChartItem(child));
        }
    }

    public Map<String, String> getData() {
        return Optional.ofNullable(this.data).map(Collections::unmodifiableMap).orElse(Collections.emptyMap());
    }

    public void setData(String name, String value) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        if (value != null) {
            this.data.put(name, value);
        } else {
            this.data.remove(name);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<OrgChartItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<OrgChartItem> children) {
        if (this.children != children) {
            this.children = new ArrayList<OrgChartItem>(children);
        }
    }

    public void addChildren(OrgChartItem item) {
        this.children.add(item);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrgChartItem other = (OrgChartItem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printChildren(this, sb, 0);
        return sb.toString();
    }

    private void printChildren(OrgChartItem item, StringBuilder sb, int count) {
        String tabs = count > 0 ? String.format("%-" + count + "s", "").replace(' ', '\t') : "";
        sb.append(tabs + item.getName() + "\n");
        ++count;
        for (int i = 0; i < item.getChildren().size(); ++i) {
            this.printChildren(item.getChildren().get(i), sb, count);
        }
    }
}

