/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.markdown;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.react.ReactAdapterComponent;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;

@CssImport(value="./styles/markdown-editor-styles.css")
@NpmPackage.Container(value={@NpmPackage(value="mermaid", version="11.2.1"), @NpmPackage(value="@uiw/react-md-editor", version="4.0.4"), @NpmPackage(value="dompurify", version="3.1.6")})
@JsModule(value="./fcMarkdownEditorConnector.js")
public class BaseMarkdownComponent
extends ReactAdapterComponent
implements HasSize {
    private String content;

    public BaseMarkdownComponent(String content) {
        this.setContent(content);
        this.addContentChangeListener((SerializableConsumer<String>)(SerializableConsumer & Serializable)c -> {
            this.content = c;
        });
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.setState("content", content);
    }

    public void addContentChangeListener(SerializableConsumer<String> listener) {
        this.addStateChangeListener("content", String.class, listener);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.fcMarkdownEditorConnector.observeThemeChange($0)", new Serializable[]{this.getElement()}));
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.getUI().ifPresent(ui -> ui.getPage().executeJs("window.Vaadin.Flow.fcMarkdownEditorConnector.unobserveThemeChange($0)", new Serializable[]{this.getElement()}));
    }
}

