/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.localecombobox;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class LocaleCountryConverter {
    private static final Map<String, String> conversions = new HashMap<String, String>();

    private static void add(String alpha2, String alpha3, int numeric) {
        conversions.put(alpha2, alpha2);
        conversions.put(alpha3, alpha2);
        conversions.put(Integer.toString(numeric), alpha2);
    }

    public static Optional<String> convertToISO3166Code(String countryCode) {
        return Optional.ofNullable(conversions.get(countryCode.toUpperCase()));
    }

    static {
        LocaleCountryConverter.add("AF", "AFG", 4);
        LocaleCountryConverter.add("AL", "ALB", 8);
        LocaleCountryConverter.add("DZ", "DZA", 12);
        LocaleCountryConverter.add("AS", "ASM", 16);
        LocaleCountryConverter.add("AD", "AND", 20);
        LocaleCountryConverter.add("AO", "AGO", 24);
        LocaleCountryConverter.add("AI", "AIA", 660);
        LocaleCountryConverter.add("AQ", "ATA", 10);
        LocaleCountryConverter.add("AG", "ATG", 28);
        LocaleCountryConverter.add("AR", "ARG", 32);
        LocaleCountryConverter.add("AM", "ARM", 51);
        LocaleCountryConverter.add("AW", "ABW", 533);
        LocaleCountryConverter.add("AU", "AUS", 36);
        LocaleCountryConverter.add("AT", "AUT", 40);
        LocaleCountryConverter.add("AZ", "AZE", 31);
        LocaleCountryConverter.add("BS", "BHS", 44);
        LocaleCountryConverter.add("BH", "BHR", 48);
        LocaleCountryConverter.add("BD", "BGD", 50);
        LocaleCountryConverter.add("BB", "BRB", 52);
        LocaleCountryConverter.add("BY", "BLR", 112);
        LocaleCountryConverter.add("BE", "BEL", 56);
        LocaleCountryConverter.add("BZ", "BLZ", 84);
        LocaleCountryConverter.add("BJ", "BEN", 204);
        LocaleCountryConverter.add("BM", "BMU", 60);
        LocaleCountryConverter.add("BT", "BTN", 64);
        LocaleCountryConverter.add("BO", "BOL", 68);
        LocaleCountryConverter.add("BQ", "BES", 535);
        LocaleCountryConverter.add("BA", "BIH", 70);
        LocaleCountryConverter.add("BW", "BWA", 72);
        LocaleCountryConverter.add("BV", "BVT", 74);
        LocaleCountryConverter.add("BR", "BRA", 76);
        LocaleCountryConverter.add("IO", "IOT", 86);
        LocaleCountryConverter.add("BN", "BRN", 96);
        LocaleCountryConverter.add("BG", "BGR", 100);
        LocaleCountryConverter.add("BF", "BFA", 854);
        LocaleCountryConverter.add("BI", "BDI", 108);
        LocaleCountryConverter.add("CV", "CPV", 132);
        LocaleCountryConverter.add("KH", "KHM", 116);
        LocaleCountryConverter.add("CM", "CMR", 120);
        LocaleCountryConverter.add("CA", "CAN", 124);
        LocaleCountryConverter.add("KY", "CYM", 136);
        LocaleCountryConverter.add("CF", "CAF", 140);
        LocaleCountryConverter.add("TD", "TCD", 148);
        LocaleCountryConverter.add("CL", "CHL", 152);
        LocaleCountryConverter.add("CN", "CHN", 156);
        LocaleCountryConverter.add("CX", "CXR", 162);
        LocaleCountryConverter.add("CC", "CCK", 166);
        LocaleCountryConverter.add("CO", "COL", 170);
        LocaleCountryConverter.add("KM", "COM", 174);
        LocaleCountryConverter.add("CD", "COD", 180);
        LocaleCountryConverter.add("CG", "COG", 178);
        LocaleCountryConverter.add("CK", "COK", 184);
        LocaleCountryConverter.add("CR", "CRI", 188);
        LocaleCountryConverter.add("HR", "HRV", 191);
        LocaleCountryConverter.add("CU", "CUB", 192);
        LocaleCountryConverter.add("CW", "CUW", 531);
        LocaleCountryConverter.add("CY", "CYP", 196);
        LocaleCountryConverter.add("CZ", "CZE", 203);
        LocaleCountryConverter.add("CI", "CIV", 384);
        LocaleCountryConverter.add("DK", "DNK", 208);
        LocaleCountryConverter.add("DJ", "DJI", 262);
        LocaleCountryConverter.add("DM", "DMA", 212);
        LocaleCountryConverter.add("DO", "DOM", 214);
        LocaleCountryConverter.add("EC", "ECU", 218);
        LocaleCountryConverter.add("EG", "EGY", 818);
        LocaleCountryConverter.add("SV", "SLV", 222);
        LocaleCountryConverter.add("GQ", "GNQ", 226);
        LocaleCountryConverter.add("ER", "ERI", 232);
        LocaleCountryConverter.add("EE", "EST", 233);
        LocaleCountryConverter.add("SZ", "SWZ", 748);
        LocaleCountryConverter.add("ET", "ETH", 231);
        LocaleCountryConverter.add("FK", "FLK", 238);
        LocaleCountryConverter.add("FO", "FRO", 234);
        LocaleCountryConverter.add("FJ", "FJI", 242);
        LocaleCountryConverter.add("FI", "FIN", 246);
        LocaleCountryConverter.add("FR", "FRA", 250);
        LocaleCountryConverter.add("GF", "GUF", 254);
        LocaleCountryConverter.add("PF", "PYF", 258);
        LocaleCountryConverter.add("TF", "ATF", 260);
        LocaleCountryConverter.add("GA", "GAB", 266);
        LocaleCountryConverter.add("GM", "GMB", 270);
        LocaleCountryConverter.add("GE", "GEO", 268);
        LocaleCountryConverter.add("DE", "DEU", 276);
        LocaleCountryConverter.add("GH", "GHA", 288);
        LocaleCountryConverter.add("GI", "GIB", 292);
        LocaleCountryConverter.add("GR", "GRC", 300);
        LocaleCountryConverter.add("GL", "GRL", 304);
        LocaleCountryConverter.add("GD", "GRD", 308);
        LocaleCountryConverter.add("GP", "GLP", 312);
        LocaleCountryConverter.add("GU", "GUM", 316);
        LocaleCountryConverter.add("GT", "GTM", 320);
        LocaleCountryConverter.add("GG", "GGY", 831);
        LocaleCountryConverter.add("GN", "GIN", 324);
        LocaleCountryConverter.add("GW", "GNB", 624);
        LocaleCountryConverter.add("GY", "GUY", 328);
        LocaleCountryConverter.add("HT", "HTI", 332);
        LocaleCountryConverter.add("HM", "HMD", 334);
        LocaleCountryConverter.add("VA", "VAT", 336);
        LocaleCountryConverter.add("HN", "HND", 340);
        LocaleCountryConverter.add("HK", "HKG", 344);
        LocaleCountryConverter.add("HU", "HUN", 348);
        LocaleCountryConverter.add("IS", "ISL", 352);
        LocaleCountryConverter.add("IN", "IND", 356);
        LocaleCountryConverter.add("ID", "IDN", 360);
        LocaleCountryConverter.add("IR", "IRN", 364);
        LocaleCountryConverter.add("IQ", "IRQ", 368);
        LocaleCountryConverter.add("IE", "IRL", 372);
        LocaleCountryConverter.add("IM", "IMN", 833);
        LocaleCountryConverter.add("IL", "ISR", 376);
        LocaleCountryConverter.add("IT", "ITA", 380);
        LocaleCountryConverter.add("JM", "JAM", 388);
        LocaleCountryConverter.add("JP", "JPN", 392);
        LocaleCountryConverter.add("JE", "JEY", 832);
        LocaleCountryConverter.add("JO", "JOR", 400);
        LocaleCountryConverter.add("KZ", "KAZ", 398);
        LocaleCountryConverter.add("KE", "KEN", 404);
        LocaleCountryConverter.add("KI", "KIR", 296);
        LocaleCountryConverter.add("KP", "PRK", 408);
        LocaleCountryConverter.add("KR", "KOR", 410);
        LocaleCountryConverter.add("KW", "KWT", 414);
        LocaleCountryConverter.add("KG", "KGZ", 417);
        LocaleCountryConverter.add("LA", "LAO", 418);
        LocaleCountryConverter.add("LV", "LVA", 428);
        LocaleCountryConverter.add("LB", "LBN", 422);
        LocaleCountryConverter.add("LS", "LSO", 426);
        LocaleCountryConverter.add("LR", "LBR", 430);
        LocaleCountryConverter.add("LY", "LBY", 434);
        LocaleCountryConverter.add("LI", "LIE", 438);
        LocaleCountryConverter.add("LT", "LTU", 440);
        LocaleCountryConverter.add("LU", "LUX", 442);
        LocaleCountryConverter.add("MO", "MAC", 446);
        LocaleCountryConverter.add("MG", "MDG", 450);
        LocaleCountryConverter.add("MW", "MWI", 454);
        LocaleCountryConverter.add("MY", "MYS", 458);
        LocaleCountryConverter.add("MV", "MDV", 462);
        LocaleCountryConverter.add("ML", "MLI", 466);
        LocaleCountryConverter.add("MT", "MLT", 470);
        LocaleCountryConverter.add("MH", "MHL", 584);
        LocaleCountryConverter.add("MQ", "MTQ", 474);
        LocaleCountryConverter.add("MR", "MRT", 478);
        LocaleCountryConverter.add("MU", "MUS", 480);
        LocaleCountryConverter.add("YT", "MYT", 175);
        LocaleCountryConverter.add("MX", "MEX", 484);
        LocaleCountryConverter.add("FM", "FSM", 583);
        LocaleCountryConverter.add("MD", "MDA", 498);
        LocaleCountryConverter.add("MC", "MCO", 492);
        LocaleCountryConverter.add("MN", "MNG", 496);
        LocaleCountryConverter.add("ME", "MNE", 499);
        LocaleCountryConverter.add("MS", "MSR", 500);
        LocaleCountryConverter.add("MA", "MAR", 504);
        LocaleCountryConverter.add("MZ", "MOZ", 508);
        LocaleCountryConverter.add("MM", "MMR", 104);
        LocaleCountryConverter.add("NA", "NAM", 516);
        LocaleCountryConverter.add("NR", "NRU", 520);
        LocaleCountryConverter.add("NP", "NPL", 524);
        LocaleCountryConverter.add("NL", "NLD", 528);
        LocaleCountryConverter.add("NC", "NCL", 540);
        LocaleCountryConverter.add("NZ", "NZL", 554);
        LocaleCountryConverter.add("NI", "NIC", 558);
        LocaleCountryConverter.add("NE", "NER", 562);
        LocaleCountryConverter.add("NG", "NGA", 566);
        LocaleCountryConverter.add("NU", "NIU", 570);
        LocaleCountryConverter.add("NF", "NFK", 574);
        LocaleCountryConverter.add("MK", "MKD", 807);
        LocaleCountryConverter.add("MP", "MNP", 580);
        LocaleCountryConverter.add("NO", "NOR", 578);
        LocaleCountryConverter.add("OM", "OMN", 512);
        LocaleCountryConverter.add("PK", "PAK", 586);
        LocaleCountryConverter.add("PW", "PLW", 585);
        LocaleCountryConverter.add("PS", "PSE", 275);
        LocaleCountryConverter.add("PA", "PAN", 591);
        LocaleCountryConverter.add("PG", "PNG", 598);
        LocaleCountryConverter.add("PY", "PRY", 600);
        LocaleCountryConverter.add("PE", "PER", 604);
        LocaleCountryConverter.add("PH", "PHL", 608);
        LocaleCountryConverter.add("PN", "PCN", 612);
        LocaleCountryConverter.add("PL", "POL", 616);
        LocaleCountryConverter.add("PT", "PRT", 620);
        LocaleCountryConverter.add("PR", "PRI", 630);
        LocaleCountryConverter.add("QA", "QAT", 634);
        LocaleCountryConverter.add("RO", "ROU", 642);
        LocaleCountryConverter.add("RU", "RUS", 643);
        LocaleCountryConverter.add("RW", "RWA", 646);
        LocaleCountryConverter.add("RE", "REU", 638);
        LocaleCountryConverter.add("BL", "BLM", 652);
        LocaleCountryConverter.add("SH", "SHN", 654);
        LocaleCountryConverter.add("KN", "KNA", 659);
        LocaleCountryConverter.add("LC", "LCA", 662);
        LocaleCountryConverter.add("MF", "MAF", 663);
        LocaleCountryConverter.add("PM", "SPM", 666);
        LocaleCountryConverter.add("VC", "VCT", 670);
        LocaleCountryConverter.add("WS", "WSM", 882);
        LocaleCountryConverter.add("SM", "SMR", 674);
        LocaleCountryConverter.add("ST", "STP", 678);
        LocaleCountryConverter.add("SA", "SAU", 682);
        LocaleCountryConverter.add("SN", "SEN", 686);
        LocaleCountryConverter.add("RS", "SRB", 688);
        LocaleCountryConverter.add("SC", "SYC", 690);
        LocaleCountryConverter.add("SL", "SLE", 694);
        LocaleCountryConverter.add("SG", "SGP", 702);
        LocaleCountryConverter.add("SX", "SXM", 534);
        LocaleCountryConverter.add("SK", "SVK", 703);
        LocaleCountryConverter.add("SI", "SVN", 705);
        LocaleCountryConverter.add("SB", "SLB", 90);
        LocaleCountryConverter.add("SO", "SOM", 706);
        LocaleCountryConverter.add("ZA", "ZAF", 710);
        LocaleCountryConverter.add("GS", "SGS", 239);
        LocaleCountryConverter.add("SS", "SSD", 728);
        LocaleCountryConverter.add("ES", "ESP", 724);
        LocaleCountryConverter.add("LK", "LKA", 144);
        LocaleCountryConverter.add("SD", "SDN", 729);
        LocaleCountryConverter.add("SR", "SUR", 740);
        LocaleCountryConverter.add("SJ", "SJM", 744);
        LocaleCountryConverter.add("SE", "SWE", 752);
        LocaleCountryConverter.add("CH", "CHE", 756);
        LocaleCountryConverter.add("SY", "SYR", 760);
        LocaleCountryConverter.add("TW", "TWN", 158);
        LocaleCountryConverter.add("TJ", "TJK", 762);
        LocaleCountryConverter.add("TZ", "TZA", 834);
        LocaleCountryConverter.add("TH", "THA", 764);
        LocaleCountryConverter.add("TL", "TLS", 626);
        LocaleCountryConverter.add("TG", "TGO", 768);
        LocaleCountryConverter.add("TK", "TKL", 772);
        LocaleCountryConverter.add("TO", "TON", 776);
        LocaleCountryConverter.add("TT", "TTO", 780);
        LocaleCountryConverter.add("TN", "TUN", 788);
        LocaleCountryConverter.add("TM", "TKM", 795);
        LocaleCountryConverter.add("TC", "TCA", 796);
        LocaleCountryConverter.add("TV", "TUV", 798);
        LocaleCountryConverter.add("TR", "TUR", 792);
        LocaleCountryConverter.add("UG", "UGA", 800);
        LocaleCountryConverter.add("UA", "UKR", 804);
        LocaleCountryConverter.add("AE", "ARE", 784);
        LocaleCountryConverter.add("GB", "GBR", 826);
        LocaleCountryConverter.add("UM", "UMI", 581);
        LocaleCountryConverter.add("US", "USA", 840);
        LocaleCountryConverter.add("UY", "URY", 858);
        LocaleCountryConverter.add("UZ", "UZB", 860);
        LocaleCountryConverter.add("VU", "VUT", 548);
        LocaleCountryConverter.add("VE", "VEN", 862);
        LocaleCountryConverter.add("VN", "VNM", 704);
        LocaleCountryConverter.add("VG", "VGB", 92);
        LocaleCountryConverter.add("VI", "VIR", 850);
        LocaleCountryConverter.add("WF", "WLF", 876);
        LocaleCountryConverter.add("EH", "ESH", 732);
        LocaleCountryConverter.add("YE", "YEM", 887);
        LocaleCountryConverter.add("ZM", "ZMB", 894);
        LocaleCountryConverter.add("ZW", "ZWE", 716);
        LocaleCountryConverter.add("AX", "ALA", 248);
    }
}

