/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.localecombobox;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.localecombobox.BaseLocaleComboBoxDemo;
import com.flowingcode.vaadin.addons.localecombobox.LocaleComboBox;
import com.flowingcode.vaadin.addons.localecombobox.LocaleComboBoxDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@DemoSource
@PageTitle(value="Flag rendering")
@Route(value="locale-combo-box/rendering", layout=LocaleComboBoxDemoView.class)
public class RenderingDemo
extends BaseLocaleComboBoxDemo {
    public RenderingDemo() {
        List<Locale> localeList = Arrays.stream(Locale.getAvailableLocales()).filter(loc -> !loc.getDisplayName().isBlank()).sorted((l1, l2) -> l1.getDisplayName().compareTo(l2.getDisplayName())).toList();
        LocaleComboBox defaultLocaleCombo = new LocaleComboBox(localeList);
        LocaleComboBox flagsLocaleCombo = new LocaleComboBox(localeList);
        Checkbox checkbox = new Checkbox("Render flags");
        defaultLocaleCombo.setValue((Object)Locale.ITALY);
        flagsLocaleCombo.setValue((Object)Locale.ITALY);
        checkbox.setValue((Object)true);
        checkbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> flagsLocaleCombo.setHasFlags(((Boolean)event.getValue()).booleanValue()));
        this.add(new Component[]{this.createHorizontalContainer("Flags are rendered by default:", defaultLocaleCombo)});
        this.add(new Component[]{this.createHorizontalContainer((Component)checkbox, flagsLocaleCombo)});
    }
}

