/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.localecombobox;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.localecombobox.BaseLocaleComboBoxDemo;
import com.flowingcode.vaadin.addons.localecombobox.LocaleComboBox;
import com.flowingcode.vaadin.addons.localecombobox.LocaleComboBoxDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@DemoSource
@PageTitle(value="Display modes")
@Route(value="locale-combo-box/display", layout=LocaleComboBoxDemoView.class)
public class DisplayModeDemo
extends BaseLocaleComboBoxDemo {
    public DisplayModeDemo() {
        List<Locale> localeList = Arrays.stream(Locale.getAvailableLocales()).filter(loc -> !loc.getDisplayName().isBlank()).sorted((l1, l2) -> l1.getDisplayName().compareTo(l2.getDisplayName())).toList();
        LocaleComboBox defaultDisplayLocale = new LocaleComboBox(localeList);
        LocaleComboBox koreanLocaleCombo = new LocaleComboBox();
        LocaleComboBox selectedLocaleCombo = new LocaleComboBox(localeList);
        defaultDisplayLocale.setValue((Object)Locale.ITALY);
        koreanLocaleCombo.setItems(localeList);
        koreanLocaleCombo.setDisplayLocale(Locale.KOREA);
        koreanLocaleCombo.setDisplayMode(LocaleComboBox.DisplayMode.CUSTOM);
        koreanLocaleCombo.setValue((Object)Locale.ITALY);
        selectedLocaleCombo.setDisplayMode(LocaleComboBox.DisplayMode.SELECTED);
        selectedLocaleCombo.setValue((Object)Locale.ITALY);
        this.add(new Component[]{this.createHorizontalContainer("Default display mode (uses default locale):", defaultDisplayLocale), this.createHorizontalContainer("Display locales with Korean locale:", koreanLocaleCombo), this.createHorizontalContainer("Display locales with selected locale:", selectedLocaleCombo)});
    }
}

