/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.localecombobox;

import com.flowingcode.vaadin.addons.localecombobox.LocaleCountryConverter;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;

@NpmPackage(value="flag-icons", version="7.2.3")
@CssImport.Container(value={@CssImport(value="flag-icons/css/flag-icons.min.css"), @CssImport(value="./styles/locale-combo-box.css")})
public class LocaleComboBox
extends ComboBox<Locale> {
    private static final String ITEM_LAYOUT_CLASS_NAME = "fc-locale-combo-box-item-layout";
    private static final String ITEM_FLAG_CLASS_NAME = "fc-locale-combo-box-item-flag";
    private static final String DEFAULT_FLAG_CODE = "un";
    private DisplayMode displayMode = DisplayMode.DEFAULT;
    private Locale customDisplayLocale;
    private boolean hasFlags = true;

    public LocaleComboBox() {
        this.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> item.getDisplayName(this.getLocaleForDisplay()));
        this.setRenderer((Renderer)this.getLocaleRenderer());
        this.addValueChangeListener(this::onValueChange);
    }

    public LocaleComboBox(Collection<Locale> locales) {
        this();
        this.setItems(locales);
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public void setDisplayLocale(Locale displayLocale) {
        this.customDisplayLocale = displayLocale;
    }

    public boolean hasFlags() {
        return this.hasFlags;
    }

    public void setHasFlags(boolean hasFlags) {
        this.hasFlags = hasFlags;
        this.setRenderer((Renderer)(this.hasFlags ? this.getLocaleRenderer() : this.getLocaleRendererWithoutFlags()));
        this.setPrefixFlag(this.hasFlags ? (Locale)this.getValue() : null);
    }

    private LitRenderer<Locale> getLocaleRenderer() {
        return LitRenderer.of((String)"<vaadin-horizontal-layout class=\"${item.layoutClass}\">\n    <span class=\"fi fi-${item.countryCode} ${item.flagClass} alt=\"${item.countryName}'s flag\"></span>\n    <span>${item.displayName}</span>\n</vaadin-horizontal-layout>").withProperty("layoutClass", (ValueProvider & Serializable)loc -> ITEM_LAYOUT_CLASS_NAME).withProperty("flagClass", (ValueProvider & Serializable)loc -> ITEM_FLAG_CLASS_NAME).withProperty("countryCode", this::getFlagCode).withProperty("countryName", (ValueProvider & Serializable)loc -> loc.getDisplayCountry(this.getLocaleForDisplay())).withProperty("displayName", (ValueProvider & Serializable)loc -> loc.getDisplayName(this.getLocaleForDisplay()));
    }

    private LitRenderer<Locale> getLocaleRendererWithoutFlags() {
        return LitRenderer.of((String)"<vaadin-horizontal-layout class=\"${item.layoutClass}\">\n    <span>${item.displayName}</span>\n</vaadin-horizontal-layout>").withProperty("layoutClass", (ValueProvider & Serializable)loc -> ITEM_LAYOUT_CLASS_NAME).withProperty("displayName", (ValueProvider & Serializable)loc -> loc.getDisplayName(this.getLocaleForDisplay()));
    }

    private Locale getLocaleForDisplay() {
        switch (this.displayMode) {
            case CUSTOM: {
                return Optional.ofNullable(this.customDisplayLocale).orElseGet(() -> this.getLocale());
            }
            case SELECTED: {
                return Optional.ofNullable((Locale)this.getValue()).orElseGet(() -> this.getLocale());
            }
        }
        return this.getLocale();
    }

    private String getFlagCode(Locale locale) {
        String countryCode = locale.getCountry();
        return LocaleCountryConverter.convertToISO3166Code(countryCode).map(String::toLowerCase).orElse(DEFAULT_FLAG_CODE);
    }

    private void onValueChange(AbstractField.ComponentValueChangeEvent<ComboBox<Locale>, Locale> event) {
        if (!this.hasFlags) {
            return;
        }
        Locale newValue = (Locale)event.getValue();
        this.setPrefixFlag(newValue);
    }

    private void setPrefixFlag(Locale locale) {
        if (locale == null) {
            this.setPrefixComponent(null);
            return;
        }
        Span flagIcon = new Span();
        flagIcon.addClassNames(new String[]{"fi", "fi-" + this.getFlagCode(locale)});
        this.setPrefixComponent((Component)flagIcon);
    }

    public static enum DisplayMode {
        DEFAULT,
        SELECTED,
        CUSTOM;

    }
}

