/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.litetemplate;

import com.flowingcode.vaadin.addons.litetemplate.LitRendererBuilder;
import com.flowingcode.vaadin.addons.litetemplate.LiteComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class LiteRenderer<SOURCE>
extends Renderer<SOURCE> {
    private final Component component;
    private String templateExpression;
    private LitRenderer<SOURCE> renderer;
    private final Map<String, ValueProvider<SOURCE, ?>> properties = new HashMap();

    private LiteRenderer(@NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.component = component;
    }

    private void updateRenderer() {
        this.renderer = LitRendererBuilder.build(this.component, Collections.unmodifiableMap(this.properties), this::setTemplateExpression);
    }

    public String toString() {
        return Optional.ofNullable(this.templateExpression).orElseGet(() -> {
            try {
                this.updateRenderer();
                String string = this.templateExpression;
                return string;
            }
            finally {
                this.templateExpression = null;
                this.renderer = null;
            }
        });
    }

    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, String rendererName) {
        if (this.renderer == null) {
            this.updateRenderer();
        }
        return this.renderer.render(container, keyMapper, rendererName);
    }

    public static <SOURCE> LiteRenderer<SOURCE> of(Component templateComponent) {
        return new LiteRenderer<SOURCE>(templateComponent);
    }

    public LiteRenderer<SOURCE> disableInterpolation() {
        LiteComponent.of(this.component).disableInterpolation();
        return this;
    }

    public LiteRenderer<SOURCE> disableInterpolation(Component component) {
        LiteComponent.of(component).disableInterpolation();
        return this;
    }

    public LiteRenderer<SOURCE> enableInterpolation(Component component) {
        LiteComponent.of(component).enableInterpolation();
        return this;
    }

    private void assertTemplateContainsComponent(Component c) {
        if (!LiteRenderer.find(this.component, c)) {
            throw new IllegalArgumentException("Component is not a children of the template");
        }
    }

    private static boolean find(Component c, Component target) {
        return c == target || c.getChildren().anyMatch(child -> LiteRenderer.find(child, target));
    }

    public LiteRenderer<SOURCE> withProperty(@NonNull String property, @NonNull ValueProvider<SOURCE, ?> provider) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.properties.put(property, provider);
        if (this.renderer != null) {
            this.renderer.withProperty(property, provider);
        }
        return this;
    }

    public LiteRenderer<SOURCE> withProperty(@NonNull Component component, @NonNull String name, @NonNull ValueProvider<SOURCE, ?> valueProvider) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (valueProvider == null) {
            throw new NullPointerException("valueProvider is marked non-null but is null");
        }
        this.assertTemplateContainsComponent(component);
        LiteComponent.of(component).withElementProperty(name, valueProvider);
        this.renderer = null;
        return this;
    }

    public LiteRenderer<SOURCE> withAttribute(@NonNull Component component, @NonNull String attribute, @NonNull ValueProvider<SOURCE, ?> valueProvider) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        if (valueProvider == null) {
            throw new NullPointerException("valueProvider is marked non-null but is null");
        }
        this.assertTemplateContainsComponent(component);
        LiteComponent.of(component).withAttribute(attribute, valueProvider);
        this.renderer = null;
        return this;
    }

    public LiteRenderer<SOURCE> withAttribute(@NonNull Component component, @NonNull String attribute, String value) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        this.assertTemplateContainsComponent(component);
        LiteComponent.of(component).withAttribute(attribute, value);
        this.renderer = null;
        return this;
    }

    public LiteRenderer<SOURCE> withListener(@NonNull Component component, @NonNull String eventType, @NonNull SerializableBiConsumer<SOURCE, JsonArray> handler, String ... eventArguments) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.assertTemplateContainsComponent(component);
        LiteComponent.of(component).withListener(eventType, handler, eventArguments);
        this.renderer = null;
        return this;
    }

    public LiteRenderer<SOURCE> withListener(@NonNull Component component, @NonNull String eventType, @NonNull SerializableConsumer<SOURCE> handler) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.assertTemplateContainsComponent(component);
        LiteComponent.of(component).withListener(eventType, handler);
        this.renderer = null;
        return this;
    }

    static void fireEvent(Object item, ComponentEvent<?> event) {
        LiteRenderer.setItem(event, item);
        try {
            ComponentUtil.fireEvent((Component)event.getSource(), event);
        }
        finally {
            LiteRenderer.setItem(event, null);
        }
    }

    private static void setItem(ComponentEvent<?> event, Object item) {
        LiteRendererItemReference ref = Optional.ofNullable(item).map(LiteRendererItemReference::new).orElse(null);
        ComponentUtil.setData((Component)event.getSource(), LiteRendererItemReference.class, (Object)ref);
    }

    public static <T> T getItem(ComponentEvent<?> event, Class<T> type) {
        LiteRendererItemReference ref = (LiteRendererItemReference)ComponentUtil.getData((Component)event.getSource(), LiteRendererItemReference.class);
        if (ref == null) {
            throw new IllegalStateException();
        }
        return type.cast(ref.item);
    }

    @Generated
    private void setTemplateExpression(String templateExpression) {
        this.templateExpression = templateExpression;
    }

    private static class LiteRendererItemReference
    implements Serializable {
        private final Object item;

        @Generated
        public LiteRendererItemReference(Object item) {
            this.item = item;
        }
    }
}

