/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.litetemplate;

import com.flowingcode.vaadin.addons.litetemplate.LiteComponent;
import com.flowingcode.vaadin.addons.litetemplate.LiteListener;
import com.flowingcode.vaadin.addons.litetemplate.LiteRenderer;
import com.flowingcode.vaadin.addons.litetemplate.LiteRendererData;
import com.flowingcode.vaadin.addons.litetemplate.PropertyEncoder;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import elemental.json.JsonArray;
import elemental.json.JsonBoolean;
import elemental.json.JsonNumber;
import elemental.json.JsonString;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;

final class LitRendererBuilder<SOURCE> {
    public static final String RENDERER_KEY = "renderer";
    private final Component component;
    private final StringBuilder sb = new StringBuilder();
    private final Map<String, ValueProvider<SOURCE, ?>> properties = new HashMap();
    private final Map<String, SerializableBiConsumer<SOURCE, JsonArray>> functions = new HashMap<String, SerializableBiConsumer<SOURCE, JsonArray>>();

    private LitRendererBuilder(Component component) {
        this.component = component;
    }

    public static <SOURCE> LitRenderer<SOURCE> build(@NonNull Component component, @NonNull Map<String, ValueProvider<SOURCE, ?>> properties, @NonNull Consumer<String> setTemplateExpression) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (setTemplateExpression == null) {
            throw new NullPointerException("setTemplateExpression is marked non-null but is null");
        }
        return new LitRendererBuilder<SOURCE>(component).build(properties, setTemplateExpression);
    }

    private LiteRendererData<SOURCE> getData(Component component) {
        return LiteRendererData.getInstance(component);
    }

    private LitRenderer<SOURCE> build(Map<String, ValueProvider<SOURCE, ?>> rendererProperties, Consumer<String> setTemplateExpression) {
        Element element;
        if (!this.sb.isEmpty()) {
            throw new IllegalStateException();
        }
        this.properties.putAll(rendererProperties);
        Component component = this.component;
        if (component instanceof LiteComponent) {
            LiteComponent lite = (LiteComponent)component;
            element = lite.unwrap().getElement();
        } else {
            element = this.component.getElement();
        }
        this.writeElement(element, true, "\n  ");
        String templateExpression = this.sb.toString() + "\n";
        LitRenderer renderer = LitRenderer.of((String)templateExpression);
        this.functions.forEach((n, v) -> renderer.withFunction(n, v));
        this.properties.forEach((n, v) -> renderer.withProperty(n, v));
        setTemplateExpression.accept(templateExpression);
        return renderer;
    }

    private String addFunction(SerializableBiConsumer<SOURCE, JsonArray> handler) {
        String name = "function" + this.functions.size();
        this.functions.put(name, handler);
        return name;
    }

    private String addProperty(ValueProvider<SOURCE, ?> valueProvider) {
        String name = "property" + this.properties.size();
        this.properties.put(name, valueProvider);
        return name;
    }

    private void writeElement(Element e, boolean interpolationEnabled, String padding) {
        if (e.isTextNode()) {
            this.sb.append(padding);
            this.sb.append(LitRendererBuilder.encodeReplaceableCharacterData(e.getText(), interpolationEnabled));
        } else {
            LiteRendererData<SOURCE> data = this.getData((Component)e.getComponent().get());
            if (data.isInterpolationEnabled().filter(value -> value != interpolationEnabled).isPresent()) {
                this.writeElement(e, !interpolationEnabled, padding);
                return;
            }
            this.sb.append(padding);
            this.sb.append('<').append(e.getTag());
            data.getAttributes().forEach((name, valueProvider) -> {
                e.removeAttribute(name);
                this.writeAttribute((String)name, (ValueProvider<SOURCE, ?>)valueProvider);
            });
            e.getAttributeNames().forEach(name -> this.writeAttribute(e, (String)name, interpolationEnabled));
            data.getProperties().forEach((name, valueProvider) -> {
                e.removeProperty(name);
                this.writeProperty((String)name, (ValueProvider<SOURCE, ?>)valueProvider);
            });
            e.getPropertyNames().forEach(name -> this.writeProperty(e, (String)name, interpolationEnabled));
            this.writeEventListeners(e);
            this.sb.append('>');
            if (e.getChildCount() != 0) {
                String nested = padding + "  ";
                int n = e.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.writeElement(e.getChild(i), interpolationEnabled, nested);
                }
                this.sb.append(padding);
            }
            this.sb.append("</").append(e.getTag()).append('>');
        }
    }

    private void writeAttribute(String name, ValueProvider<SOURCE, ?> valueProvider) {
        this.sb.append(' ').append(name);
        this.sb.append("=${item.").append(this.addProperty(valueProvider)).append('}');
    }

    private void writeAttribute(Element element, String name, boolean interpolationEnabled) {
        this.sb.append(' ').append(name);
        String value = element.getAttribute(name);
        if (!value.isEmpty()) {
            this.sb.append('=');
            if (interpolationEnabled) {
                this.sb.append(LitRendererBuilder.encodeAttributeValueSpecification(value));
            } else {
                this.sb.append('`').append(LitRendererBuilder.escapeTemplateCharacters(value)).append('`');
            }
        }
    }

    private void writeProperty(Element element, String name, boolean interpolationEnabled) {
        Object value = element.getPropertyRaw(name);
        if (value instanceof String) {
            String val = (String)value;
            value = interpolationEnabled ? LitRendererBuilder.encodePropertyValue(val) : LitRendererBuilder.encodePropertyValue(LitRendererBuilder.escapeTemplateCharacters(val));
            value = "`" + value + "`";
        } else if (value instanceof JsonString) {
            JsonString val = (JsonString)value;
            value = LitRendererBuilder.encodePropertyValue(LitRendererBuilder.escapeTemplateCharacters(val.asString()));
        } else if (value instanceof Double || value instanceof Boolean) {
            value = String.valueOf(value);
        } else if (value instanceof JsonBoolean) {
            JsonBoolean val = (JsonBoolean)value;
            value = Boolean.toString(val.asBoolean());
        } else if (value instanceof JsonNumber) {
            JsonNumber val = (JsonNumber)value;
            value = Double.toString(val.asNumber());
        } else if (value instanceof JsonValue) {
            JsonValue val = (JsonValue)value;
            value = val.toString();
        } else {
            throw new IllegalArgumentException();
        }
        this.sb.append(" .").append(name).append("=${").append(value).append('}');
    }

    private void writeProperty(String name, ValueProvider<SOURCE, ?> valueProvider) {
        this.sb.append(" .").append(name);
        this.sb.append("=${item.").append(this.addProperty(valueProvider)).append('}');
    }

    private void writeEventListeners(Element e) {
        Component c = (Component)e.getComponent().get();
        if (c instanceof Button && !this.getData(c).hasListener("click")) {
            this.getData(c).addListener("click", new LiteListener((SerializableConsumer & Serializable)item -> LiteRenderer.fireEvent(item, new ClickEvent(c))));
        }
        this.getData(c).getListeners().forEach((eventType, listener) -> {
            String formalArguments;
            String actualArguments;
            SerializableBiConsumer handler = listener.getHandler();
            String functionName = this.addFunction((SerializableBiConsumer & Serializable)(item, args) -> handler.accept(item, args));
            if (listener.hasArguments()) {
                actualArguments = listener.getArguments();
                formalArguments = "event";
            } else {
                actualArguments = "";
                formalArguments = "";
            }
            this.sb.append(String.format(" @%s=${(%s)=>%s(%s)}", eventType, formalArguments, functionName, actualArguments));
        });
    }

    private static String encodeAttributeValueSpecification(String value) {
        if (value.contains("${")) {
            return LitRendererBuilder.encodePropertyValue(value);
        }
        if ((value = value.replace("&", "&amp;")).indexOf(34) >= 0 && value.indexOf(39) < 0) {
            return "'" + value + "'";
        }
        return "\"" + value.replace("\"", "&quot;") + "\"";
    }

    private static String encodeReplaceableCharacterData(String value, boolean interpolationEnabled) {
        if (value.startsWith("\\${")) {
            value = value.substring(1);
        } else if (value.startsWith("${")) {
            return value;
        }
        return value.replace("&", "&amp;").replace("<", "&lt;");
    }

    private static String escapeTemplateCharacters(String value) {
        return value.replace("`", "\\`").replace("$", "\\$");
    }

    private static String encodePropertyValue(String value) {
        return PropertyEncoder.encode(value).orElseGet(() -> LitRendererBuilder.escapeTemplateCharacters(value));
    }
}

