/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.litetemplate;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;

class PropertyEncoder {
    PropertyEncoder() {
    }

    public static Optional<String> encode(String value, String prefix, String suffix) {
        return Context.encode(value, prefix, suffix);
    }

    private static final class Context
    extends Enum<Context> {
        public static final /* enum */ Context INITIAL = new Context();
        public static final /* enum */ Context ESCAPED = new Context();
        public static final /* enum */ Context QUOT = new Context();
        public static final /* enum */ Context APOS = new Context();
        public static final /* enum */ Context TEMPLATE_HEAD = new Context();
        public static final /* enum */ Context EXPRESSION = new Context();
        public static final /* enum */ Context NESTED_TEMPLATE = new Context();
        private static final /* synthetic */ Context[] $VALUES;

        public static Context[] values() {
            return (Context[])$VALUES.clone();
        }

        public static Context valueOf(String name) {
            return Enum.valueOf(Context.class, name);
        }

        private static Context pop(Deque<Context> stack) {
            stack.pop();
            return null;
        }

        static Optional<String> encode(String s, String prefix, String suffix) {
            StringBuilder sb = new StringBuilder();
            int templateBegin = -1;
            int templateEnd = -1;
            ArrayDeque<Context> stack = new ArrayDeque<Context>();
            stack.push(INITIAL);
            int n = s.length();
            block25: for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                sb.append(c);
                switch ((Context)((Object)stack.peek())) {
                    case ESCAPED: {
                        stack.pop();
                        continue block25;
                    }
                    case QUOT: {
                        if (c != '\"') continue block25;
                        stack.pop();
                        continue block25;
                    }
                    case APOS: {
                        if (c != '\'') continue block25;
                        stack.pop();
                        continue block25;
                    }
                    case TEMPLATE_HEAD: {
                        assert (c == '{');
                        stack.pop();
                        stack.push(EXPRESSION);
                        continue block25;
                    }
                    case INITIAL: {
                        switch (c) {
                            case '`': {
                                sb.setLength(sb.length() - 1);
                                sb.append('\\').append(c);
                                continue block25;
                            }
                            case '$': {
                                templateBegin = i;
                            }
                        }
                    }
                    case NESTED_TEMPLATE: {
                        Context context;
                        switch (c) {
                            case '`': {
                                context = Context.pop(stack);
                                break;
                            }
                            case '$': {
                                if (i < n - 1 && s.charAt(i + 1) == '{') {
                                    context = TEMPLATE_HEAD;
                                    break;
                                }
                                context = null;
                                break;
                            }
                            case '\\': {
                                context = ESCAPED;
                                break;
                            }
                            default: {
                                context = null;
                            }
                        }
                        Optional.ofNullable(context).ifPresent(stack::push);
                        continue block25;
                    }
                    case EXPRESSION: {
                        Context context;
                        switch (c) {
                            case '\"': {
                                context = QUOT;
                                break;
                            }
                            case '\'': {
                                context = APOS;
                                break;
                            }
                            case '`': {
                                context = NESTED_TEMPLATE;
                                break;
                            }
                            case '{': {
                                context = EXPRESSION;
                                break;
                            }
                            case '}': {
                                templateEnd = i + 1;
                                context = Context.pop(stack);
                                break;
                            }
                            default: {
                                context = null;
                            }
                        }
                        Optional.ofNullable(context).ifPresent(stack::push);
                        continue block25;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (stack.peek() == INITIAL) {
                Object encoded = sb.toString();
                if (templateBegin != 0 || templateEnd != s.length()) {
                    encoded = prefix + (String)encoded + suffix;
                }
                return Optional.of(encoded);
            }
            return Optional.empty();
        }

        private static /* synthetic */ Context[] $values() {
            return new Context[]{INITIAL, ESCAPED, QUOT, APOS, TEMPLATE_HEAD, EXPRESSION, NESTED_TEMPLATE};
        }

        static {
            $VALUES = Context.$values();
        }
    }
}

