/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.litetemplate;

import com.flowingcode.vaadin.addons.litetemplate.LiteListener;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class LiteRendererData<SOURCE>
implements Serializable {
    private Map<String, LiteListener<SOURCE>> listeners = Collections.emptyMap();
    private Map<String, ValueProvider<SOURCE, ?>> attributes = Collections.emptyMap();
    private Map<String, ValueProvider<SOURCE, ?>> properties = Collections.emptyMap();
    private Boolean interpolationEnabled;

    LiteRendererData() {
    }

    static <SOURCE> LiteRendererData<SOURCE> getInstance(Component c) {
        LiteRendererData<SOURCE> data = (LiteRendererData<SOURCE>)ComponentUtil.getData((Component)c, LiteRendererData.class);
        if (data == null) {
            data = new LiteRendererData<SOURCE>();
            ComponentUtil.setData((Component)c, LiteRendererData.class, data);
        }
        return data;
    }

    Optional<Boolean> isInterpolationEnabled() {
        return Optional.ofNullable(this.interpolationEnabled);
    }

    void setInterpolationEnabled(boolean interpolationEnabled) {
        this.interpolationEnabled = interpolationEnabled;
    }

    void addProperty(String name, ValueProvider<SOURCE, ?> valueProvider) {
        this.properties = LiteRendererData.put(this.properties, name, valueProvider);
    }

    void removeProperty(String name) {
        this.properties = LiteRendererData.remove(this.properties, name);
    }

    Map<String, ValueProvider<SOURCE, ?>> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    void addAttribute(String attribute, ValueProvider<SOURCE, ?> valueProvider) {
        this.attributes = LiteRendererData.put(this.attributes, attribute, valueProvider);
    }

    void removeAttribute(String name) {
        this.attributes = LiteRendererData.remove(this.attributes, name);
    }

    Map<String, ValueProvider<SOURCE, ?>> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    void addListener(String eventType, LiteListener<SOURCE> listener) {
        if (this.hasListener(eventType)) {
            throw new IllegalArgumentException(String.format("A listener for the event type '%s' is already registered on the specified component.", eventType));
        }
        this.listeners = LiteRendererData.put(this.listeners, eventType, listener);
    }

    Map<String, LiteListener<SOURCE>> getListeners() {
        return Collections.unmodifiableMap(this.listeners);
    }

    boolean hasListener(String eventType) {
        return this.listeners.containsKey(eventType);
    }

    private static <K, V> Map<K, V> put(Map<K, V> map, K k, V v) {
        return switch (map.size()) {
            case 0 -> Map.of(k, v);
            case 1 -> {
                map = new HashMap<K, V>(map);
                map.put(k, v);
                yield map;
            }
            default -> {
                map.put(k, v);
                yield map;
            }
        };
    }

    private static <K, V> Map<K, V> remove(Map<K, V> map, K k) {
        Map<K, V> map2;
        if (!map.containsKey(k)) {
            map2 = map;
        } else {
            switch (map.size()) {
                case 1: {
                    map2 = Collections.emptyMap();
                    break;
                }
                default: {
                    map.remove(k);
                    map2 = map;
                }
            }
        }
        return map2;
    }
}

