/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.litetemplate;

import com.flowingcode.vaadin.addons.litetemplate.LiteListener;
import com.flowingcode.vaadin.addons.litetemplate.LiteRendererData;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class LiteComponent<COMPONENT extends Component>
extends Component {
    private final COMPONENT component;

    private LiteComponent(@NonNull COMPONENT component) {
        super(null);
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.component = component;
    }

    public void disableInterpolation() {
        LiteRendererData.getInstance(this.component).setInterpolationEnabled(false);
    }

    public void enableInterpolation() {
        LiteRendererData.getInstance(this.component).setInterpolationEnabled(true);
    }

    public static <C extends Component> LiteComponent<C> of(C component) {
        return component instanceof LiteComponent ? (LiteComponent<Object>)component : new LiteComponent<C>(component);
    }

    public Element getElement() {
        throw new UnsupportedOperationException();
    }

    protected ComponentEventBus getEventBus() {
        throw new UnsupportedOperationException();
    }

    public COMPONENT unwrap() {
        return this.component;
    }

    public <SOURCE> LiteComponent<COMPONENT> withAttribute(String attribute, boolean value) {
        this.component.getElement().setAttribute(attribute, value);
        LiteRendererData.getInstance(this.component).removeAttribute(attribute);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withAttribute(String attribute, String value) {
        this.component.getElement().setAttribute(attribute, value);
        LiteRendererData.getInstance(this.component).removeAttribute(attribute);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withAttribute(String attribute, ValueProvider<SOURCE, ?> valueProvider) {
        LiteRendererData.getInstance(this.component).addAttribute(attribute, valueProvider);
        this.component.getElement().removeAttribute(attribute);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withElementProperty(String name, boolean value) {
        this.component.getElement().setProperty(name, value);
        LiteRendererData.getInstance(this.component).removeProperty(name);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withElementProperty(String name, double value) {
        this.component.getElement().setProperty(name, value);
        LiteRendererData.getInstance(this.component).removeProperty(name);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withElementProperty(String name, String value) {
        this.component.getElement().setProperty(name, value);
        LiteRendererData.getInstance(this.component).removeProperty(name);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withElementPropertyBean(String name, Object value) {
        this.component.getElement().setPropertyBean(name, value);
        LiteRendererData.getInstance(this.component).removeProperty(name);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withElementPropertyJson(String name, JsonValue value) {
        this.component.getElement().setPropertyJson(name, value);
        LiteRendererData.getInstance(this.component).removeProperty(name);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withElementPropertyList(String name, List<?> value) {
        this.component.getElement().setPropertyList(name, value);
        LiteRendererData.getInstance(this.component).removeProperty(name);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withElementPropertyMap(String name, Map<String, ?> value) {
        this.component.getElement().setPropertyMap(name, value);
        LiteRendererData.getInstance(this.component).removeProperty(name);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withElementProperty(String name, ValueProvider<SOURCE, ?> valueProvider) {
        LiteRendererData.getInstance(this.component).addProperty(name, valueProvider);
        this.component.getElement().removeProperty(name);
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withListener(String eventType, SerializableConsumer<SOURCE> handler) {
        LiteRendererData.getInstance(this.component).addListener(eventType, new LiteListener<SOURCE>(handler));
        return this;
    }

    public <SOURCE> LiteComponent<COMPONENT> withListener(String eventType, SerializableBiConsumer<SOURCE, JsonArray> handler, String ... eventArguments) {
        eventArguments = Arrays.copyOf(eventArguments, eventArguments.length);
        LiteRendererData.getInstance(this.component).addListener(eventType, new LiteListener<SOURCE>(handler, eventArguments));
        return this;
    }
}

