/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.litetemplate;

import com.flowingcode.vaadin.addons.litetemplate.LiteComponent;
import com.flowingcode.vaadin.addons.litetemplate.LiteListener;
import com.flowingcode.vaadin.addons.litetemplate.LiteRenderer;
import com.flowingcode.vaadin.addons.litetemplate.LiteRendererData;
import com.flowingcode.vaadin.addons.litetemplate.PropertyEncoder;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import elemental.json.JsonArray;
import elemental.json.JsonBoolean;
import elemental.json.JsonNumber;
import elemental.json.JsonString;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;

final class LitRendererBuilder<SOURCE> {
    public static final String RENDERER_KEY = "renderer";
    private final List<Component> components;
    private final StringBuilder sb = new StringBuilder();
    private final Map<String, ValueProvider<SOURCE, ?>> properties = new HashMap();
    private final Map<String, SerializableBiConsumer<SOURCE, JsonArray>> functions = new HashMap<String, SerializableBiConsumer<SOURCE, JsonArray>>();

    private LitRendererBuilder(List<Component> components) {
        this.components = components;
    }

    public static <SOURCE> LitRenderer<SOURCE> build(@NonNull List<Component> components, @NonNull Map<String, ValueProvider<SOURCE, ?>> properties, @NonNull Consumer<String> setTemplateExpression) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (setTemplateExpression == null) {
            throw new NullPointerException("setTemplateExpression is marked non-null but is null");
        }
        return new LitRendererBuilder<SOURCE>(components).build(properties, setTemplateExpression);
    }

    private LiteRendererData<SOURCE> getData(Component component) {
        return LiteRendererData.getInstance(component);
    }

    private LitRenderer<SOURCE> build(Map<String, ValueProvider<SOURCE, ?>> rendererProperties, Consumer<String> setTemplateExpression) {
        if (!this.sb.isEmpty()) {
            throw new IllegalStateException();
        }
        this.properties.putAll(rendererProperties);
        for (Component component : this.components) {
            Element element;
            if (component instanceof LiteComponent) {
                LiteComponent lite = (LiteComponent)component;
                element = lite.unwrap().getElement();
            } else {
                element = component.getElement();
            }
            this.writeElement(element, true, "\n  ");
        }
        String templateExpression = this.sb.toString() + "\n";
        LitRenderer renderer = LitRenderer.of((String)templateExpression);
        this.functions.forEach((n, v) -> renderer.withFunction(n, v));
        this.properties.forEach((n, v) -> renderer.withProperty(n, v));
        setTemplateExpression.accept(templateExpression);
        return renderer;
    }

    private String addFunction(SerializableBiConsumer<SOURCE, JsonArray> handler) {
        String name = "function" + this.functions.size();
        this.functions.put(name, handler);
        return name;
    }

    private String addProperty(ValueProvider<SOURCE, ?> valueProvider) {
        String name = "property" + this.properties.size();
        this.properties.put(name, valueProvider);
        return name;
    }

    private void writeElement(Element e, boolean interpolationEnabled, String padding) {
        if (e.isTextNode()) {
            this.sb.append(padding);
            String text = e.getText();
            if (interpolationEnabled || !text.contains("${") && !text.contains("`")) {
                this.sb.append(LitRendererBuilder.encodeReplaceableCharacterData(text));
            } else {
                this.sb.append(LitRendererBuilder.wrapAndEscapeTemplateCharacters(text));
            }
        } else {
            LiteRendererData<SOURCE> data = this.getData((Component)e.getComponent().get());
            if (data.isInterpolationEnabled().filter(value -> value != interpolationEnabled).isPresent()) {
                this.writeElement(e, !interpolationEnabled, padding);
                return;
            }
            this.sb.append(padding);
            this.sb.append('<').append(e.getTag());
            data.getAttributes().forEach((name, valueProvider) -> {
                e.removeAttribute(name);
                this.writeAttribute((String)name, (ValueProvider<SOURCE, ?>)valueProvider);
            });
            e.getAttributeNames().forEach(name -> this.writeAttribute(e, (String)name, interpolationEnabled));
            data.getProperties().forEach((name, valueProvider) -> {
                e.removeProperty(name);
                this.writeProperty((String)name, (ValueProvider<SOURCE, ?>)valueProvider);
            });
            e.getPropertyNames().forEach(name -> this.writeProperty(e, (String)name, interpolationEnabled));
            this.writeEventListeners(e);
            this.sb.append('>');
            if (e.getChildCount() != 0) {
                String nested = padding + "  ";
                int n = e.getChildCount();
                for (int i = 0; i < n; ++i) {
                    this.writeElement(e.getChild(i), interpolationEnabled, nested);
                }
                this.sb.append(padding);
            }
            this.sb.append("</").append(e.getTag()).append('>');
        }
    }

    private void writeAttribute(String name, ValueProvider<SOURCE, ?> valueProvider) {
        this.sb.append(' ').append(name);
        this.sb.append("=${item.").append(this.addProperty(valueProvider)).append('}');
    }

    private void writeAttribute(Element element, String name, boolean interpolationEnabled) {
        this.sb.append(' ').append(name);
        String value = element.getAttribute(name);
        if (!value.isEmpty()) {
            this.sb.append('=');
            if (interpolationEnabled) {
                this.sb.append(LitRendererBuilder.encodeAttributeValueSpecification(value));
            } else {
                this.sb.append(LitRendererBuilder.wrapAndEscapeTemplateCharacters(value));
            }
        }
    }

    private void writeProperty(Element element, String name, boolean interpolationEnabled) {
        boolean wrap = true;
        Object value = element.getPropertyRaw(name);
        if (value instanceof String) {
            String val = (String)value;
            value = interpolationEnabled ? LitRendererBuilder.encodePropertyValue(val, "${`", "`}") : LitRendererBuilder.wrapAndEscapeTemplateCharacters(val);
            wrap = false;
        } else if (value instanceof JsonString) {
            JsonString val = (JsonString)value;
            value = LitRendererBuilder.wrapAndEscapeTemplateCharacters(val.asString());
            wrap = false;
        } else if (value instanceof Double || value instanceof Boolean) {
            value = String.valueOf(value);
        } else if (value instanceof JsonBoolean) {
            JsonBoolean val = (JsonBoolean)value;
            value = Boolean.toString(val.asBoolean());
        } else if (value instanceof JsonNumber) {
            JsonNumber val = (JsonNumber)value;
            value = Double.toString(val.asNumber());
        } else if (value instanceof JsonValue) {
            JsonValue val = (JsonValue)value;
            value = val.toJson();
        } else {
            throw new IllegalArgumentException();
        }
        this.sb.append(" .").append(name).append('=');
        if (wrap) {
            this.sb.append("${").append(value).append('}');
        } else {
            this.sb.append(value);
        }
    }

    private void writeProperty(String name, ValueProvider<SOURCE, ?> valueProvider) {
        this.sb.append(" .").append(name);
        this.sb.append("=${item.").append(this.addProperty(valueProvider)).append('}');
    }

    private void writeEventListeners(Element e) {
        Component c = (Component)e.getComponent().get();
        if (c instanceof Button && !this.getData(c).hasListener("click")) {
            this.getData(c).addListener("click", new LiteListener((SerializableConsumer & Serializable)item -> LiteRenderer.fireEvent(item, new ClickEvent(c))));
        }
        this.getData(c).getListeners().forEach((eventType, listener) -> {
            String formalArguments;
            String actualArguments;
            SerializableBiConsumer handler = listener.getHandler();
            String functionName = this.addFunction((SerializableBiConsumer & Serializable)(item, args) -> handler.accept(item, args));
            if (listener.hasArguments()) {
                actualArguments = listener.getArguments();
                formalArguments = "event";
            } else {
                actualArguments = "";
                formalArguments = "";
            }
            this.sb.append(String.format(" @%s=${(%s)=>%s(%s)}", eventType, formalArguments, functionName, actualArguments));
        });
    }

    private static String encodeAttributeValueSpecification(String value) {
        if (value.contains("${")) {
            return LitRendererBuilder.encodePropertyValue(value, "\"", "\"");
        }
        if ((value = value.replace("&", "&amp;")).indexOf(34) >= 0 && value.indexOf(39) < 0) {
            return "'" + value + "'";
        }
        return "\"" + value.replace("\"", "&quot;") + "\"";
    }

    private static String encodeReplaceableCharacterData(String value) {
        if (value.startsWith("\\${")) {
            value = value.substring(1);
        } else if (value.startsWith("${")) {
            return value;
        }
        return value.replace("&", "&amp;").replace("<", "&lt;");
    }

    private static String wrapAndEscapeTemplateCharacters(String value) {
        return "${`" + value.replace("`", "\\`").replace("$", "\\$") + "`}";
    }

    private static String encodePropertyValue(String value, String prefix, String suffix) {
        return PropertyEncoder.encode(value, prefix, suffix).orElseGet(() -> LitRendererBuilder.wrapAndEscapeTemplateCharacters(value));
    }
}

