/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.imagecrop;

import com.flowingcode.vaadin.addons.imagecrop.Crop;
import com.flowingcode.vaadin.addons.imagecrop.CroppedImageEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.react.ReactAdapterComponent;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;

@NpmPackage(value="react-image-crop", version="11.0.6")
@JsModule(value="./src/image-crop.tsx")
@Tag(value="image-crop")
@CssImport.Container(value={@CssImport(value="react-image-crop/dist/ReactCrop.css"), @CssImport(value="./styles/image-crop-styles.css")})
public class ImageCrop
extends ReactAdapterComponent {
    private static final String IMG_FULL_HEIGHT_CLASS_NAME = "img-full-height";
    private String croppedImageDataUri;

    public ImageCrop(String src) {
        this.setImageSrc(src);
        this.addCroppedImageListener((ComponentEventListener<CroppedImageEvent>)((ComponentEventListener & Serializable)this::updateCroppedImage));
        this.croppedImageDataUri = src;
    }

    public ImageCrop(Image image) {
        this(image.getSrc());
        image.getAlt().ifPresent(a -> this.setImageAlt((String)a));
    }

    protected Registration addCroppedImageListener(ComponentEventListener<CroppedImageEvent> listener) {
        return this.addListener(CroppedImageEvent.class, listener);
    }

    private void updateCroppedImage(CroppedImageEvent event) {
        this.croppedImageDataUri = event.getCroppedImageDataUri();
    }

    public void setImageSrc(String imageSrc) {
        this.setState("imgSrc", imageSrc);
    }

    public String getImageSrc() {
        return (String)this.getState("imgSrc", String.class);
    }

    public void setImageAlt(String imageAlt) {
        this.setState("imgAlt", imageAlt);
    }

    public String getImageAlt() {
        return (String)this.getState("imgAlt", String.class);
    }

    public void setCrop(Crop crop) {
        this.setState("crop", crop);
        this.getElement().executeJs("this._updateCroppedImage(this.crop)", new Serializable[0]);
    }

    public Crop getCrop() {
        return (Crop)this.getState("crop", Crop.class);
    }

    public void setAspect(double aspect) {
        this.setState("aspect", aspect);
    }

    public double getAspect() {
        return (Double)this.getState("aspect", Double.class);
    }

    public void setCircularCrop(boolean circularCrop) {
        this.setState("circularCrop", circularCrop);
    }

    public boolean isCircularCrop() {
        return (Boolean)this.getState("circularCrop", Boolean.class);
    }

    public void setKeepSelection(boolean keepSelection) {
        this.setState("keepSelection", keepSelection);
    }

    public boolean isKeepSelection() {
        return (Boolean)this.getState("keepSelection", Boolean.class);
    }

    public void setDisabled(boolean disabled) {
        this.setState("disabled", disabled);
    }

    public boolean isDisabled() {
        return (Boolean)this.getState("disabled", Boolean.class);
    }

    public void setLocked(boolean locked) {
        this.setState("locked", locked);
    }

    public boolean isLocked() {
        return (Boolean)this.getState("locked", Boolean.class);
    }

    public void setCropMinWidth(Integer minWidth) {
        this.setState("minWidth", minWidth);
    }

    public Integer getCropMinWidth() {
        return (Integer)this.getState("minWidth", Integer.class);
    }

    public void setCropMinHeight(Integer minHeight) {
        this.setState("minHeight", minHeight);
    }

    public Integer getCropMinHeight() {
        return (Integer)this.getState("minHeight", Integer.class);
    }

    public void setCropMaxWidth(Integer maxWidth) {
        this.setState("maxWidth", maxWidth);
    }

    public Integer getCropMaxWidth() {
        return (Integer)this.getState("maxWidth", Integer.class);
    }

    public void setCropMaxHeight(Integer maxHeight) {
        this.setState("maxHeight", maxHeight);
    }

    public Integer getCropMaxHeight() {
        return (Integer)this.getState("maxHeight", Integer.class);
    }

    public void setRuleOfThirds(boolean ruleOfThirds) {
        this.setState("ruleOfThirds", ruleOfThirds);
    }

    public boolean isRuleOfThirds() {
        return (Boolean)this.getState("ruleOfThirds", Boolean.class);
    }

    public String getCroppedImageDataUri() {
        return this.croppedImageDataUri;
    }

    public void setImageFullHeight(Boolean fullHeight) {
        if (fullHeight.booleanValue()) {
            this.addClassName(IMG_FULL_HEIGHT_CLASS_NAME);
        } else {
            this.removeClassName(IMG_FULL_HEIGHT_CLASS_NAME);
        }
    }

    public byte[] getCroppedImageBase64() {
        String croppedDataUri = this.getCroppedImageDataUri();
        if (StringUtils.isBlank((CharSequence)croppedDataUri)) {
            return null;
        }
        String base64Data = croppedDataUri;
        if (croppedDataUri.contains("base64,")) {
            base64Data = croppedDataUri.split(",")[1];
        }
        return Base64.getDecoder().decode(base64Data.getBytes(StandardCharsets.UTF_8));
    }
}

