/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.imagecrop;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.imagecrop.Crop;
import com.flowingcode.vaadin.addons.imagecrop.ImageCrop;
import com.flowingcode.vaadin.addons.imagecrop.ImageCropDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.avatar.AvatarVariant;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Base64;

@DemoSource
@PageTitle(value="Image Crop with Upload")
@Route(value="image-crop/upload", layout=ImageCropDemoView.class)
public class UploadImageCropDemo
extends Div {
    private static final String[] ACCEPTED_MIME_TYPES = new String[]{"image/gif", "image/png", "image/jpeg", "image/bmp", "image/webp"};
    private Avatar avatar = new Avatar();
    private ImageCrop imageCrop = null;
    private byte[] newCroppedPicture = null;

    public UploadImageCropDemo() {
        this.avatar.addThemeVariants((ThemeVariant[])new AvatarVariant[]{AvatarVariant.LUMO_XLARGE});
        this.avatar.setHeight("12em");
        this.avatar.setWidth("12em");
        Div avatarDiv = new Div(new Component[]{this.avatar});
        MemoryBuffer buffer = new MemoryBuffer();
        Upload uploadComponent = new Upload((Receiver)buffer);
        uploadComponent.setMaxFiles(1);
        uploadComponent.setMaxFileSize(0xA00000);
        uploadComponent.setAcceptedFileTypes(ACCEPTED_MIME_TYPES);
        Span uploadCaption = new Span("Upload an image to crop and set as avatar:");
        HorizontalLayout avatarLayout = new HorizontalLayout(new Component[]{avatarDiv, new VerticalLayout(new Component[]{uploadCaption, uploadComponent})});
        avatarLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        uploadComponent.addFinishedListener((ComponentEventListener & Serializable)e -> this.openCropDialog((ByteArrayOutputStream)buffer.getFileData().getOutputBuffer(), e.getMIMEType()));
        uploadComponent.addFileRejectedListener((ComponentEventListener & Serializable)event -> {
            String errorMessage = event.getErrorMessage();
            Notification notification = Notification.show((String)errorMessage, (int)5000, (Notification.Position)Notification.Position.MIDDLE);
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
        });
        this.add(new Component[]{avatarLayout});
    }

    private void openCropDialog(ByteArrayOutputStream outputStream, String mimeType) {
        Dialog dialog = new Dialog();
        dialog.setCloseOnOutsideClick(false);
        dialog.setMaxHeight("100%");
        dialog.setMaxWidth(dialog.getHeight());
        Button cropButton = new Button("Crop image");
        Button dialogCancelButton = new Button("Cancel");
        dialogCancelButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR});
        String src = this.getImageAsBase64(outputStream.toByteArray(), mimeType);
        this.imageCrop = new ImageCrop(src);
        this.imageCrop.setAspect(Double.valueOf(1.0));
        this.imageCrop.setCircularCrop(true);
        this.imageCrop.setCrop(new Crop("%", 25, 25, 50, 50));
        this.imageCrop.setKeepSelection(true);
        cropButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.newCroppedPicture = this.imageCrop.getCroppedImageBase64();
            this.avatar.setImage(this.imageCrop.getCroppedImageDataUri());
            dialog.close();
        });
        dialogCancelButton.addClickListener((ComponentEventListener & Serializable)c -> dialog.close());
        HorizontalLayout buttonLayout = new HorizontalLayout(new Component[]{dialogCancelButton, cropButton});
        Div dialogLayout = new Div(new Component[]{this.imageCrop});
        dialogLayout.setSizeFull();
        buttonLayout.setWidthFull();
        buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        dialog.add(new Component[]{dialogLayout});
        dialog.getFooter().add(new Component[]{buttonLayout});
        dialog.open();
    }

    private String getImageAsBase64(byte[] src, String mimeType) {
        return src != null ? "data:" + mimeType + ";base64," + Base64.getEncoder().encodeToString(src) : null;
    }
}

