/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.GeolocationOptions;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapMarker;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@PageTitle(value="Track Location Demo")
@DemoSource
@Route(value="googlemaps/tracklocation", layout=GooglemapsDemoView.class)
public class TrackLocationDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.ROADMAP);
        gmaps.setSizeFull();
        gmaps.setZoom(15);
        this.add(new Component[]{gmaps});
        GeolocationOptions options = new GeolocationOptions(true, Long.valueOf(5000L), 0L);
        Button startLocationTrackingButton = new Button("Start tracking my location");
        Button stopLocationTrackingButton = new Button("Stop tracking my location");
        startLocationTrackingButton.addClickListener((ComponentEventListener & Serializable)e -> {
            gmaps.trackLocation(options);
            stopLocationTrackingButton.setEnabled(true);
        });
        startLocationTrackingButton.setDisableOnClick(true);
        stopLocationTrackingButton.addClickListener((ComponentEventListener & Serializable)e -> {
            gmaps.stopTrackLocation();
            startLocationTrackingButton.setEnabled(true);
        });
        stopLocationTrackingButton.setEnabled(false);
        stopLocationTrackingButton.setDisableOnClick(true);
        this.add(new Component[]{new HorizontalLayout(new Component[]{startLocationTrackingButton, stopLocationTrackingButton})});
        GoogleMapMarker locationMarker = new GoogleMapMarker();
        locationMarker.setCaption("You're here");
        locationMarker.setDraggable(false);
        gmaps.addMarker(locationMarker);
        gmaps.addLocationTrackingActivatedEventListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Location tracking was activated with track id: " + gmaps.getTrackLocationId())));
        gmaps.addCurrentLocationEventListener((ComponentEventListener & Serializable)e -> locationMarker.setPosition(((GoogleMap)e.getSource()).getCenter()));
        gmaps.addGeolocationErrorEventListener((ComponentEventListener & Serializable)e -> Notification.show((String)(e.isBrowserHasGeolocationSupport() ? "The geolocation service failed on retrieving your location." : "Your browser doesn't support geolocation.")));
    }
}

