/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.DemoSources;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.ControlPosition;
import com.flowingcode.vaadin.addons.googlemaps.CustomControl;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@PageTitle(value="Custom Controls Demo")
@DemoSources(value={@DemoSource, @DemoSource(value="/src/test/resources/META-INF/resources/frontend/styles/google-maps/custom-controls-demo-styles.css", caption="custom-controls-demo-styles.css")})
@Route(value="googlemaps/custom-controls", layout=GooglemapsDemoView.class)
@CssImport(value="./styles/google-maps/custom-controls-demo-styles.css")
public class CustomControlsDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.ROADMAP);
        gmaps.setSizeFull();
        this.add(new Component[]{gmaps});
        Button customControlButton1 = new Button("Custom Control 1");
        customControlButton1.setClassName("custom-control-button");
        CustomControl customControl1 = new CustomControl(customControlButton1, ControlPosition.TOP_CENTER);
        Button customControlButton2 = new Button("Custom Control 2");
        customControlButton2.setClassName("custom-control-button");
        CustomControl customControl2 = new CustomControl(customControlButton2, ControlPosition.LEFT_CENTER);
        gmaps.setCustomControls(new CustomControl[]{customControl1, customControl2});
        Button customControlButton3 = new Button("Custom Control 3");
        customControlButton3.setClassName("custom-control-button");
        CustomControl customControl3 = new CustomControl(customControlButton3, ControlPosition.BOTTOM_CENTER);
        Button addCustomControl3Button = this.createDemoButton("Add Custom Control 3");
        Button removeCustomControl3Button = this.createDemoButton("Remove Custom Control 3");
        Button removeAllCustomControlsButton = this.createDemoButton("Remove all controls");
        Button resetButton = this.createDemoButton("Reset");
        addCustomControl3Button.addClickListener((ComponentEventListener & Serializable)e -> {
            gmaps.addCustomControl(customControl3);
            removeCustomControl3Button.setEnabled(true);
            removeAllCustomControlsButton.setEnabled(true);
        });
        removeCustomControl3Button.addClickListener((ComponentEventListener & Serializable)e -> {
            gmaps.removeCustomControl(customControl3);
            addCustomControl3Button.setEnabled(true);
        });
        removeCustomControl3Button.setEnabled(false);
        removeAllCustomControlsButton.addClickListener((ComponentEventListener & Serializable)e -> {
            gmaps.removeCustomControls();
            addCustomControl3Button.setEnabled(true);
            removeCustomControl3Button.setEnabled(false);
            resetButton.setEnabled(true);
        });
        resetButton.addClickListener((ComponentEventListener & Serializable)e -> {
            gmaps.setCustomControls(new CustomControl[]{customControl1, customControl2});
            removeAllCustomControlsButton.setEnabled(true);
            addCustomControl3Button.setEnabled(true);
            removeCustomControl3Button.setEnabled(false);
        });
        this.add(new Component[]{new HorizontalLayout(new Component[]{addCustomControl3Button, removeCustomControl3Button, removeAllCustomControlsButton, resetButton})});
    }

    private Button createDemoButton(String caption) {
        Button button = new Button(caption);
        button.setDisableOnClick(true);
        return button;
    }
}

