/*-
 * #%L
 * Google Maps Addon
 * %%
 * Copyright (C) 2020 - 2024 Flowing Code
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

package com.flowingcode.vaadin.addons.googlemaps.maptypestyle;

import lombok.Getter;

/**
 * Enum representing the possible values to indicate whether and how the element appears on the map.
 */
public enum Visibility {

  ON("on"), OFF("off"), SIMPLIFIED("simplified");

  @Getter
  private String value;

  Visibility(String value) {
    this.value = value;
  }

}
