/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@PageTitle(value="Tilt & Rotation Demo")
@DemoSource
@Route(value="googlemaps/tilt-rotation", layout=GooglemapsDemoView.class)
public class TiltAndRotationDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.ROADMAP);
        gmaps.setSizeFull();
        gmaps.setCenter(new LatLon(37.7893719, -122.3942));
        gmaps.setMapId("90f87356969d889c");
        gmaps.setTilt(47.5);
        gmaps.setHeading(300.0);
        gmaps.setZoom(16);
        FlexLayout layout = new FlexLayout();
        layout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        Span currentTiltTitle = new Span("Current tilt value: ");
        Span currentTilt = new Span();
        currentTilt.setText(String.valueOf(gmaps.getTilt()));
        Span currentHeadingTitle = new Span("Current heading value: ");
        Span currentHeading = new Span();
        currentHeading.setText(String.valueOf(gmaps.getHeading()));
        VerticalLayout currentValuesLayout = new VerticalLayout(new Component[]{new HorizontalLayout(new Component[]{currentTiltTitle, currentTilt}), new HorizontalLayout(new Component[]{currentHeadingTitle, currentHeading})});
        currentValuesLayout.setSpacing(false);
        currentValuesLayout.getStyle().set("padding-left", "0");
        Span description = new Span("Initial Tilt value: 47.5 - Initial Heading value: 300");
        description.setWidthFull();
        Button tiltUpButton = new Button("Tilt Up", (ComponentEventListener & Serializable)e -> {
            gmaps.setTilt(gmaps.getTilt() + 20.0);
            currentTilt.setText(String.valueOf(gmaps.getTilt()));
        });
        Button tiltDownButton = new Button("Tilt Down", (ComponentEventListener & Serializable)e -> {
            gmaps.setTilt(gmaps.getTilt() - 20.0);
            currentTilt.setText(String.valueOf(gmaps.getTilt()));
        });
        Button rotateLeftButton = new Button("Rotate Left", (ComponentEventListener & Serializable)e -> {
            gmaps.setHeading(gmaps.getHeading() + 20.0);
            currentHeading.setText(String.valueOf(gmaps.getHeading()));
        });
        Button rotateRightButton = new Button("Rotate Right", (ComponentEventListener & Serializable)e -> {
            gmaps.setHeading(gmaps.getHeading() - 20.0);
            currentHeading.setText(String.valueOf(gmaps.getHeading()));
        });
        Button resetInitialButton = new Button("Reset to Initial Values", (ComponentEventListener & Serializable)e -> {
            gmaps.setHeading(300.0);
            gmaps.setTilt(47.5);
            currentTilt.setText(String.valueOf(gmaps.getTilt()));
            currentHeading.setText(String.valueOf(gmaps.getHeading()));
        });
        Span buttonsDescription = new Span("Play around with the following buttons to programmatically adjust tilt and heading in 20-degree increments:");
        buttonsDescription.setWidthFull();
        HorizontalLayout buttonsLayout = new HorizontalLayout(new Component[]{tiltUpButton, tiltDownButton, rotateLeftButton, rotateRightButton, resetInitialButton});
        buttonsLayout.getStyle().set("margin-top", "15px");
        layout.add(new Component[]{description, buttonsDescription, buttonsLayout, currentValuesLayout});
        this.add(new Component[]{gmaps, layout});
    }
}

