/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.DemoSources;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.ControlPosition;
import com.flowingcode.vaadin.addons.googlemaps.CustomControl;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapMarker;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@PageTitle(value="Geolocation Demo")
@DemoSources(value={@DemoSource, @DemoSource(value="/src/test/resources/META-INF/resources/frontend/styles/google-maps/geolocation-demo-styles.css", caption="geolocation-demo-styles.css")})
@Route(value="googlemaps/geolocation", layout=GooglemapsDemoView.class)
@CssImport(value="./styles/google-maps/geolocation-demo-styles.css")
public class GeolocationDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.ROADMAP);
        gmaps.setSizeFull();
        this.add(new Component[]{gmaps});
        Button currentLocationButton = new Button("Go to current location", (Component)VaadinIcon.CROSSHAIRS.create(), (ComponentEventListener & Serializable)e -> gmaps.goToCurrentLocation());
        currentLocationButton.setClassName("geolocation-button");
        CustomControl geolocationControl = new CustomControl(currentLocationButton, ControlPosition.TOP_CENTER);
        gmaps.setCustomControls(new CustomControl[]{geolocationControl});
        gmaps.addCurrentLocationEventListener((ComponentEventListener & Serializable)e -> gmaps.addMarker(new GoogleMapMarker("You are here!", gmaps.getCenter(), false, "http://maps.google.com/mapfiles/ms/micons/green.png")));
        gmaps.addGeolocationErrorEventListener((ComponentEventListener & Serializable)e -> Notification.show((String)(e.isBrowserHasGeolocationSupport() ? "The geolocation service failed on retrieving your location." : "Your browser doesn't support geolocation.")));
    }
}

