/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapMarker;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.flowingcode.vaadin.addons.googlemaps.MarkerLabel;
import com.flowingcode.vaadin.addons.googlemaps.ReflectionUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;

@PageTitle(value="Add Markers Demo")
@DemoSource
@Route(value="googlemaps/addmarkers", layout=GooglemapsDemoView.class)
public class AddMarkersDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.SATELLITE);
        gmaps.setSizeFull();
        gmaps.setCenter(new LatLon(-31.636036, -60.7055271));
        HashMap<String, String> markerColorsMap = new HashMap<String, String>();
        markerColorsMap.put("Red", "http://maps.google.com/mapfiles/ms/micons/red.png");
        markerColorsMap.put("Pink", "http://maps.google.com/mapfiles/ms/micons/pink.png");
        markerColorsMap.put("Blue", "http://maps.google.com/mapfiles/ms/micons/blue.png");
        markerColorsMap.put("Green", "http://maps.google.com/mapfiles/ms/micons/green.png");
        markerColorsMap.put("Purple", "http://maps.google.com/mapfiles/ms/micons/purple.png");
        markerColorsMap.put("Yellow", "http://maps.google.com/mapfiles/ms/micons/yellow.png");
        markerColorsMap.put("Orange", "http://maps.google.com/mapfiles/ms/micons/orange.png");
        markerColorsMap.put("Light blue", "http://maps.google.com/mapfiles/ms/micons/lightblue.png");
        ComboBox colorCB = new ComboBox("Color");
        ReflectionUtil.setItems((ComboBox<String>)colorCB, markerColorsMap.keySet());
        colorCB.setPlaceholder("Choose color");
        Checkbox draggable = new Checkbox("Draggable");
        Checkbox withRightClick = new Checkbox("Right Click");
        TextField labelText = new TextField();
        labelText.setPlaceholder("Label Text");
        labelText.setEnabled(false);
        Checkbox withLabel = new Checkbox("With Label");
        withLabel.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> labelText.setEnabled(((Boolean)event.getValue()).booleanValue()));
        Button addMarker = new Button("Add Marker", (ComponentEventListener & Serializable)ev -> {
            String markerColor = Optional.ofNullable((String)markerColorsMap.get(colorCB.getValue())).orElse("");
            Boolean isDraggable = (Boolean)draggable.getValue();
            GoogleMapMarker marker = new GoogleMapMarker("New Marker", gmaps.getCenter(), isDraggable.booleanValue(), markerColor);
            if (isDraggable.booleanValue()) {
                marker.addDragEndEventListener((ComponentEventListener & Serializable)e -> Notification.show((String)("Dragged to -> Latitude: " + e.getLatitude() + " - Longitude: " + e.getLongitude())));
            }
            if (((Boolean)withRightClick.getValue()).booleanValue()) {
                marker.addRightClickListener((ComponentEventListener & Serializable)e -> {
                    Div text = new Div(new Component[]{new Text("Alt key: " + e.isAltKey()), new HtmlComponent("br"), new Text("Shift key: " + e.isShiftKey()), new HtmlComponent("br"), new Text("Ctrol key: " + e.isCtrlKey()), new HtmlComponent("br"), new Text("Click counts: " + e.getClickCount()), new HtmlComponent("br"), new Text("Latitude: " + e.getLatitude()), new HtmlComponent("br"), new Text("Longitude: " + e.getLongitude())});
                    Notification notification = new Notification();
                    Button closeButton = new Button((Component)new Icon(VaadinIcon.CLOSE_SMALL));
                    closeButton.addClickListener((ComponentEventListener & Serializable)event -> notification.close());
                    HorizontalLayout layout = new HorizontalLayout(new Component[]{text, closeButton});
                    layout.setAlignItems(FlexComponent.Alignment.CENTER);
                    notification.add(new Component[]{layout});
                    notification.open();
                });
            }
            if (((Boolean)withLabel.getValue()).booleanValue()) {
                if (labelText.getValue().isEmpty()) {
                    Notification.show((String)"Please select a label for the marker");
                    return;
                }
                MarkerLabel label = new MarkerLabel(labelText.getValue());
                label.setColor("white");
                label.setFontWeight("bold");
                marker.setLabel(label);
            }
            gmaps.addMarker(marker);
            colorCB.clear();
            draggable.setValue((Object)false);
            withRightClick.setValue((Object)false);
            labelText.clear();
            withLabel.setValue((Object)false);
        });
        FlexLayout layout = new FlexLayout();
        layout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        addMarker.addClassName("margin-button");
        colorCB.addClassName("margin-button");
        labelText.addClassName("margin-button");
        layout.add(new Component[]{colorCB, draggable, withRightClick, withLabel, labelText, addMarker});
        layout.setAlignItems(FlexComponent.Alignment.BASELINE);
        layout.getStyle().set("margin-top", "0");
        this.add(new Component[]{gmaps, layout});
    }
}

