/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class MarkerLabel {
    @NonNull
    private String text;
    private String color;
    private String fontFamily;
    private String fontSize;
    private String fontWeight;
    private String className;

    public MarkerLabel(String text) {
        this.text = Objects.requireNonNull(text, "Text cannot be null");
    }

    public MarkerLabel(String text, String color, String fontSize) {
        this.text = Objects.requireNonNull(text, "Text cannot be null");
        this.color = color;
        this.fontSize = fontSize;
    }

    protected JsonObject getJson() {
        JsonObject js = Json.createObject();
        Optional.of(this.getText()).ifPresent(value -> js.put("text", value));
        Optional.ofNullable(this.getColor()).ifPresent(value -> js.put("color", value));
        Optional.ofNullable(this.getFontFamily()).ifPresent(value -> js.put("fontFamily", value));
        Optional.ofNullable(this.getFontSize()).ifPresent(value -> js.put("fontSize", value));
        Optional.ofNullable(this.getFontWeight()).ifPresent(value -> js.put("fontWeight", value));
        Optional.ofNullable(this.getClassName()).ifPresent(value -> js.put("className", value));
        return js;
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public String getFontFamily() {
        return this.fontFamily;
    }

    @Generated
    public String getFontSize() {
        return this.fontSize;
    }

    @Generated
    public String getFontWeight() {
        return this.fontWeight;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @Generated
    public void setColor(String color) {
        this.color = color;
    }

    @Generated
    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    @Generated
    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    @Generated
    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    @Generated
    public void setClassName(String className) {
        this.className = className;
    }
}

