/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.flowingcode.vaadin.addons.googlemaps.maptypestyle.ElementType;
import com.flowingcode.vaadin.addons.googlemaps.maptypestyle.FeatureType;
import com.flowingcode.vaadin.addons.googlemaps.maptypestyle.MapStyle;
import com.flowingcode.vaadin.addons.googlemaps.maptypestyle.StyleRules;
import com.flowingcode.vaadin.addons.googlemaps.maptypestyle.Visibility;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;

@PageTitle(value="Style Features")
@DemoSource
@Route(value="googlemaps/stylefeatures", layout=GooglemapsDemoView.class)
public class StyleFeaturesDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps1 = this.createGoogleMap(apiKey);
        VerticalLayout withoutStyleChanges = new VerticalLayout(new Component[]{this.createSpan("Map without style changes"), gmaps1});
        withoutStyleChanges.setSizeFull();
        GoogleMap gmaps2 = this.createGoogleMap(apiKey);
        VerticalLayout withStyleChanges = new VerticalLayout(new Component[]{this.createSpan("Hide all POIs and sets color and saturation to labels of the roads"), gmaps2});
        withStyleChanges.setSizeFull();
        StyleRules styleRule = new StyleRules();
        styleRule.setVisibility(Visibility.OFF);
        MapStyle mapStyle = new MapStyle(FeatureType.POI, styleRule);
        StyleRules styleRule2 = new StyleRules();
        styleRule2.setColor("#a98fcf");
        styleRule2.setSaturation(50.0);
        MapStyle mapStyle2 = new MapStyle(FeatureType.ROAD, ElementType.LABELS_TEXT_STROKE, styleRule2);
        gmaps2.setMapStyle(new MapStyle[]{mapStyle, mapStyle2});
        VerticalLayout verticalLayout = new VerticalLayout(new Component[]{withoutStyleChanges, withStyleChanges});
        verticalLayout.setSizeFull();
        this.add(new Component[]{verticalLayout});
    }

    private GoogleMap createGoogleMap(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.ROADMAP);
        gmaps.setSizeFull();
        gmaps.setCenter(new LatLon(-31.635175, -60.698405));
        gmaps.setZoom(16);
        return gmaps;
    }

    private Span createSpan(String text) {
        Span span = new Span(text);
        span.getElement().getStyle().set("font-weight", "bold");
        return span;
    }
}

