/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;

@PageTitle(value="Control Size Demo")
@DemoSource
@Route(value="googlemaps/controlsize", layout=GooglemapsDemoView.class)
public class ControlSizeDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps1 = this.createGoogleMap(apiKey);
        gmaps1.setControlSize(20);
        VerticalLayout controlSizeLayout = new VerticalLayout(new Component[]{this.createSpan("Map with custom size value for controls"), gmaps1});
        controlSizeLayout.setSizeFull();
        GoogleMap gmaps2 = this.createGoogleMap(apiKey);
        VerticalLayout noControlSizeLayout = new VerticalLayout(new Component[]{this.createSpan("Map with default size value for controls"), gmaps2});
        noControlSizeLayout.setSizeFull();
        HorizontalLayout horizontalLayout = new HorizontalLayout(new Component[]{controlSizeLayout, noControlSizeLayout});
        horizontalLayout.setSizeFull();
        this.add(new Component[]{horizontalLayout});
    }

    private GoogleMap createGoogleMap(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.ROADMAP);
        gmaps.setSizeFull();
        gmaps.setZoom(5);
        gmaps.setCenter(new LatLon(-35.198155, -65.776366));
        return gmaps;
    }

    private Span createSpan(String text) {
        Span span = new Span(text);
        span.getElement().getStyle().set("font-weight", "bold");
        return span;
    }
}

