/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.googlemaps.CustomControl;
import com.flowingcode.vaadin.addons.googlemaps.GeolocationOptions;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapIcon;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapMarker;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPoint;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPolygon;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPolyline;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.flowingcode.vaadin.addons.googlemaps.LatLonBounds;
import com.flowingcode.vaadin.addons.googlemaps.maptypestyle.MapStyle;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

@Tag(value="google-map")
@JsModule.Container(value={@JsModule(value="@flowingcode/google-map/google-map.js"), @JsModule(value="./googlemaps/geolocation.js")})
@NpmPackage.Container(value={@NpmPackage(value="@flowingcode/google-map", version="3.8.2"), @NpmPackage(value="@googlemaps/markerclusterer", version="2.0.8")})
public class GoogleMap
extends Component
implements HasSize {
    private Integer trackLocationId = null;
    private List<CustomControl> customControls = new ArrayList<CustomControl>();

    public GoogleMap(String apiKey, String clientId, String language) {
        this.getElement().setAttribute("api-key", apiKey);
        if (!StringUtils.isEmpty((CharSequence)clientId)) {
            this.getElement().setAttribute("client-id", clientId);
        }
        if (!StringUtils.isEmpty((CharSequence)language)) {
            this.getElement().setAttribute("language", language);
        }
    }

    @Synchronize(value={"google-map-idle"})
    public Double getLatitude() {
        return this.getElement().getProperty("latitude", 0.0);
    }

    @Synchronize(value={"google-map-idle"})
    public Double getLongitude() {
        return this.getElement().getProperty("longitude", 0.0);
    }

    public void setCenter(LatLon center) {
        this.getElement().setProperty("latitude", center.getLat());
        this.getElement().setProperty("longitude", center.getLon());
    }

    public LatLon getCenter() {
        LatLon result = new LatLon();
        result.setLat(this.getLatitude());
        result.setLon(this.getLongitude());
        return result;
    }

    public void setZoom(int zoom) {
        this.getElement().setProperty("zoom", (double)zoom);
    }

    @Synchronize(value={"google-map-idle"})
    public int getZoom() {
        return this.getElement().getProperty("zoom", 0);
    }

    public GoogleMapMarker addMarker(String caption, LatLon position, boolean draggable, String iconUrl) {
        GoogleMapMarker gmm = new GoogleMapMarker(caption, position, draggable, iconUrl);
        this.addMarker(gmm);
        return gmm;
    }

    public GoogleMapMarker addMarker(String caption, LatLon position, boolean draggable, GoogleMapIcon icon) {
        GoogleMapMarker gmm = new GoogleMapMarker(caption, position, draggable, icon);
        this.addMarker(gmm);
        return gmm;
    }

    public GoogleMapPolygon addPolygon(List<GoogleMapPoint> points) {
        GoogleMapPolygon polygon = new GoogleMapPolygon(points);
        this.addPolygon(polygon);
        return polygon;
    }

    public void addPolygon(GoogleMapPolygon polygon) {
        this.getElement().appendChild(new Element[]{polygon.getElement()});
        if (this.getElement().getParent() != null) {
            this.getElement().executeJs("this._updateObjects()", new Serializable[0]);
        }
    }

    public void removePolygon(GoogleMapPolygon polygon) {
        this.getElement().removeChild(new Element[]{polygon.getElement()});
        this.getElement().executeJs("this._updateObjects()", new Serializable[0]);
    }

    public GoogleMapPolyline addPolyline(List<GoogleMapPoint> points) {
        GoogleMapPolyline polyline = new GoogleMapPolyline(points);
        this.addPolyline(polyline);
        return polyline;
    }

    public void addPolyline(GoogleMapPolyline polyline) {
        this.getElement().appendChild(new Element[]{polyline.getElement()});
        if (this.getElement().getParent() != null) {
            this.getElement().executeJs("this._updateObjects()", new Serializable[0]);
        }
    }

    public void removePolyline(GoogleMapPolyline polyline) {
        this.getElement().removeChild(new Element[]{polyline.getElement()});
        this.getElement().executeJs("this._updateObjects()", new Serializable[0]);
    }

    public void addMarker(GoogleMapMarker marker) {
        this.getElement().appendChild(new Element[]{marker.getElement()});
        if (this.getElement().getParent() != null) {
            this.getElement().executeJs("this._updateMarkers()", new Serializable[0]);
        }
    }

    public void removeMarker(GoogleMapMarker marker) {
        this.getElement().removeChild(new Element[]{marker.getElement()});
        this.getElement().executeJs("this._updateMarkers()", new Serializable[0]);
    }

    public void setMapType(MapType type) {
        this.getElement().setProperty("mapType", type.name().toLowerCase());
    }

    public MapType getMapType() {
        return MapType.valueOf(this.getElement().getProperty("mapType").toUpperCase());
    }

    public boolean isDraggable() {
        return this.getElement().getProperty("draggable", true);
    }

    public void setDraggable(boolean draggable) {
        this.getElement().setProperty("draggable", draggable);
    }

    public void setMaxZoom(int maxZoom) {
        this.getElement().setProperty("maxZoom", (double)maxZoom);
    }

    public int getMaxZoom() {
        return this.getElement().getProperty("maxZoom", 1);
    }

    public void setMinZoom(int minZoom) {
        this.getElement().setProperty("minZoom", (double)minZoom);
    }

    public int getMinZoom() {
        return this.getElement().getProperty("minZoom", 1);
    }

    public void disableRotateControl(boolean disable) {
        this.getElement().setProperty("disableRotateControl", disable);
    }

    public void disableStreetViewControl(boolean disable) {
        this.getElement().setProperty("disableStreetViewControl", disable);
    }

    public void disableMapTypeControl(boolean disable) {
        this.getElement().setProperty("disableMapTypeControl", disable);
    }

    public void disableZoomControl(boolean disable) {
        this.getElement().setProperty("disableZoomControl", disable);
    }

    public void disableFullScreenControl(boolean disable) {
        this.getElement().setProperty("disableFullScreenControl", disable);
    }

    public void disableScaleControl(boolean disable) {
        this.getElement().setProperty("disableScaleControl", disable);
    }

    public void setMapId(String mapId) {
        this.getElement().setProperty("mapId", mapId);
    }

    public String getMapId() {
        return this.getElement().getProperty("mapId");
    }

    public void setControlSize(int controlSize) {
        this.getElement().setProperty("controlSize", (double)controlSize);
    }

    public int getControlSize() {
        return this.getElement().getProperty("controlSize", 0);
    }

    public void setKml(String kml) {
        this.getElement().setProperty("kml", kml);
    }

    public String getKml() {
        return this.getElement().getProperty("kml");
    }

    public void enableMarkersClustering() {
        this.getElement().setProperty("enableMarkersClustering", true);
    }

    public void setTilt(double tilt) {
        this.getElement().setProperty("tilt", tilt);
    }

    public double getTilt() {
        return this.getElement().getProperty("tilt", 45.0);
    }

    public void setHeading(double heading) {
        this.getElement().setProperty("heading", heading);
    }

    public double getHeading() {
        return this.getElement().getProperty("heading", 0.0);
    }

    public Registration addClickListener(ComponentEventListener<GoogleMapClickEvent> listener) {
        this.getElement().setProperty("clickable", true);
        this.getElement().setProperty("clickEvents", true);
        DomListenerRegistration registration = this.getElement().addEventListener("google-map-click", (DomEventListener & Serializable)ev -> {
            JsonObject latLng = (JsonObject)ev.getEventData().get("event.detail.latLng");
            listener.onComponentEvent((ComponentEvent)new GoogleMapClickEvent(this, true, (JsonValue)latLng));
        }).addEventData("event.detail.latLng");
        return () -> ((DomListenerRegistration)registration).remove();
    }

    public Registration addRightClickListener(ComponentEventListener<GoogleMapClickEvent> listener) {
        this.getElement().setProperty("clickable", true);
        this.getElement().setProperty("clickEvents", true);
        DomListenerRegistration registration = this.getElement().addEventListener("google-map-rightclick", (DomEventListener & Serializable)ev -> {
            JsonObject latLng = (JsonObject)ev.getEventData().get("event.detail.latLng");
            listener.onComponentEvent((ComponentEvent)new GoogleMapClickEvent(this, true, (JsonValue)latLng));
        }).addEventData("event.detail.latLng");
        return () -> ((DomListenerRegistration)registration).remove();
    }

    public void goToCurrentLocation() {
        this.goToCurrentLocation(null);
    }

    public void goToCurrentLocation(GeolocationOptions options) {
        JsonObject optionsJson = options == null ? Json.createObject() : options.toJson();
        this.getElement().executeJs("geolocation.get($0, $1)", new Serializable[]{this, optionsJson});
    }

    @ClientCallable
    private void handleGeolocation(double latitude, double longitude) {
        this.setCenter(new LatLon(latitude, longitude));
        ComponentUtil.fireEvent((Component)this, (ComponentEvent)new CurrentLocationEvent(this, false));
    }

    @ClientCallable
    private void handleGeolocationError(boolean browserHasGeolocationSupport) {
        ComponentUtil.fireEvent((Component)this, (ComponentEvent)new GeolocationErrorEvent(this, false, browserHasGeolocationSupport));
    }

    public Registration addCurrentLocationEventListener(ComponentEventListener<CurrentLocationEvent> listener) {
        return this.addListener(CurrentLocationEvent.class, listener);
    }

    public Registration addGeolocationErrorEventListener(ComponentEventListener<GeolocationErrorEvent> listener) {
        return this.addListener(GeolocationErrorEvent.class, listener);
    }

    public void trackLocation() {
        this.trackLocation(null);
    }

    public void trackLocation(GeolocationOptions options) {
        if (this.getTrackLocationId() != null) {
            throw new IllegalStateException("A tracking location session is already active. Please stop the current session before starting a new one.");
        }
        JsonObject optionsJson = options == null ? Json.createObject() : options.toJson();
        this.getElement().executeJs("return geolocation.trackLocation($0, $1)", new Serializable[]{this, optionsJson}).then(Integer.class, (SerializableConsumer & Serializable)trackLocationId -> {
            this.trackLocationId = trackLocationId;
            ComponentUtil.fireEvent((Component)this, (ComponentEvent)new LocationTrackingActivatedEvent(this, false));
        });
    }

    public Integer getTrackLocationId() {
        return this.trackLocationId;
    }

    public Registration addLocationTrackingActivatedEventListener(ComponentEventListener<LocationTrackingActivatedEvent> listener) {
        return this.addListener(LocationTrackingActivatedEvent.class, listener);
    }

    public void stopTrackLocation() {
        if (this.trackLocationId != null) {
            this.getElement().executeJs("geolocation.clearTracking($0)", new Serializable[]{this.trackLocationId});
            this.trackLocationId = null;
        }
    }

    public CompletableFuture<LatLonBounds> getBounds() {
        return this.getElement().executeJs("return this.map.getBounds()", new Serializable[0]).toCompletableFuture(JsonObject.class).thenApply(result -> new LatLonBounds((JsonObject)result));
    }

    public void setClusteringRenderer(String customRenderer) {
        this.getElement().setProperty("customRenderer", customRenderer);
    }

    public Registration addMapIdleListener(ComponentEventListener<GoogleMapIdleEvent> listener) {
        DomListenerRegistration registration = this.getElement().addEventListener("google-map-idle", (DomEventListener & Serializable)ev -> listener.onComponentEvent((ComponentEvent)new GoogleMapIdleEvent(this, true)));
        return () -> ((DomListenerRegistration)registration).remove();
    }

    public Registration addGoogleMapBoundsChangedListener(ComponentEventListener<GoogleMapBoundsChangedEvent> listener) {
        DomListenerRegistration registration = this.getElement().addEventListener("google-map-bounds_changed", (DomEventListener & Serializable)ev -> listener.onComponentEvent((ComponentEvent)new GoogleMapBoundsChangedEvent(this, true, new LatLonBounds((JsonObject)ev.getEventData().get("event.detail"))))).debounce(1000, DebouncePhase.TRAILING, new DebouncePhase[0]).addEventData("event.detail");
        return () -> ((DomListenerRegistration)registration).remove();
    }

    @Deprecated
    public void addCustomControls(CustomControl ... customControls) {
        JsonArray jsonArray = Json.createArray();
        for (int i = 0; i < customControls.length; ++i) {
            CustomControl customControl = customControls[i];
            jsonArray.set(i, (JsonValue)customControl.getJson(i));
            customControl.getControlButton().getElement().setAttribute("slot", "customControlSlot_" + i);
            this.getElement().appendChild(new Element[]{customControl.getControlButton().getElement()});
        }
        this.getElement().setPropertyJson("customControls", (JsonValue)jsonArray);
    }

    public void setCustomControls(CustomControl ... customControls) {
        this.customControls.clear();
        this.getElement().executeJs("this._removeCustomControls()", new Serializable[0]).then((SerializableConsumer & Serializable)e -> {
            JsonArray jsonArray = Json.createArray();
            for (int i = 0; i < customControls.length; ++i) {
                CustomControl customControl = customControls[i];
                jsonArray.set(i, (JsonValue)customControl.getJson(i));
                customControl.getControlButton().getElement().setAttribute("slot", "customControlSlot_" + i);
                this.getElement().appendChild(new Element[]{customControl.getControlButton().getElement()});
                this.customControls.add(customControl);
            }
            this.getElement().setPropertyJson("customControls", (JsonValue)jsonArray);
        });
    }

    public void addCustomControl(CustomControl customControl) {
        this.customControls.add(customControl);
        this.setCustomControls((CustomControl[])this.customControls.stream().toArray(CustomControl[]::new));
    }

    public void removeCustomControl(CustomControl customControl) {
        this.customControls.remove(customControl);
        this.setCustomControls((CustomControl[])this.customControls.stream().toArray(CustomControl[]::new));
    }

    public void removeCustomControls() {
        this.customControls.clear();
        this.getElement().executeJs("this._removeCustomControls()", new Serializable[0]);
    }

    public Registration addFullScreenListener(ComponentEventListener<FullScreenEvent> listener) {
        DomListenerRegistration registration = this.getElement().addEventListener("fullscreenchange", (DomEventListener & Serializable)ev -> this.getElement().executeJs("var isFullScreen = document.fullScreen ||\r\n document.mozFullScreen ||\r\n document.webkitIsFullScreen;\r\n return isFullScreen != null ? isFullScreen : false;", new Serializable[0]).then(Boolean.class, (SerializableConsumer & Serializable)isFullScreen -> listener.onComponentEvent((ComponentEvent)new FullScreenEvent(this, true, (boolean)isFullScreen))));
        return () -> ((DomListenerRegistration)registration).remove();
    }

    public void closeFullScreen() {
        this.getElement().executeJs("document.exitFullscreen();", new Serializable[0]);
    }

    public void setMapStyle(MapStyle ... mapStyles) {
        JsonArray jsonArray = Json.createArray();
        for (int i = 0; i < mapStyles.length; ++i) {
            MapStyle mapStyle = mapStyles[i];
            jsonArray.set(i, (JsonValue)mapStyle.getJson());
        }
        this.getElement().setPropertyJson("styles", (JsonValue)jsonArray);
    }

    public static enum MapType {
        ROADMAP,
        SATELLITE,
        HYBRID,
        TERRAIN;

    }

    public class CurrentLocationEvent
    extends ComponentEvent<GoogleMap> {
        public CurrentLocationEvent(GoogleMap source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public class GeolocationErrorEvent
    extends ComponentEvent<GoogleMap> {
        private boolean browserHasGeolocationSupport;

        public GeolocationErrorEvent(GoogleMap source, boolean fromClient, boolean browserHasGeolocationSupport) {
            super((Component)source, fromClient);
            this.browserHasGeolocationSupport = browserHasGeolocationSupport;
        }

        public boolean isBrowserHasGeolocationSupport() {
            return this.browserHasGeolocationSupport;
        }
    }

    public class LocationTrackingActivatedEvent
    extends ComponentEvent<GoogleMap> {
        public LocationTrackingActivatedEvent(GoogleMap source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static class FullScreenEvent
    extends ComponentEvent<GoogleMap> {
        private boolean isFullScreen;

        public FullScreenEvent(GoogleMap source, boolean fromClient, boolean isFullScreen) {
            super((Component)source, true);
            this.isFullScreen = isFullScreen;
        }

        public boolean isFullScreen() {
            return this.isFullScreen;
        }
    }

    public static class GoogleMapBoundsChangedEvent
    extends ComponentEvent<GoogleMap> {
        private final LatLonBounds bounds;

        public GoogleMapBoundsChangedEvent(GoogleMap source, boolean fromClient, LatLonBounds latLonBounds) {
            super((Component)source, true);
            this.bounds = latLonBounds;
        }

        public LatLonBounds getBounds() {
            return this.bounds;
        }
    }

    public static class GoogleMapIdleEvent
    extends ComponentEvent<GoogleMap> {
        public GoogleMapIdleEvent(GoogleMap source, boolean fromClient) {
            super((Component)source, true);
        }
    }

    public static class GoogleMapClickEvent
    extends ClickEvent<GoogleMap> {
        private final double lat;
        private final double lon;

        public double getLatitude() {
            return this.lat;
        }

        public double getLongitude() {
            return this.lon;
        }

        public GoogleMapClickEvent(GoogleMap source, boolean fromClient, @EventData(value="event.detail.latLng") JsonValue latLng) {
            super((Component)source);
            this.lat = ((JsonObject)latLng).getNumber("lat");
            this.lon = ((JsonObject)latLng).getNumber("lng");
        }
    }
}

