/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPoint;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPolygon;
import com.flowingcode.vaadin.addons.googlemaps.Icon;
import com.flowingcode.vaadin.addons.googlemaps.IconSequence;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.List;

@Tag(value="google-map-poly")
@JsModule.Container(value={@JsModule(value="@flowingcode/google-map/google-map-poly.js"), @JsModule(value="@flowingcode/google-map/google-map-point.js")})
@NpmPackage.Container(value={@NpmPackage(value="@flowingcode/google-map", version="3.8.2"), @NpmPackage(value="@googlemaps/markerclusterer", version="2.0.8")})
public abstract class GoogleMapPoly
extends Component {
    private static final double DEFAULT_FILL_OPACITY = 0.5;
    private static final String DEFAULT_FILL_COLOR = "blue";

    public GoogleMapPoly(List<GoogleMapPoint> points) {
        this.getElement().removeProperty("draggable");
        this.setFillColor(DEFAULT_FILL_COLOR);
        this.setFillOpacity(0.5);
        this.setPoints(points);
        this.getElement().setAttribute("slot", "objects");
    }

    public void setFillOpacity(double opacity) {
        this.getElement().setProperty("fillOpacity", opacity);
    }

    public double getFillOpacity() {
        return this.getElement().getProperty("fillOpacity", 1.0);
    }

    public void setStrokeOpacity(double opacity) {
        this.getElement().setProperty("strokeOpacity", opacity);
    }

    public double getStrokeOpacity() {
        return this.getElement().getProperty("strokeOpacity", 1.0);
    }

    public void setStrokePosition(StrokePosition position) {
        this.getElement().setProperty("strokePosition", position.name().toLowerCase());
    }

    public StrokePosition getStrokePosition() {
        return StrokePosition.valueOf(this.getElement().getProperty("strokePosition").toUpperCase());
    }

    public void setStrokeWeight(double weight) {
        this.getElement().setProperty("strokeWeight", weight);
    }

    public double getStrokeWeight() {
        return this.getElement().getProperty("strokeWeight", 1.0);
    }

    public void setZIndex(double zindex) {
        this.getElement().setProperty("zIndex", zindex);
    }

    public double getZIndex() {
        return this.getElement().getProperty("zIndex", 1.0);
    }

    public void setFillColor(String string) {
        this.getElement().setProperty("fillColor", string);
    }

    public String getFillColor() {
        return this.getElement().getProperty("fillColor");
    }

    public void setStrokeColor(String string) {
        this.getElement().setProperty("strokeColor", string);
    }

    public String getStrokeColor() {
        return this.getElement().getProperty("strokeColor");
    }

    public void setClosed(boolean b) {
        this.getElement().setProperty("closed", b);
    }

    public boolean isClosed() {
        return this.getElement().getProperty("closed", false);
    }

    public void setGeodesic(boolean b) {
        this.getElement().setProperty("geodesic", b);
    }

    public boolean isGeodesic() {
        return this.getElement().getProperty("geodesic", false);
    }

    public void setPoints(Iterable<GoogleMapPoint> points) {
        points.forEach(point -> this.getElement().appendChild(new Element[]{point.getElement()}));
    }

    public GoogleMapPoint addPoint(LatLon position) {
        GoogleMapPoint point = new GoogleMapPoint(position.getLat(), position.getLon());
        this.getElement().appendChild(new Element[]{point.getElement()});
        return point;
    }

    public void addPoint(GoogleMapPoint point) {
        this.getElement().appendChild(new Element[]{point.getElement()});
    }

    public void removePoint(GoogleMapPoint point) {
        this.getElement().removeChild(new Element[]{point.getElement()});
    }

    public Registration addClickListener(ComponentEventListener<GoogleMapPolyClickEvent> listener) {
        this.getElement().setProperty("clickable", true);
        this.getElement().setProperty("clickEvents", true);
        return this.addListener(GoogleMapPolyClickEvent.class, listener);
    }

    @Deprecated
    public void setIcons(Icon ... icons) {
        JsonArray jsonArray = Json.createArray();
        for (int i = 0; i < icons.length; ++i) {
            jsonArray.set(i, (JsonValue)icons[i].getJson());
        }
        this.getElement().setPropertyJson("icons", (JsonValue)jsonArray);
    }

    public void setIcons(IconSequence ... icons) {
        JsonArray jsonArray = Json.createArray();
        for (int i = 0; i < icons.length; ++i) {
            jsonArray.set(i, (JsonValue)icons[i].getJson());
        }
        this.getElement().setPropertyJson("icons", (JsonValue)jsonArray);
    }

    public static enum StrokePosition {
        CENTER,
        INSIDE,
        OUTSIDE;

    }

    @DomEvent(value="google-map-poly-click")
    public static class GoogleMapPolyClickEvent
    extends ClickEvent<GoogleMapPolygon> {
        private final double lat;
        private final double lon;

        public GoogleMapPolyClickEvent(GoogleMapPoly source, boolean fromClient, @EventData(value="event.detail.latLng") JsonValue latLng) {
            super((Component)source);
            this.lat = ((JsonObject)latLng).getNumber("lat");
            this.lon = ((JsonObject)latLng).getNumber("lng");
        }

        public double getLatitude() {
            return this.lat;
        }

        public double getLongitude() {
            return this.lon;
        }
    }
}

